/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceTopologyRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceTopologyResponse;
import software.amazon.awssdk.services.ec2.model.InstanceTopology;

public class DescribeInstanceTopologyIterable
implements SdkIterable<DescribeInstanceTopologyResponse> {
    private final Ec2Client client;
    private final DescribeInstanceTopologyRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeInstanceTopologyIterable(Ec2Client client, DescribeInstanceTopologyRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeInstanceTopologyResponseFetcher();
    }

    public Iterator<DescribeInstanceTopologyResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<InstanceTopology> instances() {
        Function<DescribeInstanceTopologyResponse, Iterator> getIterator = response -> {
            if (response != null && response.instances() != null) {
                return response.instances().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeInstanceTopologyResponseFetcher
    implements SyncPageFetcher<DescribeInstanceTopologyResponse> {
        private DescribeInstanceTopologyResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInstanceTopologyResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeInstanceTopologyResponse nextPage(DescribeInstanceTopologyResponse previousPage) {
            if (previousPage == null) {
                return DescribeInstanceTopologyIterable.this.client.describeInstanceTopology(DescribeInstanceTopologyIterable.this.firstRequest);
            }
            return DescribeInstanceTopologyIterable.this.client.describeInstanceTopology((DescribeInstanceTopologyRequest)((Object)DescribeInstanceTopologyIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

