/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AsnAssociation;
import software.amazon.awssdk.services.ec2.model.AsnAssociationSetCopier;
import software.amazon.awssdk.services.ec2.model.ByoipCidrState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ByoipCidr
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ByoipCidr> {
    private static final SdkField<String> CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Cidr").getter(ByoipCidr.getter(ByoipCidr::cidr)).setter(ByoipCidr.setter(Builder::cidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cidr").unmarshallLocationName("cidr").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ByoipCidr.getter(ByoipCidr::description)).setter(ByoipCidr.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<List<AsnAssociation>> ASN_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AsnAssociations").getter(ByoipCidr.getter(ByoipCidr::asnAssociations)).setter(ByoipCidr.setter(Builder::asnAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AsnAssociationSet").unmarshallLocationName("asnAssociationSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AsnAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(ByoipCidr.getter(ByoipCidr::statusMessage)).setter(ByoipCidr.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").unmarshallLocationName("statusMessage").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(ByoipCidr.getter(ByoipCidr::stateAsString)).setter(ByoipCidr.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<String> NETWORK_BORDER_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkBorderGroup").getter(ByoipCidr.getter(ByoipCidr::networkBorderGroup)).setter(ByoipCidr.setter(Builder::networkBorderGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkBorderGroup").unmarshallLocationName("networkBorderGroup").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDR_FIELD, DESCRIPTION_FIELD, ASN_ASSOCIATIONS_FIELD, STATUS_MESSAGE_FIELD, STATE_FIELD, NETWORK_BORDER_GROUP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String cidr;
    private final String description;
    private final List<AsnAssociation> asnAssociations;
    private final String statusMessage;
    private final String state;
    private final String networkBorderGroup;

    private ByoipCidr(BuilderImpl builder) {
        this.cidr = builder.cidr;
        this.description = builder.description;
        this.asnAssociations = builder.asnAssociations;
        this.statusMessage = builder.statusMessage;
        this.state = builder.state;
        this.networkBorderGroup = builder.networkBorderGroup;
    }

    public final String cidr() {
        return this.cidr;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasAsnAssociations() {
        return this.asnAssociations != null && !(this.asnAssociations instanceof SdkAutoConstructList);
    }

    public final List<AsnAssociation> asnAssociations() {
        return this.asnAssociations;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final ByoipCidrState state() {
        return ByoipCidrState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String networkBorderGroup() {
        return this.networkBorderGroup;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAsnAssociations() ? this.asnAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkBorderGroup());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ByoipCidr)) {
            return false;
        }
        ByoipCidr other = (ByoipCidr)obj;
        return Objects.equals(this.cidr(), other.cidr()) && Objects.equals(this.description(), other.description()) && this.hasAsnAssociations() == other.hasAsnAssociations() && Objects.equals(this.asnAssociations(), other.asnAssociations()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.networkBorderGroup(), other.networkBorderGroup());
    }

    public final String toString() {
        return ToString.builder((String)"ByoipCidr").add("Cidr", (Object)this.cidr()).add("Description", (Object)this.description()).add("AsnAssociations", this.hasAsnAssociations() ? this.asnAssociations() : null).add("StatusMessage", (Object)this.statusMessage()).add("State", (Object)this.stateAsString()).add("NetworkBorderGroup", (Object)this.networkBorderGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Cidr": {
                return Optional.ofNullable(clazz.cast(this.cidr()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "AsnAssociations": {
                return Optional.ofNullable(clazz.cast(this.asnAssociations()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "NetworkBorderGroup": {
                return Optional.ofNullable(clazz.cast(this.networkBorderGroup()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ByoipCidr, T> g) {
        return obj -> g.apply((ByoipCidr)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String cidr;
        private String description;
        private List<AsnAssociation> asnAssociations = DefaultSdkAutoConstructList.getInstance();
        private String statusMessage;
        private String state;
        private String networkBorderGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(ByoipCidr model) {
            this.cidr(model.cidr);
            this.description(model.description);
            this.asnAssociations(model.asnAssociations);
            this.statusMessage(model.statusMessage);
            this.state(model.state);
            this.networkBorderGroup(model.networkBorderGroup);
        }

        public final String getCidr() {
            return this.cidr;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        @Override
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<AsnAssociation.Builder> getAsnAssociations() {
            List<AsnAssociation.Builder> result = AsnAssociationSetCopier.copyToBuilder(this.asnAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAsnAssociations(Collection<AsnAssociation.BuilderImpl> asnAssociations) {
            this.asnAssociations = AsnAssociationSetCopier.copyFromBuilder(asnAssociations);
        }

        @Override
        public final Builder asnAssociations(Collection<AsnAssociation> asnAssociations) {
            this.asnAssociations = AsnAssociationSetCopier.copy(asnAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder asnAssociations(AsnAssociation ... asnAssociations) {
            this.asnAssociations(Arrays.asList(asnAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder asnAssociations(Consumer<AsnAssociation.Builder> ... asnAssociations) {
            this.asnAssociations(Stream.of(asnAssociations).map(c -> (AsnAssociation)((AsnAssociation.Builder)AsnAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ByoipCidrState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getNetworkBorderGroup() {
            return this.networkBorderGroup;
        }

        public final void setNetworkBorderGroup(String networkBorderGroup) {
            this.networkBorderGroup = networkBorderGroup;
        }

        @Override
        public final Builder networkBorderGroup(String networkBorderGroup) {
            this.networkBorderGroup = networkBorderGroup;
            return this;
        }

        public ByoipCidr build() {
            return new ByoipCidr(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ByoipCidr> {
        public Builder cidr(String var1);

        public Builder description(String var1);

        public Builder asnAssociations(Collection<AsnAssociation> var1);

        public Builder asnAssociations(AsnAssociation ... var1);

        public Builder asnAssociations(Consumer<AsnAssociation.Builder> ... var1);

        public Builder statusMessage(String var1);

        public Builder state(String var1);

        public Builder state(ByoipCidrState var1);

        public Builder networkBorderGroup(String var1);
    }
}

