/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateVpcEndpointConnectionNotificationRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateVpcEndpointConnectionNotificationRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(CreateVpcEndpointConnectionNotificationRequest.getter(CreateVpcEndpointConnectionNotificationRequest::dryRun)).setter(CreateVpcEndpointConnectionNotificationRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<String> SERVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceId").getter(CreateVpcEndpointConnectionNotificationRequest.getter(CreateVpcEndpointConnectionNotificationRequest::serviceId)).setter(CreateVpcEndpointConnectionNotificationRequest.setter(Builder::serviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceId").unmarshallLocationName("ServiceId").build()}).build();
    private static final SdkField<String> VPC_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcEndpointId").getter(CreateVpcEndpointConnectionNotificationRequest.getter(CreateVpcEndpointConnectionNotificationRequest::vpcEndpointId)).setter(CreateVpcEndpointConnectionNotificationRequest.setter(Builder::vpcEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointId").unmarshallLocationName("VpcEndpointId").build()}).build();
    private static final SdkField<String> CONNECTION_NOTIFICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionNotificationArn").getter(CreateVpcEndpointConnectionNotificationRequest.getter(CreateVpcEndpointConnectionNotificationRequest::connectionNotificationArn)).setter(CreateVpcEndpointConnectionNotificationRequest.setter(Builder::connectionNotificationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionNotificationArn").unmarshallLocationName("ConnectionNotificationArn").build()}).build();
    private static final SdkField<List<String>> CONNECTION_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConnectionEvents").getter(CreateVpcEndpointConnectionNotificationRequest.getter(CreateVpcEndpointConnectionNotificationRequest::connectionEvents)).setter(CreateVpcEndpointConnectionNotificationRequest.setter(Builder::connectionEvents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionEvents").unmarshallLocationName("ConnectionEvents").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateVpcEndpointConnectionNotificationRequest.getter(CreateVpcEndpointConnectionNotificationRequest::clientToken)).setter(CreateVpcEndpointConnectionNotificationRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, SERVICE_ID_FIELD, VPC_ENDPOINT_ID_FIELD, CONNECTION_NOTIFICATION_ARN_FIELD, CONNECTION_EVENTS_FIELD, CLIENT_TOKEN_FIELD));
    private final Boolean dryRun;
    private final String serviceId;
    private final String vpcEndpointId;
    private final String connectionNotificationArn;
    private final List<String> connectionEvents;
    private final String clientToken;

    private CreateVpcEndpointConnectionNotificationRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.serviceId = builder.serviceId;
        this.vpcEndpointId = builder.vpcEndpointId;
        this.connectionNotificationArn = builder.connectionNotificationArn;
        this.connectionEvents = builder.connectionEvents;
        this.clientToken = builder.clientToken;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String serviceId() {
        return this.serviceId;
    }

    public final String vpcEndpointId() {
        return this.vpcEndpointId;
    }

    public final String connectionNotificationArn() {
        return this.connectionNotificationArn;
    }

    public final boolean hasConnectionEvents() {
        return this.connectionEvents != null && !(this.connectionEvents instanceof SdkAutoConstructList);
    }

    public final List<String> connectionEvents() {
        return this.connectionEvents;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionNotificationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnectionEvents() ? this.connectionEvents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcEndpointConnectionNotificationRequest)) {
            return false;
        }
        CreateVpcEndpointConnectionNotificationRequest other = (CreateVpcEndpointConnectionNotificationRequest)((Object)obj);
        return Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.serviceId(), other.serviceId()) && Objects.equals(this.vpcEndpointId(), other.vpcEndpointId()) && Objects.equals(this.connectionNotificationArn(), other.connectionNotificationArn()) && this.hasConnectionEvents() == other.hasConnectionEvents() && Objects.equals(this.connectionEvents(), other.connectionEvents()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateVpcEndpointConnectionNotificationRequest").add("DryRun", (Object)this.dryRun()).add("ServiceId", (Object)this.serviceId()).add("VpcEndpointId", (Object)this.vpcEndpointId()).add("ConnectionNotificationArn", (Object)this.connectionNotificationArn()).add("ConnectionEvents", this.hasConnectionEvents() ? this.connectionEvents() : null).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "ServiceId": {
                return Optional.ofNullable(clazz.cast(this.serviceId()));
            }
            case "VpcEndpointId": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointId()));
            }
            case "ConnectionNotificationArn": {
                return Optional.ofNullable(clazz.cast(this.connectionNotificationArn()));
            }
            case "ConnectionEvents": {
                return Optional.ofNullable(clazz.cast(this.connectionEvents()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateVpcEndpointConnectionNotificationRequest, T> g) {
        return obj -> g.apply((CreateVpcEndpointConnectionNotificationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean dryRun;
        private String serviceId;
        private String vpcEndpointId;
        private String connectionNotificationArn;
        private List<String> connectionEvents = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcEndpointConnectionNotificationRequest model) {
            super(model);
            this.dryRun(model.dryRun);
            this.serviceId(model.serviceId);
            this.vpcEndpointId(model.vpcEndpointId);
            this.connectionNotificationArn(model.connectionNotificationArn);
            this.connectionEvents(model.connectionEvents);
            this.clientToken(model.clientToken);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getServiceId() {
            return this.serviceId;
        }

        public final void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        @Override
        public final Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public final String getVpcEndpointId() {
            return this.vpcEndpointId;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        @Override
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        public final String getConnectionNotificationArn() {
            return this.connectionNotificationArn;
        }

        public final void setConnectionNotificationArn(String connectionNotificationArn) {
            this.connectionNotificationArn = connectionNotificationArn;
        }

        @Override
        public final Builder connectionNotificationArn(String connectionNotificationArn) {
            this.connectionNotificationArn = connectionNotificationArn;
            return this;
        }

        public final Collection<String> getConnectionEvents() {
            if (this.connectionEvents instanceof SdkAutoConstructList) {
                return null;
            }
            return this.connectionEvents;
        }

        public final void setConnectionEvents(Collection<String> connectionEvents) {
            this.connectionEvents = ValueStringListCopier.copy(connectionEvents);
        }

        @Override
        public final Builder connectionEvents(Collection<String> connectionEvents) {
            this.connectionEvents = ValueStringListCopier.copy(connectionEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectionEvents(String ... connectionEvents) {
            this.connectionEvents(Arrays.asList(connectionEvents));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVpcEndpointConnectionNotificationRequest build() {
            return new CreateVpcEndpointConnectionNotificationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateVpcEndpointConnectionNotificationRequest> {
        public Builder dryRun(Boolean var1);

        public Builder serviceId(String var1);

        public Builder vpcEndpointId(String var1);

        public Builder connectionNotificationArn(String var1);

        public Builder connectionEvents(Collection<String> var1);

        public Builder connectionEvents(String ... var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

