/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.LockState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LockSnapshotResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, LockSnapshotResponse> {
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotId").getter(LockSnapshotResponse.getter(LockSnapshotResponse::snapshotId)).setter(LockSnapshotResponse.setter(Builder::snapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").unmarshallLocationName("snapshotId").build()}).build();
    private static final SdkField<String> LOCK_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LockState").getter(LockSnapshotResponse.getter(LockSnapshotResponse::lockStateAsString)).setter(LockSnapshotResponse.setter(Builder::lockState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockState").unmarshallLocationName("lockState").build()}).build();
    private static final SdkField<Integer> LOCK_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("LockDuration").getter(LockSnapshotResponse.getter(LockSnapshotResponse::lockDuration)).setter(LockSnapshotResponse.setter(Builder::lockDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockDuration").unmarshallLocationName("lockDuration").build()}).build();
    private static final SdkField<Integer> COOL_OFF_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("CoolOffPeriod").getter(LockSnapshotResponse.getter(LockSnapshotResponse::coolOffPeriod)).setter(LockSnapshotResponse.setter(Builder::coolOffPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoolOffPeriod").unmarshallLocationName("coolOffPeriod").build()}).build();
    private static final SdkField<Instant> COOL_OFF_PERIOD_EXPIRES_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CoolOffPeriodExpiresOn").getter(LockSnapshotResponse.getter(LockSnapshotResponse::coolOffPeriodExpiresOn)).setter(LockSnapshotResponse.setter(Builder::coolOffPeriodExpiresOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoolOffPeriodExpiresOn").unmarshallLocationName("coolOffPeriodExpiresOn").build()}).build();
    private static final SdkField<Instant> LOCK_CREATED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LockCreatedOn").getter(LockSnapshotResponse.getter(LockSnapshotResponse::lockCreatedOn)).setter(LockSnapshotResponse.setter(Builder::lockCreatedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockCreatedOn").unmarshallLocationName("lockCreatedOn").build()}).build();
    private static final SdkField<Instant> LOCK_EXPIRES_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LockExpiresOn").getter(LockSnapshotResponse.getter(LockSnapshotResponse::lockExpiresOn)).setter(LockSnapshotResponse.setter(Builder::lockExpiresOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockExpiresOn").unmarshallLocationName("lockExpiresOn").build()}).build();
    private static final SdkField<Instant> LOCK_DURATION_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LockDurationStartTime").getter(LockSnapshotResponse.getter(LockSnapshotResponse::lockDurationStartTime)).setter(LockSnapshotResponse.setter(Builder::lockDurationStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockDurationStartTime").unmarshallLocationName("lockDurationStartTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_ID_FIELD, LOCK_STATE_FIELD, LOCK_DURATION_FIELD, COOL_OFF_PERIOD_FIELD, COOL_OFF_PERIOD_EXPIRES_ON_FIELD, LOCK_CREATED_ON_FIELD, LOCK_EXPIRES_ON_FIELD, LOCK_DURATION_START_TIME_FIELD));
    private final String snapshotId;
    private final String lockState;
    private final Integer lockDuration;
    private final Integer coolOffPeriod;
    private final Instant coolOffPeriodExpiresOn;
    private final Instant lockCreatedOn;
    private final Instant lockExpiresOn;
    private final Instant lockDurationStartTime;

    private LockSnapshotResponse(BuilderImpl builder) {
        super(builder);
        this.snapshotId = builder.snapshotId;
        this.lockState = builder.lockState;
        this.lockDuration = builder.lockDuration;
        this.coolOffPeriod = builder.coolOffPeriod;
        this.coolOffPeriodExpiresOn = builder.coolOffPeriodExpiresOn;
        this.lockCreatedOn = builder.lockCreatedOn;
        this.lockExpiresOn = builder.lockExpiresOn;
        this.lockDurationStartTime = builder.lockDurationStartTime;
    }

    public final String snapshotId() {
        return this.snapshotId;
    }

    public final LockState lockState() {
        return LockState.fromValue(this.lockState);
    }

    public final String lockStateAsString() {
        return this.lockState;
    }

    public final Integer lockDuration() {
        return this.lockDuration;
    }

    public final Integer coolOffPeriod() {
        return this.coolOffPeriod;
    }

    public final Instant coolOffPeriodExpiresOn() {
        return this.coolOffPeriodExpiresOn;
    }

    public final Instant lockCreatedOn() {
        return this.lockCreatedOn;
    }

    public final Instant lockExpiresOn() {
        return this.lockExpiresOn;
    }

    public final Instant lockDurationStartTime() {
        return this.lockDurationStartTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lockStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lockDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.coolOffPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.coolOffPeriodExpiresOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lockCreatedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lockExpiresOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lockDurationStartTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LockSnapshotResponse)) {
            return false;
        }
        LockSnapshotResponse other = (LockSnapshotResponse)((Object)obj);
        return Objects.equals(this.snapshotId(), other.snapshotId()) && Objects.equals(this.lockStateAsString(), other.lockStateAsString()) && Objects.equals(this.lockDuration(), other.lockDuration()) && Objects.equals(this.coolOffPeriod(), other.coolOffPeriod()) && Objects.equals(this.coolOffPeriodExpiresOn(), other.coolOffPeriodExpiresOn()) && Objects.equals(this.lockCreatedOn(), other.lockCreatedOn()) && Objects.equals(this.lockExpiresOn(), other.lockExpiresOn()) && Objects.equals(this.lockDurationStartTime(), other.lockDurationStartTime());
    }

    public final String toString() {
        return ToString.builder((String)"LockSnapshotResponse").add("SnapshotId", (Object)this.snapshotId()).add("LockState", (Object)this.lockStateAsString()).add("LockDuration", (Object)this.lockDuration()).add("CoolOffPeriod", (Object)this.coolOffPeriod()).add("CoolOffPeriodExpiresOn", (Object)this.coolOffPeriodExpiresOn()).add("LockCreatedOn", (Object)this.lockCreatedOn()).add("LockExpiresOn", (Object)this.lockExpiresOn()).add("LockDurationStartTime", (Object)this.lockDurationStartTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SnapshotId": {
                return Optional.ofNullable(clazz.cast(this.snapshotId()));
            }
            case "LockState": {
                return Optional.ofNullable(clazz.cast(this.lockStateAsString()));
            }
            case "LockDuration": {
                return Optional.ofNullable(clazz.cast(this.lockDuration()));
            }
            case "CoolOffPeriod": {
                return Optional.ofNullable(clazz.cast(this.coolOffPeriod()));
            }
            case "CoolOffPeriodExpiresOn": {
                return Optional.ofNullable(clazz.cast(this.coolOffPeriodExpiresOn()));
            }
            case "LockCreatedOn": {
                return Optional.ofNullable(clazz.cast(this.lockCreatedOn()));
            }
            case "LockExpiresOn": {
                return Optional.ofNullable(clazz.cast(this.lockExpiresOn()));
            }
            case "LockDurationStartTime": {
                return Optional.ofNullable(clazz.cast(this.lockDurationStartTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LockSnapshotResponse, T> g) {
        return obj -> g.apply((LockSnapshotResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String snapshotId;
        private String lockState;
        private Integer lockDuration;
        private Integer coolOffPeriod;
        private Instant coolOffPeriodExpiresOn;
        private Instant lockCreatedOn;
        private Instant lockExpiresOn;
        private Instant lockDurationStartTime;

        private BuilderImpl() {
        }

        private BuilderImpl(LockSnapshotResponse model) {
            super(model);
            this.snapshotId(model.snapshotId);
            this.lockState(model.lockState);
            this.lockDuration(model.lockDuration);
            this.coolOffPeriod(model.coolOffPeriod);
            this.coolOffPeriodExpiresOn(model.coolOffPeriodExpiresOn);
            this.lockCreatedOn(model.lockCreatedOn);
            this.lockExpiresOn(model.lockExpiresOn);
            this.lockDurationStartTime(model.lockDurationStartTime);
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final String getLockState() {
            return this.lockState;
        }

        public final void setLockState(String lockState) {
            this.lockState = lockState;
        }

        @Override
        public final Builder lockState(String lockState) {
            this.lockState = lockState;
            return this;
        }

        @Override
        public final Builder lockState(LockState lockState) {
            this.lockState(lockState == null ? null : lockState.toString());
            return this;
        }

        public final Integer getLockDuration() {
            return this.lockDuration;
        }

        public final void setLockDuration(Integer lockDuration) {
            this.lockDuration = lockDuration;
        }

        @Override
        public final Builder lockDuration(Integer lockDuration) {
            this.lockDuration = lockDuration;
            return this;
        }

        public final Integer getCoolOffPeriod() {
            return this.coolOffPeriod;
        }

        public final void setCoolOffPeriod(Integer coolOffPeriod) {
            this.coolOffPeriod = coolOffPeriod;
        }

        @Override
        public final Builder coolOffPeriod(Integer coolOffPeriod) {
            this.coolOffPeriod = coolOffPeriod;
            return this;
        }

        public final Instant getCoolOffPeriodExpiresOn() {
            return this.coolOffPeriodExpiresOn;
        }

        public final void setCoolOffPeriodExpiresOn(Instant coolOffPeriodExpiresOn) {
            this.coolOffPeriodExpiresOn = coolOffPeriodExpiresOn;
        }

        @Override
        public final Builder coolOffPeriodExpiresOn(Instant coolOffPeriodExpiresOn) {
            this.coolOffPeriodExpiresOn = coolOffPeriodExpiresOn;
            return this;
        }

        public final Instant getLockCreatedOn() {
            return this.lockCreatedOn;
        }

        public final void setLockCreatedOn(Instant lockCreatedOn) {
            this.lockCreatedOn = lockCreatedOn;
        }

        @Override
        public final Builder lockCreatedOn(Instant lockCreatedOn) {
            this.lockCreatedOn = lockCreatedOn;
            return this;
        }

        public final Instant getLockExpiresOn() {
            return this.lockExpiresOn;
        }

        public final void setLockExpiresOn(Instant lockExpiresOn) {
            this.lockExpiresOn = lockExpiresOn;
        }

        @Override
        public final Builder lockExpiresOn(Instant lockExpiresOn) {
            this.lockExpiresOn = lockExpiresOn;
            return this;
        }

        public final Instant getLockDurationStartTime() {
            return this.lockDurationStartTime;
        }

        public final void setLockDurationStartTime(Instant lockDurationStartTime) {
            this.lockDurationStartTime = lockDurationStartTime;
        }

        @Override
        public final Builder lockDurationStartTime(Instant lockDurationStartTime) {
            this.lockDurationStartTime = lockDurationStartTime;
            return this;
        }

        @Override
        public LockSnapshotResponse build() {
            return new LockSnapshotResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, LockSnapshotResponse> {
        public Builder snapshotId(String var1);

        public Builder lockState(String var1);

        public Builder lockState(LockState var1);

        public Builder lockDuration(Integer var1);

        public Builder coolOffPeriod(Integer var1);

        public Builder coolOffPeriodExpiresOn(Instant var1);

        public Builder lockCreatedOn(Instant var1);

        public Builder lockExpiresOn(Instant var1);

        public Builder lockDurationStartTime(Instant var1);
    }
}

