/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details for Site-to-Site VPN tunnel endpoint maintenance events.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MaintenanceDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<MaintenanceDetails.Builder, MaintenanceDetails> {
    private static final SdkField<String> PENDING_MAINTENANCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PendingMaintenance")
            .getter(getter(MaintenanceDetails::pendingMaintenance))
            .setter(setter(Builder::pendingMaintenance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingMaintenance")
                    .unmarshallLocationName("pendingMaintenance").build()).build();

    private static final SdkField<Instant> MAINTENANCE_AUTO_APPLIED_AFTER_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("MaintenanceAutoAppliedAfter")
            .getter(getter(MaintenanceDetails::maintenanceAutoAppliedAfter))
            .setter(setter(Builder::maintenanceAutoAppliedAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceAutoAppliedAfter")
                    .unmarshallLocationName("maintenanceAutoAppliedAfter").build()).build();

    private static final SdkField<Instant> LAST_MAINTENANCE_APPLIED_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastMaintenanceApplied")
            .getter(getter(MaintenanceDetails::lastMaintenanceApplied))
            .setter(setter(Builder::lastMaintenanceApplied))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastMaintenanceApplied")
                    .unmarshallLocationName("lastMaintenanceApplied").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PENDING_MAINTENANCE_FIELD,
            MAINTENANCE_AUTO_APPLIED_AFTER_FIELD, LAST_MAINTENANCE_APPLIED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String pendingMaintenance;

    private final Instant maintenanceAutoAppliedAfter;

    private final Instant lastMaintenanceApplied;

    private MaintenanceDetails(BuilderImpl builder) {
        this.pendingMaintenance = builder.pendingMaintenance;
        this.maintenanceAutoAppliedAfter = builder.maintenanceAutoAppliedAfter;
        this.lastMaintenanceApplied = builder.lastMaintenanceApplied;
    }

    /**
     * <p>
     * Verify existence of a pending maintenance.
     * </p>
     * 
     * @return Verify existence of a pending maintenance.
     */
    public final String pendingMaintenance() {
        return pendingMaintenance;
    }

    /**
     * <p>
     * The timestamp after which Amazon Web Services will automatically apply maintenance.
     * </p>
     * 
     * @return The timestamp after which Amazon Web Services will automatically apply maintenance.
     */
    public final Instant maintenanceAutoAppliedAfter() {
        return maintenanceAutoAppliedAfter;
    }

    /**
     * <p>
     * Timestamp of last applied maintenance.
     * </p>
     * 
     * @return Timestamp of last applied maintenance.
     */
    public final Instant lastMaintenanceApplied() {
        return lastMaintenanceApplied;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pendingMaintenance());
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceAutoAppliedAfter());
        hashCode = 31 * hashCode + Objects.hashCode(lastMaintenanceApplied());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceDetails)) {
            return false;
        }
        MaintenanceDetails other = (MaintenanceDetails) obj;
        return Objects.equals(pendingMaintenance(), other.pendingMaintenance())
                && Objects.equals(maintenanceAutoAppliedAfter(), other.maintenanceAutoAppliedAfter())
                && Objects.equals(lastMaintenanceApplied(), other.lastMaintenanceApplied());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MaintenanceDetails").add("PendingMaintenance", pendingMaintenance())
                .add("MaintenanceAutoAppliedAfter", maintenanceAutoAppliedAfter())
                .add("LastMaintenanceApplied", lastMaintenanceApplied()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PendingMaintenance":
            return Optional.ofNullable(clazz.cast(pendingMaintenance()));
        case "MaintenanceAutoAppliedAfter":
            return Optional.ofNullable(clazz.cast(maintenanceAutoAppliedAfter()));
        case "LastMaintenanceApplied":
            return Optional.ofNullable(clazz.cast(lastMaintenanceApplied()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MaintenanceDetails, T> g) {
        return obj -> g.apply((MaintenanceDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MaintenanceDetails> {
        /**
         * <p>
         * Verify existence of a pending maintenance.
         * </p>
         * 
         * @param pendingMaintenance
         *        Verify existence of a pending maintenance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingMaintenance(String pendingMaintenance);

        /**
         * <p>
         * The timestamp after which Amazon Web Services will automatically apply maintenance.
         * </p>
         * 
         * @param maintenanceAutoAppliedAfter
         *        The timestamp after which Amazon Web Services will automatically apply maintenance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceAutoAppliedAfter(Instant maintenanceAutoAppliedAfter);

        /**
         * <p>
         * Timestamp of last applied maintenance.
         * </p>
         * 
         * @param lastMaintenanceApplied
         *        Timestamp of last applied maintenance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastMaintenanceApplied(Instant lastMaintenanceApplied);
    }

    static final class BuilderImpl implements Builder {
        private String pendingMaintenance;

        private Instant maintenanceAutoAppliedAfter;

        private Instant lastMaintenanceApplied;

        private BuilderImpl() {
        }

        private BuilderImpl(MaintenanceDetails model) {
            pendingMaintenance(model.pendingMaintenance);
            maintenanceAutoAppliedAfter(model.maintenanceAutoAppliedAfter);
            lastMaintenanceApplied(model.lastMaintenanceApplied);
        }

        public final String getPendingMaintenance() {
            return pendingMaintenance;
        }

        public final void setPendingMaintenance(String pendingMaintenance) {
            this.pendingMaintenance = pendingMaintenance;
        }

        @Override
        public final Builder pendingMaintenance(String pendingMaintenance) {
            this.pendingMaintenance = pendingMaintenance;
            return this;
        }

        public final Instant getMaintenanceAutoAppliedAfter() {
            return maintenanceAutoAppliedAfter;
        }

        public final void setMaintenanceAutoAppliedAfter(Instant maintenanceAutoAppliedAfter) {
            this.maintenanceAutoAppliedAfter = maintenanceAutoAppliedAfter;
        }

        @Override
        public final Builder maintenanceAutoAppliedAfter(Instant maintenanceAutoAppliedAfter) {
            this.maintenanceAutoAppliedAfter = maintenanceAutoAppliedAfter;
            return this;
        }

        public final Instant getLastMaintenanceApplied() {
            return lastMaintenanceApplied;
        }

        public final void setLastMaintenanceApplied(Instant lastMaintenanceApplied) {
            this.lastMaintenanceApplied = lastMaintenanceApplied;
        }

        @Override
        public final Builder lastMaintenanceApplied(Instant lastMaintenanceApplied) {
            this.lastMaintenanceApplied = lastMaintenanceApplied;
            return this;
        }

        @Override
        public MaintenanceDetails build() {
            return new MaintenanceDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
