/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DataResponse;
import software.amazon.awssdk.services.ec2.model.GetAwsNetworkPerformanceDataRequest;
import software.amazon.awssdk.services.ec2.model.GetAwsNetworkPerformanceDataResponse;

public class GetAwsNetworkPerformanceDataPublisher
implements SdkPublisher<GetAwsNetworkPerformanceDataResponse> {
    private final Ec2AsyncClient client;
    private final GetAwsNetworkPerformanceDataRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetAwsNetworkPerformanceDataPublisher(Ec2AsyncClient client, GetAwsNetworkPerformanceDataRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetAwsNetworkPerformanceDataPublisher(Ec2AsyncClient client, GetAwsNetworkPerformanceDataRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetAwsNetworkPerformanceDataResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetAwsNetworkPerformanceDataResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DataResponse> dataResponses() {
        Function<GetAwsNetworkPerformanceDataResponse, Iterator> getIterator = response -> {
            if (response != null && response.dataResponses() != null) {
                return response.dataResponses().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetAwsNetworkPerformanceDataResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetAwsNetworkPerformanceDataResponseFetcher
    implements AsyncPageFetcher<GetAwsNetworkPerformanceDataResponse> {
        private GetAwsNetworkPerformanceDataResponseFetcher() {
        }

        public boolean hasNextPage(GetAwsNetworkPerformanceDataResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetAwsNetworkPerformanceDataResponse> nextPage(GetAwsNetworkPerformanceDataResponse previousPage) {
            if (previousPage == null) {
                return GetAwsNetworkPerformanceDataPublisher.this.client.getAwsNetworkPerformanceData(GetAwsNetworkPerformanceDataPublisher.this.firstRequest);
            }
            return GetAwsNetworkPerformanceDataPublisher.this.client.getAwsNetworkPerformanceData((GetAwsNetworkPerformanceDataRequest)((Object)GetAwsNetworkPerformanceDataPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

