/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.BundleTask;
import software.amazon.awssdk.services.ec2.model.BundleTaskListCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeBundleTasksResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeBundleTasksResponse> {
    private static final SdkField<List<BundleTask>> BUNDLE_TASKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BundleTasks").getter(DescribeBundleTasksResponse.getter(DescribeBundleTasksResponse::bundleTasks)).setter(DescribeBundleTasksResponse.setter(Builder::bundleTasks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BundleInstanceTasksSet").unmarshallLocationName("bundleInstanceTasksSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BundleTask::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUNDLE_TASKS_FIELD));
    private final List<BundleTask> bundleTasks;

    private DescribeBundleTasksResponse(BuilderImpl builder) {
        super(builder);
        this.bundleTasks = builder.bundleTasks;
    }

    public final boolean hasBundleTasks() {
        return this.bundleTasks != null && !(this.bundleTasks instanceof SdkAutoConstructList);
    }

    public final List<BundleTask> bundleTasks() {
        return this.bundleTasks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBundleTasks() ? this.bundleTasks() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBundleTasksResponse)) {
            return false;
        }
        DescribeBundleTasksResponse other = (DescribeBundleTasksResponse)((Object)obj);
        return this.hasBundleTasks() == other.hasBundleTasks() && Objects.equals(this.bundleTasks(), other.bundleTasks());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeBundleTasksResponse").add("BundleTasks", this.hasBundleTasks() ? this.bundleTasks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BundleTasks": {
                return Optional.ofNullable(clazz.cast(this.bundleTasks()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeBundleTasksResponse, T> g) {
        return obj -> g.apply((DescribeBundleTasksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<BundleTask> bundleTasks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBundleTasksResponse model) {
            super(model);
            this.bundleTasks(model.bundleTasks);
        }

        public final List<BundleTask.Builder> getBundleTasks() {
            List<BundleTask.Builder> result = BundleTaskListCopier.copyToBuilder(this.bundleTasks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBundleTasks(Collection<BundleTask.BuilderImpl> bundleTasks) {
            this.bundleTasks = BundleTaskListCopier.copyFromBuilder(bundleTasks);
        }

        @Override
        public final Builder bundleTasks(Collection<BundleTask> bundleTasks) {
            this.bundleTasks = BundleTaskListCopier.copy(bundleTasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bundleTasks(BundleTask ... bundleTasks) {
            this.bundleTasks(Arrays.asList(bundleTasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bundleTasks(Consumer<BundleTask.Builder> ... bundleTasks) {
            this.bundleTasks(Stream.of(bundleTasks).map(c -> (BundleTask)((BundleTask.Builder)BundleTask.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeBundleTasksResponse build() {
            return new DescribeBundleTasksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeBundleTasksResponse> {
        public Builder bundleTasks(Collection<BundleTask> var1);

        public Builder bundleTasks(BundleTask ... var1);

        public Builder bundleTasks(Consumer<BundleTask.Builder> ... var1);
    }
}

