/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Options for logging VPN tunnel activity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpnTunnelLogOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<VpnTunnelLogOptions.Builder, VpnTunnelLogOptions> {
    private static final SdkField<CloudWatchLogOptions> CLOUD_WATCH_LOG_OPTIONS_FIELD = SdkField
            .<CloudWatchLogOptions> builder(MarshallingType.SDK_POJO)
            .memberName("CloudWatchLogOptions")
            .getter(getter(VpnTunnelLogOptions::cloudWatchLogOptions))
            .setter(setter(Builder::cloudWatchLogOptions))
            .constructor(CloudWatchLogOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogOptions")
                    .unmarshallLocationName("cloudWatchLogOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(CLOUD_WATCH_LOG_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final CloudWatchLogOptions cloudWatchLogOptions;

    private VpnTunnelLogOptions(BuilderImpl builder) {
        this.cloudWatchLogOptions = builder.cloudWatchLogOptions;
    }

    /**
     * <p>
     * Options for sending VPN tunnel logs to CloudWatch.
     * </p>
     * 
     * @return Options for sending VPN tunnel logs to CloudWatch.
     */
    public final CloudWatchLogOptions cloudWatchLogOptions() {
        return cloudWatchLogOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpnTunnelLogOptions)) {
            return false;
        }
        VpnTunnelLogOptions other = (VpnTunnelLogOptions) obj;
        return Objects.equals(cloudWatchLogOptions(), other.cloudWatchLogOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VpnTunnelLogOptions").add("CloudWatchLogOptions", cloudWatchLogOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CloudWatchLogOptions":
            return Optional.ofNullable(clazz.cast(cloudWatchLogOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VpnTunnelLogOptions, T> g) {
        return obj -> g.apply((VpnTunnelLogOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpnTunnelLogOptions> {
        /**
         * <p>
         * Options for sending VPN tunnel logs to CloudWatch.
         * </p>
         * 
         * @param cloudWatchLogOptions
         *        Options for sending VPN tunnel logs to CloudWatch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogOptions(CloudWatchLogOptions cloudWatchLogOptions);

        /**
         * <p>
         * Options for sending VPN tunnel logs to CloudWatch.
         * </p>
         * This is a convenience method that creates an instance of the {@link CloudWatchLogOptions.Builder} avoiding
         * the need to create one manually via {@link CloudWatchLogOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CloudWatchLogOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #cloudWatchLogOptions(CloudWatchLogOptions)}.
         * 
         * @param cloudWatchLogOptions
         *        a consumer that will call methods on {@link CloudWatchLogOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchLogOptions(CloudWatchLogOptions)
         */
        default Builder cloudWatchLogOptions(Consumer<CloudWatchLogOptions.Builder> cloudWatchLogOptions) {
            return cloudWatchLogOptions(CloudWatchLogOptions.builder().applyMutation(cloudWatchLogOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CloudWatchLogOptions cloudWatchLogOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(VpnTunnelLogOptions model) {
            cloudWatchLogOptions(model.cloudWatchLogOptions);
        }

        public final CloudWatchLogOptions.Builder getCloudWatchLogOptions() {
            return cloudWatchLogOptions != null ? cloudWatchLogOptions.toBuilder() : null;
        }

        public final void setCloudWatchLogOptions(CloudWatchLogOptions.BuilderImpl cloudWatchLogOptions) {
            this.cloudWatchLogOptions = cloudWatchLogOptions != null ? cloudWatchLogOptions.build() : null;
        }

        @Override
        public final Builder cloudWatchLogOptions(CloudWatchLogOptions cloudWatchLogOptions) {
            this.cloudWatchLogOptions = cloudWatchLogOptions;
            return this;
        }

        @Override
        public VpnTunnelLogOptions build() {
            return new VpnTunnelLogOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
