/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a transit gateway policy table entry
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransitGatewayPolicyTableEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<TransitGatewayPolicyTableEntry.Builder, TransitGatewayPolicyTableEntry> {
    private static final SdkField<String> POLICY_RULE_NUMBER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PolicyRuleNumber")
            .getter(getter(TransitGatewayPolicyTableEntry::policyRuleNumber))
            .setter(setter(Builder::policyRuleNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyRuleNumber")
                    .unmarshallLocationName("policyRuleNumber").build()).build();

    private static final SdkField<TransitGatewayPolicyRule> POLICY_RULE_FIELD = SdkField
            .<TransitGatewayPolicyRule> builder(MarshallingType.SDK_POJO)
            .memberName("PolicyRule")
            .getter(getter(TransitGatewayPolicyTableEntry::policyRule))
            .setter(setter(Builder::policyRule))
            .constructor(TransitGatewayPolicyRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyRule")
                    .unmarshallLocationName("policyRule").build()).build();

    private static final SdkField<String> TARGET_ROUTE_TABLE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TargetRouteTableId")
            .getter(getter(TransitGatewayPolicyTableEntry::targetRouteTableId))
            .setter(setter(Builder::targetRouteTableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetRouteTableId")
                    .unmarshallLocationName("targetRouteTableId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_RULE_NUMBER_FIELD,
            POLICY_RULE_FIELD, TARGET_ROUTE_TABLE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String policyRuleNumber;

    private final TransitGatewayPolicyRule policyRule;

    private final String targetRouteTableId;

    private TransitGatewayPolicyTableEntry(BuilderImpl builder) {
        this.policyRuleNumber = builder.policyRuleNumber;
        this.policyRule = builder.policyRule;
        this.targetRouteTableId = builder.targetRouteTableId;
    }

    /**
     * <p>
     * The rule number for the transit gateway policy table entry.
     * </p>
     * 
     * @return The rule number for the transit gateway policy table entry.
     */
    public final String policyRuleNumber() {
        return policyRuleNumber;
    }

    /**
     * <p>
     * The policy rule associated with the transit gateway policy table.
     * </p>
     * 
     * @return The policy rule associated with the transit gateway policy table.
     */
    public final TransitGatewayPolicyRule policyRule() {
        return policyRule;
    }

    /**
     * <p>
     * The ID of the target route table.
     * </p>
     * 
     * @return The ID of the target route table.
     */
    public final String targetRouteTableId() {
        return targetRouteTableId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policyRuleNumber());
        hashCode = 31 * hashCode + Objects.hashCode(policyRule());
        hashCode = 31 * hashCode + Objects.hashCode(targetRouteTableId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayPolicyTableEntry)) {
            return false;
        }
        TransitGatewayPolicyTableEntry other = (TransitGatewayPolicyTableEntry) obj;
        return Objects.equals(policyRuleNumber(), other.policyRuleNumber()) && Objects.equals(policyRule(), other.policyRule())
                && Objects.equals(targetRouteTableId(), other.targetRouteTableId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TransitGatewayPolicyTableEntry").add("PolicyRuleNumber", policyRuleNumber())
                .add("PolicyRule", policyRule()).add("TargetRouteTableId", targetRouteTableId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyRuleNumber":
            return Optional.ofNullable(clazz.cast(policyRuleNumber()));
        case "PolicyRule":
            return Optional.ofNullable(clazz.cast(policyRule()));
        case "TargetRouteTableId":
            return Optional.ofNullable(clazz.cast(targetRouteTableId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayPolicyTableEntry, T> g) {
        return obj -> g.apply((TransitGatewayPolicyTableEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransitGatewayPolicyTableEntry> {
        /**
         * <p>
         * The rule number for the transit gateway policy table entry.
         * </p>
         * 
         * @param policyRuleNumber
         *        The rule number for the transit gateway policy table entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyRuleNumber(String policyRuleNumber);

        /**
         * <p>
         * The policy rule associated with the transit gateway policy table.
         * </p>
         * 
         * @param policyRule
         *        The policy rule associated with the transit gateway policy table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyRule(TransitGatewayPolicyRule policyRule);

        /**
         * <p>
         * The policy rule associated with the transit gateway policy table.
         * </p>
         * This is a convenience method that creates an instance of the {@link TransitGatewayPolicyRule.Builder}
         * avoiding the need to create one manually via {@link TransitGatewayPolicyRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TransitGatewayPolicyRule.Builder#build()} is called immediately
         * and its result is passed to {@link #policyRule(TransitGatewayPolicyRule)}.
         * 
         * @param policyRule
         *        a consumer that will call methods on {@link TransitGatewayPolicyRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policyRule(TransitGatewayPolicyRule)
         */
        default Builder policyRule(Consumer<TransitGatewayPolicyRule.Builder> policyRule) {
            return policyRule(TransitGatewayPolicyRule.builder().applyMutation(policyRule).build());
        }

        /**
         * <p>
         * The ID of the target route table.
         * </p>
         * 
         * @param targetRouteTableId
         *        The ID of the target route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetRouteTableId(String targetRouteTableId);
    }

    static final class BuilderImpl implements Builder {
        private String policyRuleNumber;

        private TransitGatewayPolicyRule policyRule;

        private String targetRouteTableId;

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayPolicyTableEntry model) {
            policyRuleNumber(model.policyRuleNumber);
            policyRule(model.policyRule);
            targetRouteTableId(model.targetRouteTableId);
        }

        public final String getPolicyRuleNumber() {
            return policyRuleNumber;
        }

        public final void setPolicyRuleNumber(String policyRuleNumber) {
            this.policyRuleNumber = policyRuleNumber;
        }

        @Override
        public final Builder policyRuleNumber(String policyRuleNumber) {
            this.policyRuleNumber = policyRuleNumber;
            return this;
        }

        public final TransitGatewayPolicyRule.Builder getPolicyRule() {
            return policyRule != null ? policyRule.toBuilder() : null;
        }

        public final void setPolicyRule(TransitGatewayPolicyRule.BuilderImpl policyRule) {
            this.policyRule = policyRule != null ? policyRule.build() : null;
        }

        @Override
        public final Builder policyRule(TransitGatewayPolicyRule policyRule) {
            this.policyRule = policyRule;
            return this;
        }

        public final String getTargetRouteTableId() {
            return targetRouteTableId;
        }

        public final void setTargetRouteTableId(String targetRouteTableId) {
            this.targetRouteTableId = targetRouteTableId;
        }

        @Override
        public final Builder targetRouteTableId(String targetRouteTableId) {
            this.targetRouteTableId = targetRouteTableId;
            return this;
        }

        @Override
        public TransitGatewayPolicyTableEntry build() {
            return new TransitGatewayPolicyTableEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
