/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The information about the AMI store task, including the progress of the task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StoreImageTaskResult implements SdkPojo, Serializable,
        ToCopyableBuilder<StoreImageTaskResult.Builder, StoreImageTaskResult> {
    private static final SdkField<String> AMI_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AmiId")
            .getter(getter(StoreImageTaskResult::amiId))
            .setter(setter(Builder::amiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmiId")
                    .unmarshallLocationName("amiId").build()).build();

    private static final SdkField<Instant> TASK_START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("TaskStartTime")
            .getter(getter(StoreImageTaskResult::taskStartTime))
            .setter(setter(Builder::taskStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskStartTime")
                    .unmarshallLocationName("taskStartTime").build()).build();

    private static final SdkField<String> BUCKET_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Bucket")
            .getter(getter(StoreImageTaskResult::bucket))
            .setter(setter(Builder::bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bucket")
                    .unmarshallLocationName("bucket").build()).build();

    private static final SdkField<String> S3_OBJECT_KEY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("S3objectKey")
            .getter(getter(StoreImageTaskResult::s3objectKey))
            .setter(setter(Builder::s3objectKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3objectKey")
                    .unmarshallLocationName("s3objectKey").build()).build();

    private static final SdkField<Integer> PROGRESS_PERCENTAGE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("ProgressPercentage")
            .getter(getter(StoreImageTaskResult::progressPercentage))
            .setter(setter(Builder::progressPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressPercentage")
                    .unmarshallLocationName("progressPercentage").build()).build();

    private static final SdkField<String> STORE_TASK_STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StoreTaskState")
            .getter(getter(StoreImageTaskResult::storeTaskState))
            .setter(setter(Builder::storeTaskState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoreTaskState")
                    .unmarshallLocationName("storeTaskState").build()).build();

    private static final SdkField<String> STORE_TASK_FAILURE_REASON_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StoreTaskFailureReason")
            .getter(getter(StoreImageTaskResult::storeTaskFailureReason))
            .setter(setter(Builder::storeTaskFailureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoreTaskFailureReason")
                    .unmarshallLocationName("storeTaskFailureReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMI_ID_FIELD,
            TASK_START_TIME_FIELD, BUCKET_FIELD, S3_OBJECT_KEY_FIELD, PROGRESS_PERCENTAGE_FIELD, STORE_TASK_STATE_FIELD,
            STORE_TASK_FAILURE_REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String amiId;

    private final Instant taskStartTime;

    private final String bucket;

    private final String s3objectKey;

    private final Integer progressPercentage;

    private final String storeTaskState;

    private final String storeTaskFailureReason;

    private StoreImageTaskResult(BuilderImpl builder) {
        this.amiId = builder.amiId;
        this.taskStartTime = builder.taskStartTime;
        this.bucket = builder.bucket;
        this.s3objectKey = builder.s3objectKey;
        this.progressPercentage = builder.progressPercentage;
        this.storeTaskState = builder.storeTaskState;
        this.storeTaskFailureReason = builder.storeTaskFailureReason;
    }

    /**
     * <p>
     * The ID of the AMI that is being stored.
     * </p>
     * 
     * @return The ID of the AMI that is being stored.
     */
    public final String amiId() {
        return amiId;
    }

    /**
     * <p>
     * The time the task started.
     * </p>
     * 
     * @return The time the task started.
     */
    public final Instant taskStartTime() {
        return taskStartTime;
    }

    /**
     * <p>
     * The name of the Amazon S3 bucket that contains the stored AMI object.
     * </p>
     * 
     * @return The name of the Amazon S3 bucket that contains the stored AMI object.
     */
    public final String bucket() {
        return bucket;
    }

    /**
     * <p>
     * The name of the stored AMI object in the bucket.
     * </p>
     * 
     * @return The name of the stored AMI object in the bucket.
     */
    public final String s3objectKey() {
        return s3objectKey;
    }

    /**
     * <p>
     * The progress of the task as a percentage.
     * </p>
     * 
     * @return The progress of the task as a percentage.
     */
    public final Integer progressPercentage() {
        return progressPercentage;
    }

    /**
     * <p>
     * The state of the store task (<code>InProgress</code>, <code>Completed</code>, or <code>Failed</code>).
     * </p>
     * 
     * @return The state of the store task (<code>InProgress</code>, <code>Completed</code>, or <code>Failed</code>).
     */
    public final String storeTaskState() {
        return storeTaskState;
    }

    /**
     * <p>
     * If the tasks fails, the reason for the failure is returned. If the task succeeds, <code>null</code> is returned.
     * </p>
     * 
     * @return If the tasks fails, the reason for the failure is returned. If the task succeeds, <code>null</code> is
     *         returned.
     */
    public final String storeTaskFailureReason() {
        return storeTaskFailureReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(amiId());
        hashCode = 31 * hashCode + Objects.hashCode(taskStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(s3objectKey());
        hashCode = 31 * hashCode + Objects.hashCode(progressPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(storeTaskState());
        hashCode = 31 * hashCode + Objects.hashCode(storeTaskFailureReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StoreImageTaskResult)) {
            return false;
        }
        StoreImageTaskResult other = (StoreImageTaskResult) obj;
        return Objects.equals(amiId(), other.amiId()) && Objects.equals(taskStartTime(), other.taskStartTime())
                && Objects.equals(bucket(), other.bucket()) && Objects.equals(s3objectKey(), other.s3objectKey())
                && Objects.equals(progressPercentage(), other.progressPercentage())
                && Objects.equals(storeTaskState(), other.storeTaskState())
                && Objects.equals(storeTaskFailureReason(), other.storeTaskFailureReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StoreImageTaskResult").add("AmiId", amiId()).add("TaskStartTime", taskStartTime())
                .add("Bucket", bucket()).add("S3objectKey", s3objectKey()).add("ProgressPercentage", progressPercentage())
                .add("StoreTaskState", storeTaskState()).add("StoreTaskFailureReason", storeTaskFailureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AmiId":
            return Optional.ofNullable(clazz.cast(amiId()));
        case "TaskStartTime":
            return Optional.ofNullable(clazz.cast(taskStartTime()));
        case "Bucket":
            return Optional.ofNullable(clazz.cast(bucket()));
        case "S3objectKey":
            return Optional.ofNullable(clazz.cast(s3objectKey()));
        case "ProgressPercentage":
            return Optional.ofNullable(clazz.cast(progressPercentage()));
        case "StoreTaskState":
            return Optional.ofNullable(clazz.cast(storeTaskState()));
        case "StoreTaskFailureReason":
            return Optional.ofNullable(clazz.cast(storeTaskFailureReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StoreImageTaskResult, T> g) {
        return obj -> g.apply((StoreImageTaskResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StoreImageTaskResult> {
        /**
         * <p>
         * The ID of the AMI that is being stored.
         * </p>
         * 
         * @param amiId
         *        The ID of the AMI that is being stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amiId(String amiId);

        /**
         * <p>
         * The time the task started.
         * </p>
         * 
         * @param taskStartTime
         *        The time the task started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskStartTime(Instant taskStartTime);

        /**
         * <p>
         * The name of the Amazon S3 bucket that contains the stored AMI object.
         * </p>
         * 
         * @param bucket
         *        The name of the Amazon S3 bucket that contains the stored AMI object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * <p>
         * The name of the stored AMI object in the bucket.
         * </p>
         * 
         * @param s3objectKey
         *        The name of the stored AMI object in the bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3objectKey(String s3objectKey);

        /**
         * <p>
         * The progress of the task as a percentage.
         * </p>
         * 
         * @param progressPercentage
         *        The progress of the task as a percentage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progressPercentage(Integer progressPercentage);

        /**
         * <p>
         * The state of the store task (<code>InProgress</code>, <code>Completed</code>, or <code>Failed</code>).
         * </p>
         * 
         * @param storeTaskState
         *        The state of the store task (<code>InProgress</code>, <code>Completed</code>, or <code>Failed</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storeTaskState(String storeTaskState);

        /**
         * <p>
         * If the tasks fails, the reason for the failure is returned. If the task succeeds, <code>null</code> is
         * returned.
         * </p>
         * 
         * @param storeTaskFailureReason
         *        If the tasks fails, the reason for the failure is returned. If the task succeeds, <code>null</code> is
         *        returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storeTaskFailureReason(String storeTaskFailureReason);
    }

    static final class BuilderImpl implements Builder {
        private String amiId;

        private Instant taskStartTime;

        private String bucket;

        private String s3objectKey;

        private Integer progressPercentage;

        private String storeTaskState;

        private String storeTaskFailureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(StoreImageTaskResult model) {
            amiId(model.amiId);
            taskStartTime(model.taskStartTime);
            bucket(model.bucket);
            s3objectKey(model.s3objectKey);
            progressPercentage(model.progressPercentage);
            storeTaskState(model.storeTaskState);
            storeTaskFailureReason(model.storeTaskFailureReason);
        }

        public final String getAmiId() {
            return amiId;
        }

        public final void setAmiId(String amiId) {
            this.amiId = amiId;
        }

        @Override
        public final Builder amiId(String amiId) {
            this.amiId = amiId;
            return this;
        }

        public final Instant getTaskStartTime() {
            return taskStartTime;
        }

        public final void setTaskStartTime(Instant taskStartTime) {
            this.taskStartTime = taskStartTime;
        }

        @Override
        public final Builder taskStartTime(Instant taskStartTime) {
            this.taskStartTime = taskStartTime;
            return this;
        }

        public final String getBucket() {
            return bucket;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final String getS3objectKey() {
            return s3objectKey;
        }

        public final void setS3objectKey(String s3objectKey) {
            this.s3objectKey = s3objectKey;
        }

        @Override
        public final Builder s3objectKey(String s3objectKey) {
            this.s3objectKey = s3objectKey;
            return this;
        }

        public final Integer getProgressPercentage() {
            return progressPercentage;
        }

        public final void setProgressPercentage(Integer progressPercentage) {
            this.progressPercentage = progressPercentage;
        }

        @Override
        public final Builder progressPercentage(Integer progressPercentage) {
            this.progressPercentage = progressPercentage;
            return this;
        }

        public final String getStoreTaskState() {
            return storeTaskState;
        }

        public final void setStoreTaskState(String storeTaskState) {
            this.storeTaskState = storeTaskState;
        }

        @Override
        public final Builder storeTaskState(String storeTaskState) {
            this.storeTaskState = storeTaskState;
            return this;
        }

        public final String getStoreTaskFailureReason() {
            return storeTaskFailureReason;
        }

        public final void setStoreTaskFailureReason(String storeTaskFailureReason) {
            this.storeTaskFailureReason = storeTaskFailureReason;
        }

        @Override
        public final Builder storeTaskFailureReason(String storeTaskFailureReason) {
            this.storeTaskFailureReason = storeTaskFailureReason;
            return this;
        }

        @Override
        public StoreImageTaskResult build() {
            return new StoreImageTaskResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
