/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a packet header statement.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PacketHeaderStatementRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<PacketHeaderStatementRequest.Builder, PacketHeaderStatementRequest> {
    private static final SdkField<List<String>> SOURCE_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SourceAddresses")
            .getter(getter(PacketHeaderStatementRequest::sourceAddresses))
            .setter(setter(Builder::sourceAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceAddress")
                    .unmarshallLocationName("SourceAddress").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> DESTINATION_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DestinationAddresses")
            .getter(getter(PacketHeaderStatementRequest::destinationAddresses))
            .setter(setter(Builder::destinationAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationAddress")
                    .unmarshallLocationName("DestinationAddress").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> SOURCE_PORTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SourcePorts")
            .getter(getter(PacketHeaderStatementRequest::sourcePorts))
            .setter(setter(Builder::sourcePorts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePort")
                    .unmarshallLocationName("SourcePort").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> DESTINATION_PORTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DestinationPorts")
            .getter(getter(PacketHeaderStatementRequest::destinationPorts))
            .setter(setter(Builder::destinationPorts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPort")
                    .unmarshallLocationName("DestinationPort").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> SOURCE_PREFIX_LISTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SourcePrefixLists")
            .getter(getter(PacketHeaderStatementRequest::sourcePrefixLists))
            .setter(setter(Builder::sourcePrefixLists))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePrefixList")
                    .unmarshallLocationName("SourcePrefixList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> DESTINATION_PREFIX_LISTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DestinationPrefixLists")
            .getter(getter(PacketHeaderStatementRequest::destinationPrefixLists))
            .setter(setter(Builder::destinationPrefixLists))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPrefixList")
                    .unmarshallLocationName("DestinationPrefixList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> PROTOCOLS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Protocols")
            .getter(getter(PacketHeaderStatementRequest::protocolsAsStrings))
            .setter(setter(Builder::protocolsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol")
                    .unmarshallLocationName("Protocol").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_ADDRESSES_FIELD,
            DESTINATION_ADDRESSES_FIELD, SOURCE_PORTS_FIELD, DESTINATION_PORTS_FIELD, SOURCE_PREFIX_LISTS_FIELD,
            DESTINATION_PREFIX_LISTS_FIELD, PROTOCOLS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> sourceAddresses;

    private final List<String> destinationAddresses;

    private final List<String> sourcePorts;

    private final List<String> destinationPorts;

    private final List<String> sourcePrefixLists;

    private final List<String> destinationPrefixLists;

    private final List<String> protocols;

    private PacketHeaderStatementRequest(BuilderImpl builder) {
        this.sourceAddresses = builder.sourceAddresses;
        this.destinationAddresses = builder.destinationAddresses;
        this.sourcePorts = builder.sourcePorts;
        this.destinationPorts = builder.destinationPorts;
        this.sourcePrefixLists = builder.sourcePrefixLists;
        this.destinationPrefixLists = builder.destinationPrefixLists;
        this.protocols = builder.protocols;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourceAddresses property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSourceAddresses() {
        return sourceAddresses != null && !(sourceAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The source addresses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourceAddresses} method.
     * </p>
     * 
     * @return The source addresses.
     */
    public final List<String> sourceAddresses() {
        return sourceAddresses;
    }

    /**
     * For responses, this returns true if the service returned a value for the DestinationAddresses property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDestinationAddresses() {
        return destinationAddresses != null && !(destinationAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The destination addresses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDestinationAddresses} method.
     * </p>
     * 
     * @return The destination addresses.
     */
    public final List<String> destinationAddresses() {
        return destinationAddresses;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourcePorts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSourcePorts() {
        return sourcePorts != null && !(sourcePorts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The source ports.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourcePorts} method.
     * </p>
     * 
     * @return The source ports.
     */
    public final List<String> sourcePorts() {
        return sourcePorts;
    }

    /**
     * For responses, this returns true if the service returned a value for the DestinationPorts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDestinationPorts() {
        return destinationPorts != null && !(destinationPorts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The destination ports.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDestinationPorts} method.
     * </p>
     * 
     * @return The destination ports.
     */
    public final List<String> destinationPorts() {
        return destinationPorts;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourcePrefixLists property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSourcePrefixLists() {
        return sourcePrefixLists != null && !(sourcePrefixLists instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The source prefix lists.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourcePrefixLists} method.
     * </p>
     * 
     * @return The source prefix lists.
     */
    public final List<String> sourcePrefixLists() {
        return sourcePrefixLists;
    }

    /**
     * For responses, this returns true if the service returned a value for the DestinationPrefixLists property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDestinationPrefixLists() {
        return destinationPrefixLists != null && !(destinationPrefixLists instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The destination prefix lists.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDestinationPrefixLists} method.
     * </p>
     * 
     * @return The destination prefix lists.
     */
    public final List<String> destinationPrefixLists() {
        return destinationPrefixLists;
    }

    /**
     * <p>
     * The protocols.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProtocols} method.
     * </p>
     * 
     * @return The protocols.
     */
    public final List<Protocol> protocols() {
        return ProtocolListCopier.copyStringToEnum(protocols);
    }

    /**
     * For responses, this returns true if the service returned a value for the Protocols property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasProtocols() {
        return protocols != null && !(protocols instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The protocols.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProtocols} method.
     * </p>
     * 
     * @return The protocols.
     */
    public final List<String> protocolsAsStrings() {
        return protocols;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceAddresses() ? sourceAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDestinationAddresses() ? destinationAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSourcePorts() ? sourcePorts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDestinationPorts() ? destinationPorts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSourcePrefixLists() ? sourcePrefixLists() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDestinationPrefixLists() ? destinationPrefixLists() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasProtocols() ? protocolsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PacketHeaderStatementRequest)) {
            return false;
        }
        PacketHeaderStatementRequest other = (PacketHeaderStatementRequest) obj;
        return hasSourceAddresses() == other.hasSourceAddresses() && Objects.equals(sourceAddresses(), other.sourceAddresses())
                && hasDestinationAddresses() == other.hasDestinationAddresses()
                && Objects.equals(destinationAddresses(), other.destinationAddresses())
                && hasSourcePorts() == other.hasSourcePorts() && Objects.equals(sourcePorts(), other.sourcePorts())
                && hasDestinationPorts() == other.hasDestinationPorts()
                && Objects.equals(destinationPorts(), other.destinationPorts())
                && hasSourcePrefixLists() == other.hasSourcePrefixLists()
                && Objects.equals(sourcePrefixLists(), other.sourcePrefixLists())
                && hasDestinationPrefixLists() == other.hasDestinationPrefixLists()
                && Objects.equals(destinationPrefixLists(), other.destinationPrefixLists())
                && hasProtocols() == other.hasProtocols() && Objects.equals(protocolsAsStrings(), other.protocolsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PacketHeaderStatementRequest")
                .add("SourceAddresses", hasSourceAddresses() ? sourceAddresses() : null)
                .add("DestinationAddresses", hasDestinationAddresses() ? destinationAddresses() : null)
                .add("SourcePorts", hasSourcePorts() ? sourcePorts() : null)
                .add("DestinationPorts", hasDestinationPorts() ? destinationPorts() : null)
                .add("SourcePrefixLists", hasSourcePrefixLists() ? sourcePrefixLists() : null)
                .add("DestinationPrefixLists", hasDestinationPrefixLists() ? destinationPrefixLists() : null)
                .add("Protocols", hasProtocols() ? protocolsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceAddresses":
            return Optional.ofNullable(clazz.cast(sourceAddresses()));
        case "DestinationAddresses":
            return Optional.ofNullable(clazz.cast(destinationAddresses()));
        case "SourcePorts":
            return Optional.ofNullable(clazz.cast(sourcePorts()));
        case "DestinationPorts":
            return Optional.ofNullable(clazz.cast(destinationPorts()));
        case "SourcePrefixLists":
            return Optional.ofNullable(clazz.cast(sourcePrefixLists()));
        case "DestinationPrefixLists":
            return Optional.ofNullable(clazz.cast(destinationPrefixLists()));
        case "Protocols":
            return Optional.ofNullable(clazz.cast(protocolsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PacketHeaderStatementRequest, T> g) {
        return obj -> g.apply((PacketHeaderStatementRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PacketHeaderStatementRequest> {
        /**
         * <p>
         * The source addresses.
         * </p>
         * 
         * @param sourceAddresses
         *        The source addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceAddresses(Collection<String> sourceAddresses);

        /**
         * <p>
         * The source addresses.
         * </p>
         * 
         * @param sourceAddresses
         *        The source addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceAddresses(String... sourceAddresses);

        /**
         * <p>
         * The destination addresses.
         * </p>
         * 
         * @param destinationAddresses
         *        The destination addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationAddresses(Collection<String> destinationAddresses);

        /**
         * <p>
         * The destination addresses.
         * </p>
         * 
         * @param destinationAddresses
         *        The destination addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationAddresses(String... destinationAddresses);

        /**
         * <p>
         * The source ports.
         * </p>
         * 
         * @param sourcePorts
         *        The source ports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourcePorts(Collection<String> sourcePorts);

        /**
         * <p>
         * The source ports.
         * </p>
         * 
         * @param sourcePorts
         *        The source ports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourcePorts(String... sourcePorts);

        /**
         * <p>
         * The destination ports.
         * </p>
         * 
         * @param destinationPorts
         *        The destination ports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPorts(Collection<String> destinationPorts);

        /**
         * <p>
         * The destination ports.
         * </p>
         * 
         * @param destinationPorts
         *        The destination ports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPorts(String... destinationPorts);

        /**
         * <p>
         * The source prefix lists.
         * </p>
         * 
         * @param sourcePrefixLists
         *        The source prefix lists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourcePrefixLists(Collection<String> sourcePrefixLists);

        /**
         * <p>
         * The source prefix lists.
         * </p>
         * 
         * @param sourcePrefixLists
         *        The source prefix lists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourcePrefixLists(String... sourcePrefixLists);

        /**
         * <p>
         * The destination prefix lists.
         * </p>
         * 
         * @param destinationPrefixLists
         *        The destination prefix lists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPrefixLists(Collection<String> destinationPrefixLists);

        /**
         * <p>
         * The destination prefix lists.
         * </p>
         * 
         * @param destinationPrefixLists
         *        The destination prefix lists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPrefixLists(String... destinationPrefixLists);

        /**
         * <p>
         * The protocols.
         * </p>
         * 
         * @param protocols
         *        The protocols.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocolsWithStrings(Collection<String> protocols);

        /**
         * <p>
         * The protocols.
         * </p>
         * 
         * @param protocols
         *        The protocols.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocolsWithStrings(String... protocols);

        /**
         * <p>
         * The protocols.
         * </p>
         * 
         * @param protocols
         *        The protocols.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocols(Collection<Protocol> protocols);

        /**
         * <p>
         * The protocols.
         * </p>
         * 
         * @param protocols
         *        The protocols.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocols(Protocol... protocols);
    }

    static final class BuilderImpl implements Builder {
        private List<String> sourceAddresses = DefaultSdkAutoConstructList.getInstance();

        private List<String> destinationAddresses = DefaultSdkAutoConstructList.getInstance();

        private List<String> sourcePorts = DefaultSdkAutoConstructList.getInstance();

        private List<String> destinationPorts = DefaultSdkAutoConstructList.getInstance();

        private List<String> sourcePrefixLists = DefaultSdkAutoConstructList.getInstance();

        private List<String> destinationPrefixLists = DefaultSdkAutoConstructList.getInstance();

        private List<String> protocols = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PacketHeaderStatementRequest model) {
            sourceAddresses(model.sourceAddresses);
            destinationAddresses(model.destinationAddresses);
            sourcePorts(model.sourcePorts);
            destinationPorts(model.destinationPorts);
            sourcePrefixLists(model.sourcePrefixLists);
            destinationPrefixLists(model.destinationPrefixLists);
            protocolsWithStrings(model.protocols);
        }

        public final Collection<String> getSourceAddresses() {
            if (sourceAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return sourceAddresses;
        }

        public final void setSourceAddresses(Collection<String> sourceAddresses) {
            this.sourceAddresses = ValueStringListCopier.copy(sourceAddresses);
        }

        @Override
        public final Builder sourceAddresses(Collection<String> sourceAddresses) {
            this.sourceAddresses = ValueStringListCopier.copy(sourceAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceAddresses(String... sourceAddresses) {
            sourceAddresses(Arrays.asList(sourceAddresses));
            return this;
        }

        public final Collection<String> getDestinationAddresses() {
            if (destinationAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return destinationAddresses;
        }

        public final void setDestinationAddresses(Collection<String> destinationAddresses) {
            this.destinationAddresses = ValueStringListCopier.copy(destinationAddresses);
        }

        @Override
        public final Builder destinationAddresses(Collection<String> destinationAddresses) {
            this.destinationAddresses = ValueStringListCopier.copy(destinationAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationAddresses(String... destinationAddresses) {
            destinationAddresses(Arrays.asList(destinationAddresses));
            return this;
        }

        public final Collection<String> getSourcePorts() {
            if (sourcePorts instanceof SdkAutoConstructList) {
                return null;
            }
            return sourcePorts;
        }

        public final void setSourcePorts(Collection<String> sourcePorts) {
            this.sourcePorts = ValueStringListCopier.copy(sourcePorts);
        }

        @Override
        public final Builder sourcePorts(Collection<String> sourcePorts) {
            this.sourcePorts = ValueStringListCopier.copy(sourcePorts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourcePorts(String... sourcePorts) {
            sourcePorts(Arrays.asList(sourcePorts));
            return this;
        }

        public final Collection<String> getDestinationPorts() {
            if (destinationPorts instanceof SdkAutoConstructList) {
                return null;
            }
            return destinationPorts;
        }

        public final void setDestinationPorts(Collection<String> destinationPorts) {
            this.destinationPorts = ValueStringListCopier.copy(destinationPorts);
        }

        @Override
        public final Builder destinationPorts(Collection<String> destinationPorts) {
            this.destinationPorts = ValueStringListCopier.copy(destinationPorts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationPorts(String... destinationPorts) {
            destinationPorts(Arrays.asList(destinationPorts));
            return this;
        }

        public final Collection<String> getSourcePrefixLists() {
            if (sourcePrefixLists instanceof SdkAutoConstructList) {
                return null;
            }
            return sourcePrefixLists;
        }

        public final void setSourcePrefixLists(Collection<String> sourcePrefixLists) {
            this.sourcePrefixLists = ValueStringListCopier.copy(sourcePrefixLists);
        }

        @Override
        public final Builder sourcePrefixLists(Collection<String> sourcePrefixLists) {
            this.sourcePrefixLists = ValueStringListCopier.copy(sourcePrefixLists);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourcePrefixLists(String... sourcePrefixLists) {
            sourcePrefixLists(Arrays.asList(sourcePrefixLists));
            return this;
        }

        public final Collection<String> getDestinationPrefixLists() {
            if (destinationPrefixLists instanceof SdkAutoConstructList) {
                return null;
            }
            return destinationPrefixLists;
        }

        public final void setDestinationPrefixLists(Collection<String> destinationPrefixLists) {
            this.destinationPrefixLists = ValueStringListCopier.copy(destinationPrefixLists);
        }

        @Override
        public final Builder destinationPrefixLists(Collection<String> destinationPrefixLists) {
            this.destinationPrefixLists = ValueStringListCopier.copy(destinationPrefixLists);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationPrefixLists(String... destinationPrefixLists) {
            destinationPrefixLists(Arrays.asList(destinationPrefixLists));
            return this;
        }

        public final Collection<String> getProtocols() {
            if (protocols instanceof SdkAutoConstructList) {
                return null;
            }
            return protocols;
        }

        public final void setProtocols(Collection<String> protocols) {
            this.protocols = ProtocolListCopier.copy(protocols);
        }

        @Override
        public final Builder protocolsWithStrings(Collection<String> protocols) {
            this.protocols = ProtocolListCopier.copy(protocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocolsWithStrings(String... protocols) {
            protocolsWithStrings(Arrays.asList(protocols));
            return this;
        }

        @Override
        public final Builder protocols(Collection<Protocol> protocols) {
            this.protocols = ProtocolListCopier.copyEnumToString(protocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocols(Protocol... protocols) {
            protocols(Arrays.asList(protocols));
            return this;
        }

        @Override
        public PacketHeaderStatementRequest build() {
            return new PacketHeaderStatementRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
