/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the ID format for a resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdFormat implements SdkPojo, Serializable, ToCopyableBuilder<IdFormat.Builder, IdFormat> {
    private static final SdkField<Instant> DEADLINE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("Deadline")
            .getter(getter(IdFormat::deadline))
            .setter(setter(Builder::deadline))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Deadline")
                    .unmarshallLocationName("deadline").build()).build();

    private static final SdkField<String> RESOURCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Resource")
            .getter(getter(IdFormat::resource))
            .setter(setter(Builder::resource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resource")
                    .unmarshallLocationName("resource").build()).build();

    private static final SdkField<Boolean> USE_LONG_IDS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UseLongIds")
            .getter(getter(IdFormat::useLongIds))
            .setter(setter(Builder::useLongIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseLongIds")
                    .unmarshallLocationName("useLongIds").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEADLINE_FIELD,
            RESOURCE_FIELD, USE_LONG_IDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant deadline;

    private final String resource;

    private final Boolean useLongIds;

    private IdFormat(BuilderImpl builder) {
        this.deadline = builder.deadline;
        this.resource = builder.resource;
        this.useLongIds = builder.useLongIds;
    }

    /**
     * <p>
     * The date in UTC at which you are permanently switched over to using longer IDs. If a deadline is not yet
     * available for this resource type, this field is not returned.
     * </p>
     * 
     * @return The date in UTC at which you are permanently switched over to using longer IDs. If a deadline is not yet
     *         available for this resource type, this field is not returned.
     */
    public final Instant deadline() {
        return deadline;
    }

    /**
     * <p>
     * The type of resource.
     * </p>
     * 
     * @return The type of resource.
     */
    public final String resource() {
        return resource;
    }

    /**
     * <p>
     * Indicates whether longer IDs (17-character IDs) are enabled for the resource.
     * </p>
     * 
     * @return Indicates whether longer IDs (17-character IDs) are enabled for the resource.
     */
    public final Boolean useLongIds() {
        return useLongIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deadline());
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        hashCode = 31 * hashCode + Objects.hashCode(useLongIds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdFormat)) {
            return false;
        }
        IdFormat other = (IdFormat) obj;
        return Objects.equals(deadline(), other.deadline()) && Objects.equals(resource(), other.resource())
                && Objects.equals(useLongIds(), other.useLongIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IdFormat").add("Deadline", deadline()).add("Resource", resource())
                .add("UseLongIds", useLongIds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Deadline":
            return Optional.ofNullable(clazz.cast(deadline()));
        case "Resource":
            return Optional.ofNullable(clazz.cast(resource()));
        case "UseLongIds":
            return Optional.ofNullable(clazz.cast(useLongIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IdFormat, T> g) {
        return obj -> g.apply((IdFormat) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdFormat> {
        /**
         * <p>
         * The date in UTC at which you are permanently switched over to using longer IDs. If a deadline is not yet
         * available for this resource type, this field is not returned.
         * </p>
         * 
         * @param deadline
         *        The date in UTC at which you are permanently switched over to using longer IDs. If a deadline is not
         *        yet available for this resource type, this field is not returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deadline(Instant deadline);

        /**
         * <p>
         * The type of resource.
         * </p>
         * 
         * @param resource
         *        The type of resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(String resource);

        /**
         * <p>
         * Indicates whether longer IDs (17-character IDs) are enabled for the resource.
         * </p>
         * 
         * @param useLongIds
         *        Indicates whether longer IDs (17-character IDs) are enabled for the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useLongIds(Boolean useLongIds);
    }

    static final class BuilderImpl implements Builder {
        private Instant deadline;

        private String resource;

        private Boolean useLongIds;

        private BuilderImpl() {
        }

        private BuilderImpl(IdFormat model) {
            deadline(model.deadline);
            resource(model.resource);
            useLongIds(model.useLongIds);
        }

        public final Instant getDeadline() {
            return deadline;
        }

        public final void setDeadline(Instant deadline) {
            this.deadline = deadline;
        }

        @Override
        public final Builder deadline(Instant deadline) {
            this.deadline = deadline;
            return this;
        }

        public final String getResource() {
            return resource;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final Boolean getUseLongIds() {
            return useLongIds;
        }

        public final void setUseLongIds(Boolean useLongIds) {
            this.useLongIds = useLongIds;
        }

        @Override
        public final Builder useLongIds(Boolean useLongIds) {
            this.useLongIds = useLongIds;
            return this;
        }

        @Override
        public IdFormat build() {
            return new IdFormat(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
