/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an error that occurred when enabling fast snapshot restores.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnableFastSnapshotRestoreStateErrorItem implements SdkPojo, Serializable,
        ToCopyableBuilder<EnableFastSnapshotRestoreStateErrorItem.Builder, EnableFastSnapshotRestoreStateErrorItem> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone")
            .getter(getter(EnableFastSnapshotRestoreStateErrorItem::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone")
                    .unmarshallLocationName("availabilityZone").build()).build();

    private static final SdkField<EnableFastSnapshotRestoreStateError> ERROR_FIELD = SdkField
            .<EnableFastSnapshotRestoreStateError> builder(MarshallingType.SDK_POJO)
            .memberName("Error")
            .getter(getter(EnableFastSnapshotRestoreStateErrorItem::error))
            .setter(setter(Builder::error))
            .constructor(EnableFastSnapshotRestoreStateError::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error")
                    .unmarshallLocationName("error").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD,
            ERROR_FIELD));

    private static final long serialVersionUID = 1L;

    private final String availabilityZone;

    private final EnableFastSnapshotRestoreStateError error;

    private EnableFastSnapshotRestoreStateErrorItem(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.error = builder.error;
    }

    /**
     * <p>
     * The Availability Zone.
     * </p>
     * 
     * @return The Availability Zone.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The error.
     * </p>
     * 
     * @return The error.
     */
    public final EnableFastSnapshotRestoreStateError error() {
        return error;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableFastSnapshotRestoreStateErrorItem)) {
            return false;
        }
        EnableFastSnapshotRestoreStateErrorItem other = (EnableFastSnapshotRestoreStateErrorItem) obj;
        return Objects.equals(availabilityZone(), other.availabilityZone()) && Objects.equals(error(), other.error());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnableFastSnapshotRestoreStateErrorItem").add("AvailabilityZone", availabilityZone())
                .add("Error", error()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnableFastSnapshotRestoreStateErrorItem, T> g) {
        return obj -> g.apply((EnableFastSnapshotRestoreStateErrorItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnableFastSnapshotRestoreStateErrorItem> {
        /**
         * <p>
         * The Availability Zone.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The error.
         * </p>
         * 
         * @param error
         *        The error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(EnableFastSnapshotRestoreStateError error);

        /**
         * <p>
         * The error.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link EnableFastSnapshotRestoreStateError.Builder} avoiding the need to create one manually via
         * {@link EnableFastSnapshotRestoreStateError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EnableFastSnapshotRestoreStateError.Builder#build()} is called
         * immediately and its result is passed to {@link #error(EnableFastSnapshotRestoreStateError)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link EnableFastSnapshotRestoreStateError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(EnableFastSnapshotRestoreStateError)
         */
        default Builder error(Consumer<EnableFastSnapshotRestoreStateError.Builder> error) {
            return error(EnableFastSnapshotRestoreStateError.builder().applyMutation(error).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String availabilityZone;

        private EnableFastSnapshotRestoreStateError error;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableFastSnapshotRestoreStateErrorItem model) {
            availabilityZone(model.availabilityZone);
            error(model.error);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final EnableFastSnapshotRestoreStateError.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(EnableFastSnapshotRestoreStateError.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(EnableFastSnapshotRestoreStateError error) {
            this.error = error;
            return this;
        }

        @Override
        public EnableFastSnapshotRestoreStateErrorItem build() {
            return new EnableFastSnapshotRestoreStateErrorItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
