/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteTransitGatewayConnectPeerRequest extends Ec2Request implements
        ToCopyableBuilder<DeleteTransitGatewayConnectPeerRequest.Builder, DeleteTransitGatewayConnectPeerRequest> {
    private static final SdkField<String> TRANSIT_GATEWAY_CONNECT_PEER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayConnectPeerId")
            .getter(getter(DeleteTransitGatewayConnectPeerRequest::transitGatewayConnectPeerId))
            .setter(setter(Builder::transitGatewayConnectPeerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayConnectPeerId")
                    .unmarshallLocationName("TransitGatewayConnectPeerId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TRANSIT_GATEWAY_CONNECT_PEER_ID_FIELD));

    private final String transitGatewayConnectPeerId;

    private DeleteTransitGatewayConnectPeerRequest(BuilderImpl builder) {
        super(builder);
        this.transitGatewayConnectPeerId = builder.transitGatewayConnectPeerId;
    }

    /**
     * <p>
     * The ID of the Connect peer.
     * </p>
     * 
     * @return The ID of the Connect peer.
     */
    public final String transitGatewayConnectPeerId() {
        return transitGatewayConnectPeerId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayConnectPeerId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteTransitGatewayConnectPeerRequest)) {
            return false;
        }
        DeleteTransitGatewayConnectPeerRequest other = (DeleteTransitGatewayConnectPeerRequest) obj;
        return Objects.equals(transitGatewayConnectPeerId(), other.transitGatewayConnectPeerId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteTransitGatewayConnectPeerRequest")
                .add("TransitGatewayConnectPeerId", transitGatewayConnectPeerId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGatewayConnectPeerId":
            return Optional.ofNullable(clazz.cast(transitGatewayConnectPeerId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteTransitGatewayConnectPeerRequest, T> g) {
        return obj -> g.apply((DeleteTransitGatewayConnectPeerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteTransitGatewayConnectPeerRequest> {
        /**
         * <p>
         * The ID of the Connect peer.
         * </p>
         * 
         * @param transitGatewayConnectPeerId
         *        The ID of the Connect peer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayConnectPeerId(String transitGatewayConnectPeerId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String transitGatewayConnectPeerId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteTransitGatewayConnectPeerRequest model) {
            super(model);
            transitGatewayConnectPeerId(model.transitGatewayConnectPeerId);
        }

        public final String getTransitGatewayConnectPeerId() {
            return transitGatewayConnectPeerId;
        }

        public final void setTransitGatewayConnectPeerId(String transitGatewayConnectPeerId) {
            this.transitGatewayConnectPeerId = transitGatewayConnectPeerId;
        }

        @Override
        public final Builder transitGatewayConnectPeerId(String transitGatewayConnectPeerId) {
            this.transitGatewayConnectPeerId = transitGatewayConnectPeerId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteTransitGatewayConnectPeerRequest build() {
            return new DeleteTransitGatewayConnectPeerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
