/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The options for managing connection authorization for new client connections.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClientConnectOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<ClientConnectOptions.Builder, ClientConnectOptions> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled")
            .getter(getter(ClientConnectOptions::enabled))
            .setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled")
                    .unmarshallLocationName("Enabled").build()).build();

    private static final SdkField<String> LAMBDA_FUNCTION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LambdaFunctionArn")
            .getter(getter(ClientConnectOptions::lambdaFunctionArn))
            .setter(setter(Builder::lambdaFunctionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaFunctionArn")
                    .unmarshallLocationName("LambdaFunctionArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            LAMBDA_FUNCTION_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final String lambdaFunctionArn;

    private ClientConnectOptions(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.lambdaFunctionArn = builder.lambdaFunctionArn;
    }

    /**
     * <p>
     * Indicates whether client connect options are enabled. The default is <code>false</code> (not enabled).
     * </p>
     * 
     * @return Indicates whether client connect options are enabled. The default is <code>false</code> (not enabled).
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Lambda function used for connection authorization.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Lambda function used for connection authorization.
     */
    public final String lambdaFunctionArn() {
        return lambdaFunctionArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaFunctionArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClientConnectOptions)) {
            return false;
        }
        ClientConnectOptions other = (ClientConnectOptions) obj;
        return Objects.equals(enabled(), other.enabled()) && Objects.equals(lambdaFunctionArn(), other.lambdaFunctionArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClientConnectOptions").add("Enabled", enabled()).add("LambdaFunctionArn", lambdaFunctionArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "LambdaFunctionArn":
            return Optional.ofNullable(clazz.cast(lambdaFunctionArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClientConnectOptions, T> g) {
        return obj -> g.apply((ClientConnectOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClientConnectOptions> {
        /**
         * <p>
         * Indicates whether client connect options are enabled. The default is <code>false</code> (not enabled).
         * </p>
         * 
         * @param enabled
         *        Indicates whether client connect options are enabled. The default is <code>false</code> (not enabled).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Lambda function used for connection authorization.
         * </p>
         * 
         * @param lambdaFunctionArn
         *        The Amazon Resource Name (ARN) of the Lambda function used for connection authorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunctionArn(String lambdaFunctionArn);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private String lambdaFunctionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ClientConnectOptions model) {
            enabled(model.enabled);
            lambdaFunctionArn(model.lambdaFunctionArn);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getLambdaFunctionArn() {
            return lambdaFunctionArn;
        }

        public final void setLambdaFunctionArn(String lambdaFunctionArn) {
            this.lambdaFunctionArn = lambdaFunctionArn;
        }

        @Override
        public final Builder lambdaFunctionArn(String lambdaFunctionArn) {
            this.lambdaFunctionArn = lambdaFunctionArn;
            return this;
        }

        @Override
        public ClientConnectOptions build() {
            return new ClientConnectOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
