/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a finding for a Network Access Scope.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccessScopeAnalysisFinding implements SdkPojo, Serializable,
        ToCopyableBuilder<AccessScopeAnalysisFinding.Builder, AccessScopeAnalysisFinding> {
    private static final SdkField<String> NETWORK_INSIGHTS_ACCESS_SCOPE_ANALYSIS_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkInsightsAccessScopeAnalysisId")
            .getter(getter(AccessScopeAnalysisFinding::networkInsightsAccessScopeAnalysisId))
            .setter(setter(Builder::networkInsightsAccessScopeAnalysisId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("NetworkInsightsAccessScopeAnalysisId")
                    .unmarshallLocationName("networkInsightsAccessScopeAnalysisId").build()).build();

    private static final SdkField<String> NETWORK_INSIGHTS_ACCESS_SCOPE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkInsightsAccessScopeId")
            .getter(getter(AccessScopeAnalysisFinding::networkInsightsAccessScopeId))
            .setter(setter(Builder::networkInsightsAccessScopeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInsightsAccessScopeId")
                    .unmarshallLocationName("networkInsightsAccessScopeId").build()).build();

    private static final SdkField<String> FINDING_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("FindingId")
            .getter(getter(AccessScopeAnalysisFinding::findingId))
            .setter(setter(Builder::findingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FindingId")
                    .unmarshallLocationName("findingId").build()).build();

    private static final SdkField<List<PathComponent>> FINDING_COMPONENTS_FIELD = SdkField
            .<List<PathComponent>> builder(MarshallingType.LIST)
            .memberName("FindingComponents")
            .getter(getter(AccessScopeAnalysisFinding::findingComponents))
            .setter(setter(Builder::findingComponents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FindingComponentSet")
                    .unmarshallLocationName("findingComponentSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<PathComponent> builder(MarshallingType.SDK_POJO)
                                            .constructor(PathComponent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            NETWORK_INSIGHTS_ACCESS_SCOPE_ANALYSIS_ID_FIELD, NETWORK_INSIGHTS_ACCESS_SCOPE_ID_FIELD, FINDING_ID_FIELD,
            FINDING_COMPONENTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String networkInsightsAccessScopeAnalysisId;

    private final String networkInsightsAccessScopeId;

    private final String findingId;

    private final List<PathComponent> findingComponents;

    private AccessScopeAnalysisFinding(BuilderImpl builder) {
        this.networkInsightsAccessScopeAnalysisId = builder.networkInsightsAccessScopeAnalysisId;
        this.networkInsightsAccessScopeId = builder.networkInsightsAccessScopeId;
        this.findingId = builder.findingId;
        this.findingComponents = builder.findingComponents;
    }

    /**
     * <p>
     * The ID of the Network Access Scope analysis.
     * </p>
     * 
     * @return The ID of the Network Access Scope analysis.
     */
    public final String networkInsightsAccessScopeAnalysisId() {
        return networkInsightsAccessScopeAnalysisId;
    }

    /**
     * <p>
     * The ID of the Network Access Scope.
     * </p>
     * 
     * @return The ID of the Network Access Scope.
     */
    public final String networkInsightsAccessScopeId() {
        return networkInsightsAccessScopeId;
    }

    /**
     * <p>
     * The ID of the finding.
     * </p>
     * 
     * @return The ID of the finding.
     */
    public final String findingId() {
        return findingId;
    }

    /**
     * For responses, this returns true if the service returned a value for the FindingComponents property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFindingComponents() {
        return findingComponents != null && !(findingComponents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The finding components.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFindingComponents} method.
     * </p>
     * 
     * @return The finding components.
     */
    public final List<PathComponent> findingComponents() {
        return findingComponents;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(networkInsightsAccessScopeAnalysisId());
        hashCode = 31 * hashCode + Objects.hashCode(networkInsightsAccessScopeId());
        hashCode = 31 * hashCode + Objects.hashCode(findingId());
        hashCode = 31 * hashCode + Objects.hashCode(hasFindingComponents() ? findingComponents() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessScopeAnalysisFinding)) {
            return false;
        }
        AccessScopeAnalysisFinding other = (AccessScopeAnalysisFinding) obj;
        return Objects.equals(networkInsightsAccessScopeAnalysisId(), other.networkInsightsAccessScopeAnalysisId())
                && Objects.equals(networkInsightsAccessScopeId(), other.networkInsightsAccessScopeId())
                && Objects.equals(findingId(), other.findingId()) && hasFindingComponents() == other.hasFindingComponents()
                && Objects.equals(findingComponents(), other.findingComponents());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccessScopeAnalysisFinding")
                .add("NetworkInsightsAccessScopeAnalysisId", networkInsightsAccessScopeAnalysisId())
                .add("NetworkInsightsAccessScopeId", networkInsightsAccessScopeId()).add("FindingId", findingId())
                .add("FindingComponents", hasFindingComponents() ? findingComponents() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkInsightsAccessScopeAnalysisId":
            return Optional.ofNullable(clazz.cast(networkInsightsAccessScopeAnalysisId()));
        case "NetworkInsightsAccessScopeId":
            return Optional.ofNullable(clazz.cast(networkInsightsAccessScopeId()));
        case "FindingId":
            return Optional.ofNullable(clazz.cast(findingId()));
        case "FindingComponents":
            return Optional.ofNullable(clazz.cast(findingComponents()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccessScopeAnalysisFinding, T> g) {
        return obj -> g.apply((AccessScopeAnalysisFinding) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccessScopeAnalysisFinding> {
        /**
         * <p>
         * The ID of the Network Access Scope analysis.
         * </p>
         * 
         * @param networkInsightsAccessScopeAnalysisId
         *        The ID of the Network Access Scope analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInsightsAccessScopeAnalysisId(String networkInsightsAccessScopeAnalysisId);

        /**
         * <p>
         * The ID of the Network Access Scope.
         * </p>
         * 
         * @param networkInsightsAccessScopeId
         *        The ID of the Network Access Scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInsightsAccessScopeId(String networkInsightsAccessScopeId);

        /**
         * <p>
         * The ID of the finding.
         * </p>
         * 
         * @param findingId
         *        The ID of the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingId(String findingId);

        /**
         * <p>
         * The finding components.
         * </p>
         * 
         * @param findingComponents
         *        The finding components.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingComponents(Collection<PathComponent> findingComponents);

        /**
         * <p>
         * The finding components.
         * </p>
         * 
         * @param findingComponents
         *        The finding components.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingComponents(PathComponent... findingComponents);

        /**
         * <p>
         * The finding components.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.PathComponent.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.PathComponent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.PathComponent.Builder#build()} is called immediately and its
         * result is passed to {@link #findingComponents(List<PathComponent>)}.
         * 
         * @param findingComponents
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.PathComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #findingComponents(java.util.Collection<PathComponent>)
         */
        Builder findingComponents(Consumer<PathComponent.Builder>... findingComponents);
    }

    static final class BuilderImpl implements Builder {
        private String networkInsightsAccessScopeAnalysisId;

        private String networkInsightsAccessScopeId;

        private String findingId;

        private List<PathComponent> findingComponents = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AccessScopeAnalysisFinding model) {
            networkInsightsAccessScopeAnalysisId(model.networkInsightsAccessScopeAnalysisId);
            networkInsightsAccessScopeId(model.networkInsightsAccessScopeId);
            findingId(model.findingId);
            findingComponents(model.findingComponents);
        }

        public final String getNetworkInsightsAccessScopeAnalysisId() {
            return networkInsightsAccessScopeAnalysisId;
        }

        public final void setNetworkInsightsAccessScopeAnalysisId(String networkInsightsAccessScopeAnalysisId) {
            this.networkInsightsAccessScopeAnalysisId = networkInsightsAccessScopeAnalysisId;
        }

        @Override
        public final Builder networkInsightsAccessScopeAnalysisId(String networkInsightsAccessScopeAnalysisId) {
            this.networkInsightsAccessScopeAnalysisId = networkInsightsAccessScopeAnalysisId;
            return this;
        }

        public final String getNetworkInsightsAccessScopeId() {
            return networkInsightsAccessScopeId;
        }

        public final void setNetworkInsightsAccessScopeId(String networkInsightsAccessScopeId) {
            this.networkInsightsAccessScopeId = networkInsightsAccessScopeId;
        }

        @Override
        public final Builder networkInsightsAccessScopeId(String networkInsightsAccessScopeId) {
            this.networkInsightsAccessScopeId = networkInsightsAccessScopeId;
            return this;
        }

        public final String getFindingId() {
            return findingId;
        }

        public final void setFindingId(String findingId) {
            this.findingId = findingId;
        }

        @Override
        public final Builder findingId(String findingId) {
            this.findingId = findingId;
            return this;
        }

        public final List<PathComponent.Builder> getFindingComponents() {
            List<PathComponent.Builder> result = PathComponentListCopier.copyToBuilder(this.findingComponents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFindingComponents(Collection<PathComponent.BuilderImpl> findingComponents) {
            this.findingComponents = PathComponentListCopier.copyFromBuilder(findingComponents);
        }

        @Override
        public final Builder findingComponents(Collection<PathComponent> findingComponents) {
            this.findingComponents = PathComponentListCopier.copy(findingComponents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingComponents(PathComponent... findingComponents) {
            findingComponents(Arrays.asList(findingComponents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingComponents(Consumer<PathComponent.Builder>... findingComponents) {
            findingComponents(Stream.of(findingComponents).map(c -> PathComponent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AccessScopeAnalysisFinding build() {
            return new AccessScopeAnalysisFinding(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
