/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.protocols.query.interceptor.QueryParametersToBodyInterceptor;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ec2.DefaultEc2BaseClientBuilder;
import software.amazon.awssdk.services.ec2.DefaultEc2Client;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.Ec2ClientBuilder;
import software.amazon.awssdk.services.ec2.Ec2ServiceClientConfiguration;
import software.amazon.awssdk.services.ec2.endpoints.Ec2EndpointProvider;
import software.amazon.awssdk.services.ec2.transform.internal.GeneratePreSignUrlInterceptor;
import software.amazon.awssdk.services.ec2.transform.internal.TimestampFormatInterceptor;
import software.amazon.awssdk.utils.CollectionUtils;

@SdkInternalApi
final class DefaultEc2ClientBuilder
extends DefaultEc2BaseClientBuilder<Ec2ClientBuilder, Ec2Client>
implements Ec2ClientBuilder {
    DefaultEc2ClientBuilder() {
    }

    @Override
    public DefaultEc2ClientBuilder endpointProvider(Ec2EndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final Ec2Client buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        List interceptors = (List)clientConfiguration.option((ClientOption)SdkClientOption.EXECUTION_INTERCEPTORS);
        List<QueryParametersToBodyInterceptor> queryParamsToBodyInterceptor = Collections.singletonList(new QueryParametersToBodyInterceptor());
        ArrayList<Object> customizationInterceptors = new ArrayList<Object>();
        customizationInterceptors.add(new GeneratePreSignUrlInterceptor());
        customizationInterceptors.add(new TimestampFormatInterceptor());
        interceptors = CollectionUtils.mergeLists(queryParamsToBodyInterceptor, (List)interceptors);
        interceptors = CollectionUtils.mergeLists(customizationInterceptors, (List)interceptors);
        clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.EXECUTION_INTERCEPTORS, (Object)interceptors).build();
        DefaultEc2ClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        Ec2ServiceClientConfiguration serviceClientConfiguration = Ec2ServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultEc2Client(serviceClientConfiguration, clientConfiguration);
    }
}

