/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.model.DescribeIamInstanceProfileAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIamInstanceProfileAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.IamInstanceProfileAssociation;

public class DescribeIamInstanceProfileAssociationsPublisher
implements SdkPublisher<DescribeIamInstanceProfileAssociationsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeIamInstanceProfileAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeIamInstanceProfileAssociationsPublisher(Ec2AsyncClient client, DescribeIamInstanceProfileAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeIamInstanceProfileAssociationsPublisher(Ec2AsyncClient client, DescribeIamInstanceProfileAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeIamInstanceProfileAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeIamInstanceProfileAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<IamInstanceProfileAssociation> iamInstanceProfileAssociations() {
        Function<DescribeIamInstanceProfileAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.iamInstanceProfileAssociations() != null) {
                return response.iamInstanceProfileAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeIamInstanceProfileAssociationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeIamInstanceProfileAssociationsResponseFetcher
    implements AsyncPageFetcher<DescribeIamInstanceProfileAssociationsResponse> {
        private DescribeIamInstanceProfileAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeIamInstanceProfileAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeIamInstanceProfileAssociationsResponse> nextPage(DescribeIamInstanceProfileAssociationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeIamInstanceProfileAssociationsPublisher.this.client.describeIamInstanceProfileAssociations(DescribeIamInstanceProfileAssociationsPublisher.this.firstRequest);
            }
            return DescribeIamInstanceProfileAssociationsPublisher.this.client.describeIamInstanceProfileAssociations((DescribeIamInstanceProfileAssociationsRequest)((Object)DescribeIamInstanceProfileAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

