/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.FpgaImageIdListCopier;
import software.amazon.awssdk.services.ec2.model.OwnerStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFpgaImagesRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DescribeFpgaImagesRequest> {
    private static final SdkField<List<String>> FPGA_IMAGE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FpgaImageIds").getter(DescribeFpgaImagesRequest.getter(DescribeFpgaImagesRequest::fpgaImageIds)).setter(DescribeFpgaImagesRequest.setter(Builder::fpgaImageIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FpgaImageId").unmarshallLocationName("FpgaImageId").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> OWNERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Owners").getter(DescribeFpgaImagesRequest.getter(DescribeFpgaImagesRequest::owners)).setter(DescribeFpgaImagesRequest.setter(Builder::owners)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").unmarshallLocationName("Owner").build(), ListTrait.builder().memberLocationName("Owner").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").unmarshallLocationName("Owner").build()}).build()).build()}).build();
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(DescribeFpgaImagesRequest.getter(DescribeFpgaImagesRequest::filters)).setter(DescribeFpgaImagesRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build(), ListTrait.builder().memberLocationName("Filter").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeFpgaImagesRequest.getter(DescribeFpgaImagesRequest::nextToken)).setter(DescribeFpgaImagesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeFpgaImagesRequest.getter(DescribeFpgaImagesRequest::maxResults)).setter(DescribeFpgaImagesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").unmarshallLocationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FPGA_IMAGE_IDS_FIELD, OWNERS_FIELD, FILTERS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final List<String> fpgaImageIds;
    private final List<String> owners;
    private final List<Filter> filters;
    private final String nextToken;
    private final Integer maxResults;

    private DescribeFpgaImagesRequest(BuilderImpl builder) {
        super(builder);
        this.fpgaImageIds = builder.fpgaImageIds;
        this.owners = builder.owners;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final boolean hasFpgaImageIds() {
        return this.fpgaImageIds != null && !(this.fpgaImageIds instanceof SdkAutoConstructList);
    }

    public final List<String> fpgaImageIds() {
        return this.fpgaImageIds;
    }

    public final boolean hasOwners() {
        return this.owners != null && !(this.owners instanceof SdkAutoConstructList);
    }

    public final List<String> owners() {
        return this.owners;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<Filter> filters() {
        return this.filters;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFpgaImageIds() ? this.fpgaImageIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOwners() ? this.owners() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFpgaImagesRequest)) {
            return false;
        }
        DescribeFpgaImagesRequest other = (DescribeFpgaImagesRequest)((Object)obj);
        return this.hasFpgaImageIds() == other.hasFpgaImageIds() && Objects.equals(this.fpgaImageIds(), other.fpgaImageIds()) && this.hasOwners() == other.hasOwners() && Objects.equals(this.owners(), other.owners()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeFpgaImagesRequest").add("FpgaImageIds", this.hasFpgaImageIds() ? this.fpgaImageIds() : null).add("Owners", this.hasOwners() ? this.owners() : null).add("Filters", this.hasFilters() ? this.filters() : null).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FpgaImageIds": {
                return Optional.ofNullable(clazz.cast(this.fpgaImageIds()));
            }
            case "Owners": {
                return Optional.ofNullable(clazz.cast(this.owners()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFpgaImagesRequest, T> g) {
        return obj -> g.apply((DescribeFpgaImagesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<String> fpgaImageIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> owners = DefaultSdkAutoConstructList.getInstance();
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFpgaImagesRequest model) {
            super(model);
            this.fpgaImageIds(model.fpgaImageIds);
            this.owners(model.owners);
            this.filters(model.filters);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final Collection<String> getFpgaImageIds() {
            if (this.fpgaImageIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.fpgaImageIds;
        }

        public final void setFpgaImageIds(Collection<String> fpgaImageIds) {
            this.fpgaImageIds = FpgaImageIdListCopier.copy(fpgaImageIds);
        }

        @Override
        public final Builder fpgaImageIds(Collection<String> fpgaImageIds) {
            this.fpgaImageIds = FpgaImageIdListCopier.copy(fpgaImageIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fpgaImageIds(String ... fpgaImageIds) {
            this.fpgaImageIds(Arrays.asList(fpgaImageIds));
            return this;
        }

        public final Collection<String> getOwners() {
            if (this.owners instanceof SdkAutoConstructList) {
                return null;
            }
            return this.owners;
        }

        public final void setOwners(Collection<String> owners) {
            this.owners = OwnerStringListCopier.copy(owners);
        }

        @Override
        public final Builder owners(Collection<String> owners) {
            this.owners = OwnerStringListCopier.copy(owners);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder owners(String ... owners) {
            this.owners(Arrays.asList(owners));
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeFpgaImagesRequest build() {
            return new DescribeFpgaImagesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeFpgaImagesRequest> {
        public Builder fpgaImageIds(Collection<String> var1);

        public Builder fpgaImageIds(String ... var1);

        public Builder owners(Collection<String> var1);

        public Builder owners(String ... var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder filters(Consumer<Filter.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

