/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.model.DescribeInternetGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInternetGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.InternetGateway;

public class DescribeInternetGatewaysPublisher
implements SdkPublisher<DescribeInternetGatewaysResponse> {
    private final Ec2AsyncClient client;
    private final DescribeInternetGatewaysRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeInternetGatewaysPublisher(Ec2AsyncClient client, DescribeInternetGatewaysRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeInternetGatewaysPublisher(Ec2AsyncClient client, DescribeInternetGatewaysRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeInternetGatewaysResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeInternetGatewaysResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<InternetGateway> internetGateways() {
        Function<DescribeInternetGatewaysResponse, Iterator> getIterator = response -> {
            if (response != null && response.internetGateways() != null) {
                return response.internetGateways().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeInternetGatewaysResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeInternetGatewaysResponseFetcher
    implements AsyncPageFetcher<DescribeInternetGatewaysResponse> {
        private DescribeInternetGatewaysResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInternetGatewaysResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeInternetGatewaysResponse> nextPage(DescribeInternetGatewaysResponse previousPage) {
            if (previousPage == null) {
                return DescribeInternetGatewaysPublisher.this.client.describeInternetGateways(DescribeInternetGatewaysPublisher.this.firstRequest);
            }
            return DescribeInternetGatewaysPublisher.this.client.describeInternetGateways((DescribeInternetGatewaysRequest)((Object)DescribeInternetGatewaysPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

