/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteIpamRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DeleteIpamRequest> {
    private static final SdkField<String> IPAM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamId").getter(DeleteIpamRequest.getter(DeleteIpamRequest::ipamId)).setter(DeleteIpamRequest.setter(Builder::ipamId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamId").unmarshallLocationName("IpamId").build()}).build();
    private static final SdkField<Boolean> CASCADE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Cascade").getter(DeleteIpamRequest.getter(DeleteIpamRequest::cascade)).setter(DeleteIpamRequest.setter(Builder::cascade)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cascade").unmarshallLocationName("Cascade").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPAM_ID_FIELD, CASCADE_FIELD));
    private final String ipamId;
    private final Boolean cascade;

    private DeleteIpamRequest(BuilderImpl builder) {
        super(builder);
        this.ipamId = builder.ipamId;
        this.cascade = builder.cascade;
    }

    public final String ipamId() {
        return this.ipamId;
    }

    public final Boolean cascade() {
        return this.cascade;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cascade());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteIpamRequest)) {
            return false;
        }
        DeleteIpamRequest other = (DeleteIpamRequest)((Object)obj);
        return Objects.equals(this.ipamId(), other.ipamId()) && Objects.equals(this.cascade(), other.cascade());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteIpamRequest").add("IpamId", (Object)this.ipamId()).add("Cascade", (Object)this.cascade()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IpamId": {
                return Optional.ofNullable(clazz.cast(this.ipamId()));
            }
            case "Cascade": {
                return Optional.ofNullable(clazz.cast(this.cascade()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteIpamRequest, T> g) {
        return obj -> g.apply((DeleteIpamRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String ipamId;
        private Boolean cascade;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteIpamRequest model) {
            super(model);
            this.ipamId(model.ipamId);
            this.cascade(model.cascade);
        }

        public final String getIpamId() {
            return this.ipamId;
        }

        public final void setIpamId(String ipamId) {
            this.ipamId = ipamId;
        }

        @Override
        public final Builder ipamId(String ipamId) {
            this.ipamId = ipamId;
            return this;
        }

        public final Boolean getCascade() {
            return this.cascade;
        }

        public final void setCascade(Boolean cascade) {
            this.cascade = cascade;
        }

        @Override
        public final Builder cascade(Boolean cascade) {
            this.cascade = cascade;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteIpamRequest build() {
            return new DeleteIpamRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteIpamRequest> {
        public Builder ipamId(String var1);

        public Builder cascade(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

