/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.IKEVersionsListCopier;
import software.amazon.awssdk.services.ec2.model.IKEVersionsListValue;
import software.amazon.awssdk.services.ec2.model.Phase1DHGroupNumbersListCopier;
import software.amazon.awssdk.services.ec2.model.Phase1DHGroupNumbersListValue;
import software.amazon.awssdk.services.ec2.model.Phase1EncryptionAlgorithmsListCopier;
import software.amazon.awssdk.services.ec2.model.Phase1EncryptionAlgorithmsListValue;
import software.amazon.awssdk.services.ec2.model.Phase1IntegrityAlgorithmsListCopier;
import software.amazon.awssdk.services.ec2.model.Phase1IntegrityAlgorithmsListValue;
import software.amazon.awssdk.services.ec2.model.Phase2DHGroupNumbersListCopier;
import software.amazon.awssdk.services.ec2.model.Phase2DHGroupNumbersListValue;
import software.amazon.awssdk.services.ec2.model.Phase2EncryptionAlgorithmsListCopier;
import software.amazon.awssdk.services.ec2.model.Phase2EncryptionAlgorithmsListValue;
import software.amazon.awssdk.services.ec2.model.Phase2IntegrityAlgorithmsListCopier;
import software.amazon.awssdk.services.ec2.model.Phase2IntegrityAlgorithmsListValue;
import software.amazon.awssdk.services.ec2.model.VpnTunnelLogOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TunnelOption
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TunnelOption> {
    private static final SdkField<String> OUTSIDE_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutsideIpAddress").getter(TunnelOption.getter(TunnelOption::outsideIpAddress)).setter(TunnelOption.setter(Builder::outsideIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutsideIpAddress").unmarshallLocationName("outsideIpAddress").build()}).build();
    private static final SdkField<String> TUNNEL_INSIDE_CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TunnelInsideCidr").getter(TunnelOption.getter(TunnelOption::tunnelInsideCidr)).setter(TunnelOption.setter(Builder::tunnelInsideCidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TunnelInsideCidr").unmarshallLocationName("tunnelInsideCidr").build()}).build();
    private static final SdkField<String> TUNNEL_INSIDE_IPV6_CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TunnelInsideIpv6Cidr").getter(TunnelOption.getter(TunnelOption::tunnelInsideIpv6Cidr)).setter(TunnelOption.setter(Builder::tunnelInsideIpv6Cidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TunnelInsideIpv6Cidr").unmarshallLocationName("tunnelInsideIpv6Cidr").build()}).build();
    private static final SdkField<String> PRE_SHARED_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreSharedKey").getter(TunnelOption.getter(TunnelOption::preSharedKey)).setter(TunnelOption.setter(Builder::preSharedKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreSharedKey").unmarshallLocationName("preSharedKey").build()}).build();
    private static final SdkField<Integer> PHASE1_LIFETIME_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Phase1LifetimeSeconds").getter(TunnelOption.getter(TunnelOption::phase1LifetimeSeconds)).setter(TunnelOption.setter(Builder::phase1LifetimeSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase1LifetimeSeconds").unmarshallLocationName("phase1LifetimeSeconds").build()}).build();
    private static final SdkField<Integer> PHASE2_LIFETIME_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Phase2LifetimeSeconds").getter(TunnelOption.getter(TunnelOption::phase2LifetimeSeconds)).setter(TunnelOption.setter(Builder::phase2LifetimeSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase2LifetimeSeconds").unmarshallLocationName("phase2LifetimeSeconds").build()}).build();
    private static final SdkField<Integer> REKEY_MARGIN_TIME_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RekeyMarginTimeSeconds").getter(TunnelOption.getter(TunnelOption::rekeyMarginTimeSeconds)).setter(TunnelOption.setter(Builder::rekeyMarginTimeSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RekeyMarginTimeSeconds").unmarshallLocationName("rekeyMarginTimeSeconds").build()}).build();
    private static final SdkField<Integer> REKEY_FUZZ_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RekeyFuzzPercentage").getter(TunnelOption.getter(TunnelOption::rekeyFuzzPercentage)).setter(TunnelOption.setter(Builder::rekeyFuzzPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RekeyFuzzPercentage").unmarshallLocationName("rekeyFuzzPercentage").build()}).build();
    private static final SdkField<Integer> REPLAY_WINDOW_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ReplayWindowSize").getter(TunnelOption.getter(TunnelOption::replayWindowSize)).setter(TunnelOption.setter(Builder::replayWindowSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplayWindowSize").unmarshallLocationName("replayWindowSize").build()}).build();
    private static final SdkField<Integer> DPD_TIMEOUT_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DpdTimeoutSeconds").getter(TunnelOption.getter(TunnelOption::dpdTimeoutSeconds)).setter(TunnelOption.setter(Builder::dpdTimeoutSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DpdTimeoutSeconds").unmarshallLocationName("dpdTimeoutSeconds").build()}).build();
    private static final SdkField<String> DPD_TIMEOUT_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DpdTimeoutAction").getter(TunnelOption.getter(TunnelOption::dpdTimeoutAction)).setter(TunnelOption.setter(Builder::dpdTimeoutAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DpdTimeoutAction").unmarshallLocationName("dpdTimeoutAction").build()}).build();
    private static final SdkField<List<Phase1EncryptionAlgorithmsListValue>> PHASE1_ENCRYPTION_ALGORITHMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Phase1EncryptionAlgorithms").getter(TunnelOption.getter(TunnelOption::phase1EncryptionAlgorithms)).setter(TunnelOption.setter(Builder::phase1EncryptionAlgorithms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase1EncryptionAlgorithmSet").unmarshallLocationName("phase1EncryptionAlgorithmSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Phase1EncryptionAlgorithmsListValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<Phase2EncryptionAlgorithmsListValue>> PHASE2_ENCRYPTION_ALGORITHMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Phase2EncryptionAlgorithms").getter(TunnelOption.getter(TunnelOption::phase2EncryptionAlgorithms)).setter(TunnelOption.setter(Builder::phase2EncryptionAlgorithms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase2EncryptionAlgorithmSet").unmarshallLocationName("phase2EncryptionAlgorithmSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Phase2EncryptionAlgorithmsListValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<Phase1IntegrityAlgorithmsListValue>> PHASE1_INTEGRITY_ALGORITHMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Phase1IntegrityAlgorithms").getter(TunnelOption.getter(TunnelOption::phase1IntegrityAlgorithms)).setter(TunnelOption.setter(Builder::phase1IntegrityAlgorithms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase1IntegrityAlgorithmSet").unmarshallLocationName("phase1IntegrityAlgorithmSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Phase1IntegrityAlgorithmsListValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<Phase2IntegrityAlgorithmsListValue>> PHASE2_INTEGRITY_ALGORITHMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Phase2IntegrityAlgorithms").getter(TunnelOption.getter(TunnelOption::phase2IntegrityAlgorithms)).setter(TunnelOption.setter(Builder::phase2IntegrityAlgorithms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase2IntegrityAlgorithmSet").unmarshallLocationName("phase2IntegrityAlgorithmSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Phase2IntegrityAlgorithmsListValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<Phase1DHGroupNumbersListValue>> PHASE1_DH_GROUP_NUMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Phase1DHGroupNumbers").getter(TunnelOption.getter(TunnelOption::phase1DHGroupNumbers)).setter(TunnelOption.setter(Builder::phase1DHGroupNumbers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase1DHGroupNumberSet").unmarshallLocationName("phase1DHGroupNumberSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Phase1DHGroupNumbersListValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<Phase2DHGroupNumbersListValue>> PHASE2_DH_GROUP_NUMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Phase2DHGroupNumbers").getter(TunnelOption.getter(TunnelOption::phase2DHGroupNumbers)).setter(TunnelOption.setter(Builder::phase2DHGroupNumbers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase2DHGroupNumberSet").unmarshallLocationName("phase2DHGroupNumberSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Phase2DHGroupNumbersListValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<IKEVersionsListValue>> IKE_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IkeVersions").getter(TunnelOption.getter(TunnelOption::ikeVersions)).setter(TunnelOption.setter(Builder::ikeVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IkeVersionSet").unmarshallLocationName("ikeVersionSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IKEVersionsListValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> STARTUP_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartupAction").getter(TunnelOption.getter(TunnelOption::startupAction)).setter(TunnelOption.setter(Builder::startupAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartupAction").unmarshallLocationName("startupAction").build()}).build();
    private static final SdkField<VpnTunnelLogOptions> LOG_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LogOptions").getter(TunnelOption.getter(TunnelOption::logOptions)).setter(TunnelOption.setter(Builder::logOptions)).constructor(VpnTunnelLogOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogOptions").unmarshallLocationName("logOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTSIDE_IP_ADDRESS_FIELD, TUNNEL_INSIDE_CIDR_FIELD, TUNNEL_INSIDE_IPV6_CIDR_FIELD, PRE_SHARED_KEY_FIELD, PHASE1_LIFETIME_SECONDS_FIELD, PHASE2_LIFETIME_SECONDS_FIELD, REKEY_MARGIN_TIME_SECONDS_FIELD, REKEY_FUZZ_PERCENTAGE_FIELD, REPLAY_WINDOW_SIZE_FIELD, DPD_TIMEOUT_SECONDS_FIELD, DPD_TIMEOUT_ACTION_FIELD, PHASE1_ENCRYPTION_ALGORITHMS_FIELD, PHASE2_ENCRYPTION_ALGORITHMS_FIELD, PHASE1_INTEGRITY_ALGORITHMS_FIELD, PHASE2_INTEGRITY_ALGORITHMS_FIELD, PHASE1_DH_GROUP_NUMBERS_FIELD, PHASE2_DH_GROUP_NUMBERS_FIELD, IKE_VERSIONS_FIELD, STARTUP_ACTION_FIELD, LOG_OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String outsideIpAddress;
    private final String tunnelInsideCidr;
    private final String tunnelInsideIpv6Cidr;
    private final String preSharedKey;
    private final Integer phase1LifetimeSeconds;
    private final Integer phase2LifetimeSeconds;
    private final Integer rekeyMarginTimeSeconds;
    private final Integer rekeyFuzzPercentage;
    private final Integer replayWindowSize;
    private final Integer dpdTimeoutSeconds;
    private final String dpdTimeoutAction;
    private final List<Phase1EncryptionAlgorithmsListValue> phase1EncryptionAlgorithms;
    private final List<Phase2EncryptionAlgorithmsListValue> phase2EncryptionAlgorithms;
    private final List<Phase1IntegrityAlgorithmsListValue> phase1IntegrityAlgorithms;
    private final List<Phase2IntegrityAlgorithmsListValue> phase2IntegrityAlgorithms;
    private final List<Phase1DHGroupNumbersListValue> phase1DHGroupNumbers;
    private final List<Phase2DHGroupNumbersListValue> phase2DHGroupNumbers;
    private final List<IKEVersionsListValue> ikeVersions;
    private final String startupAction;
    private final VpnTunnelLogOptions logOptions;

    private TunnelOption(BuilderImpl builder) {
        this.outsideIpAddress = builder.outsideIpAddress;
        this.tunnelInsideCidr = builder.tunnelInsideCidr;
        this.tunnelInsideIpv6Cidr = builder.tunnelInsideIpv6Cidr;
        this.preSharedKey = builder.preSharedKey;
        this.phase1LifetimeSeconds = builder.phase1LifetimeSeconds;
        this.phase2LifetimeSeconds = builder.phase2LifetimeSeconds;
        this.rekeyMarginTimeSeconds = builder.rekeyMarginTimeSeconds;
        this.rekeyFuzzPercentage = builder.rekeyFuzzPercentage;
        this.replayWindowSize = builder.replayWindowSize;
        this.dpdTimeoutSeconds = builder.dpdTimeoutSeconds;
        this.dpdTimeoutAction = builder.dpdTimeoutAction;
        this.phase1EncryptionAlgorithms = builder.phase1EncryptionAlgorithms;
        this.phase2EncryptionAlgorithms = builder.phase2EncryptionAlgorithms;
        this.phase1IntegrityAlgorithms = builder.phase1IntegrityAlgorithms;
        this.phase2IntegrityAlgorithms = builder.phase2IntegrityAlgorithms;
        this.phase1DHGroupNumbers = builder.phase1DHGroupNumbers;
        this.phase2DHGroupNumbers = builder.phase2DHGroupNumbers;
        this.ikeVersions = builder.ikeVersions;
        this.startupAction = builder.startupAction;
        this.logOptions = builder.logOptions;
    }

    public final String outsideIpAddress() {
        return this.outsideIpAddress;
    }

    public final String tunnelInsideCidr() {
        return this.tunnelInsideCidr;
    }

    public final String tunnelInsideIpv6Cidr() {
        return this.tunnelInsideIpv6Cidr;
    }

    public final String preSharedKey() {
        return this.preSharedKey;
    }

    public final Integer phase1LifetimeSeconds() {
        return this.phase1LifetimeSeconds;
    }

    public final Integer phase2LifetimeSeconds() {
        return this.phase2LifetimeSeconds;
    }

    public final Integer rekeyMarginTimeSeconds() {
        return this.rekeyMarginTimeSeconds;
    }

    public final Integer rekeyFuzzPercentage() {
        return this.rekeyFuzzPercentage;
    }

    public final Integer replayWindowSize() {
        return this.replayWindowSize;
    }

    public final Integer dpdTimeoutSeconds() {
        return this.dpdTimeoutSeconds;
    }

    public final String dpdTimeoutAction() {
        return this.dpdTimeoutAction;
    }

    public final boolean hasPhase1EncryptionAlgorithms() {
        return this.phase1EncryptionAlgorithms != null && !(this.phase1EncryptionAlgorithms instanceof SdkAutoConstructList);
    }

    public final List<Phase1EncryptionAlgorithmsListValue> phase1EncryptionAlgorithms() {
        return this.phase1EncryptionAlgorithms;
    }

    public final boolean hasPhase2EncryptionAlgorithms() {
        return this.phase2EncryptionAlgorithms != null && !(this.phase2EncryptionAlgorithms instanceof SdkAutoConstructList);
    }

    public final List<Phase2EncryptionAlgorithmsListValue> phase2EncryptionAlgorithms() {
        return this.phase2EncryptionAlgorithms;
    }

    public final boolean hasPhase1IntegrityAlgorithms() {
        return this.phase1IntegrityAlgorithms != null && !(this.phase1IntegrityAlgorithms instanceof SdkAutoConstructList);
    }

    public final List<Phase1IntegrityAlgorithmsListValue> phase1IntegrityAlgorithms() {
        return this.phase1IntegrityAlgorithms;
    }

    public final boolean hasPhase2IntegrityAlgorithms() {
        return this.phase2IntegrityAlgorithms != null && !(this.phase2IntegrityAlgorithms instanceof SdkAutoConstructList);
    }

    public final List<Phase2IntegrityAlgorithmsListValue> phase2IntegrityAlgorithms() {
        return this.phase2IntegrityAlgorithms;
    }

    public final boolean hasPhase1DHGroupNumbers() {
        return this.phase1DHGroupNumbers != null && !(this.phase1DHGroupNumbers instanceof SdkAutoConstructList);
    }

    public final List<Phase1DHGroupNumbersListValue> phase1DHGroupNumbers() {
        return this.phase1DHGroupNumbers;
    }

    public final boolean hasPhase2DHGroupNumbers() {
        return this.phase2DHGroupNumbers != null && !(this.phase2DHGroupNumbers instanceof SdkAutoConstructList);
    }

    public final List<Phase2DHGroupNumbersListValue> phase2DHGroupNumbers() {
        return this.phase2DHGroupNumbers;
    }

    public final boolean hasIkeVersions() {
        return this.ikeVersions != null && !(this.ikeVersions instanceof SdkAutoConstructList);
    }

    public final List<IKEVersionsListValue> ikeVersions() {
        return this.ikeVersions;
    }

    public final String startupAction() {
        return this.startupAction;
    }

    public final VpnTunnelLogOptions logOptions() {
        return this.logOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.outsideIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.tunnelInsideCidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.tunnelInsideIpv6Cidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.preSharedKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.phase1LifetimeSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.phase2LifetimeSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.rekeyMarginTimeSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.rekeyFuzzPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.replayWindowSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.dpdTimeoutSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.dpdTimeoutAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPhase1EncryptionAlgorithms() ? this.phase1EncryptionAlgorithms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPhase2EncryptionAlgorithms() ? this.phase2EncryptionAlgorithms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPhase1IntegrityAlgorithms() ? this.phase1IntegrityAlgorithms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPhase2IntegrityAlgorithms() ? this.phase2IntegrityAlgorithms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPhase1DHGroupNumbers() ? this.phase1DHGroupNumbers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPhase2DHGroupNumbers() ? this.phase2DHGroupNumbers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIkeVersions() ? this.ikeVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startupAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.logOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TunnelOption)) {
            return false;
        }
        TunnelOption other = (TunnelOption)obj;
        return Objects.equals(this.outsideIpAddress(), other.outsideIpAddress()) && Objects.equals(this.tunnelInsideCidr(), other.tunnelInsideCidr()) && Objects.equals(this.tunnelInsideIpv6Cidr(), other.tunnelInsideIpv6Cidr()) && Objects.equals(this.preSharedKey(), other.preSharedKey()) && Objects.equals(this.phase1LifetimeSeconds(), other.phase1LifetimeSeconds()) && Objects.equals(this.phase2LifetimeSeconds(), other.phase2LifetimeSeconds()) && Objects.equals(this.rekeyMarginTimeSeconds(), other.rekeyMarginTimeSeconds()) && Objects.equals(this.rekeyFuzzPercentage(), other.rekeyFuzzPercentage()) && Objects.equals(this.replayWindowSize(), other.replayWindowSize()) && Objects.equals(this.dpdTimeoutSeconds(), other.dpdTimeoutSeconds()) && Objects.equals(this.dpdTimeoutAction(), other.dpdTimeoutAction()) && this.hasPhase1EncryptionAlgorithms() == other.hasPhase1EncryptionAlgorithms() && Objects.equals(this.phase1EncryptionAlgorithms(), other.phase1EncryptionAlgorithms()) && this.hasPhase2EncryptionAlgorithms() == other.hasPhase2EncryptionAlgorithms() && Objects.equals(this.phase2EncryptionAlgorithms(), other.phase2EncryptionAlgorithms()) && this.hasPhase1IntegrityAlgorithms() == other.hasPhase1IntegrityAlgorithms() && Objects.equals(this.phase1IntegrityAlgorithms(), other.phase1IntegrityAlgorithms()) && this.hasPhase2IntegrityAlgorithms() == other.hasPhase2IntegrityAlgorithms() && Objects.equals(this.phase2IntegrityAlgorithms(), other.phase2IntegrityAlgorithms()) && this.hasPhase1DHGroupNumbers() == other.hasPhase1DHGroupNumbers() && Objects.equals(this.phase1DHGroupNumbers(), other.phase1DHGroupNumbers()) && this.hasPhase2DHGroupNumbers() == other.hasPhase2DHGroupNumbers() && Objects.equals(this.phase2DHGroupNumbers(), other.phase2DHGroupNumbers()) && this.hasIkeVersions() == other.hasIkeVersions() && Objects.equals(this.ikeVersions(), other.ikeVersions()) && Objects.equals(this.startupAction(), other.startupAction()) && Objects.equals(this.logOptions(), other.logOptions());
    }

    public final String toString() {
        return ToString.builder((String)"TunnelOption").add("OutsideIpAddress", (Object)this.outsideIpAddress()).add("TunnelInsideCidr", (Object)this.tunnelInsideCidr()).add("TunnelInsideIpv6Cidr", (Object)this.tunnelInsideIpv6Cidr()).add("PreSharedKey", (Object)this.preSharedKey()).add("Phase1LifetimeSeconds", (Object)this.phase1LifetimeSeconds()).add("Phase2LifetimeSeconds", (Object)this.phase2LifetimeSeconds()).add("RekeyMarginTimeSeconds", (Object)this.rekeyMarginTimeSeconds()).add("RekeyFuzzPercentage", (Object)this.rekeyFuzzPercentage()).add("ReplayWindowSize", (Object)this.replayWindowSize()).add("DpdTimeoutSeconds", (Object)this.dpdTimeoutSeconds()).add("DpdTimeoutAction", (Object)this.dpdTimeoutAction()).add("Phase1EncryptionAlgorithms", this.hasPhase1EncryptionAlgorithms() ? this.phase1EncryptionAlgorithms() : null).add("Phase2EncryptionAlgorithms", this.hasPhase2EncryptionAlgorithms() ? this.phase2EncryptionAlgorithms() : null).add("Phase1IntegrityAlgorithms", this.hasPhase1IntegrityAlgorithms() ? this.phase1IntegrityAlgorithms() : null).add("Phase2IntegrityAlgorithms", this.hasPhase2IntegrityAlgorithms() ? this.phase2IntegrityAlgorithms() : null).add("Phase1DHGroupNumbers", this.hasPhase1DHGroupNumbers() ? this.phase1DHGroupNumbers() : null).add("Phase2DHGroupNumbers", this.hasPhase2DHGroupNumbers() ? this.phase2DHGroupNumbers() : null).add("IkeVersions", this.hasIkeVersions() ? this.ikeVersions() : null).add("StartupAction", (Object)this.startupAction()).add("LogOptions", (Object)this.logOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OutsideIpAddress": {
                return Optional.ofNullable(clazz.cast(this.outsideIpAddress()));
            }
            case "TunnelInsideCidr": {
                return Optional.ofNullable(clazz.cast(this.tunnelInsideCidr()));
            }
            case "TunnelInsideIpv6Cidr": {
                return Optional.ofNullable(clazz.cast(this.tunnelInsideIpv6Cidr()));
            }
            case "PreSharedKey": {
                return Optional.ofNullable(clazz.cast(this.preSharedKey()));
            }
            case "Phase1LifetimeSeconds": {
                return Optional.ofNullable(clazz.cast(this.phase1LifetimeSeconds()));
            }
            case "Phase2LifetimeSeconds": {
                return Optional.ofNullable(clazz.cast(this.phase2LifetimeSeconds()));
            }
            case "RekeyMarginTimeSeconds": {
                return Optional.ofNullable(clazz.cast(this.rekeyMarginTimeSeconds()));
            }
            case "RekeyFuzzPercentage": {
                return Optional.ofNullable(clazz.cast(this.rekeyFuzzPercentage()));
            }
            case "ReplayWindowSize": {
                return Optional.ofNullable(clazz.cast(this.replayWindowSize()));
            }
            case "DpdTimeoutSeconds": {
                return Optional.ofNullable(clazz.cast(this.dpdTimeoutSeconds()));
            }
            case "DpdTimeoutAction": {
                return Optional.ofNullable(clazz.cast(this.dpdTimeoutAction()));
            }
            case "Phase1EncryptionAlgorithms": {
                return Optional.ofNullable(clazz.cast(this.phase1EncryptionAlgorithms()));
            }
            case "Phase2EncryptionAlgorithms": {
                return Optional.ofNullable(clazz.cast(this.phase2EncryptionAlgorithms()));
            }
            case "Phase1IntegrityAlgorithms": {
                return Optional.ofNullable(clazz.cast(this.phase1IntegrityAlgorithms()));
            }
            case "Phase2IntegrityAlgorithms": {
                return Optional.ofNullable(clazz.cast(this.phase2IntegrityAlgorithms()));
            }
            case "Phase1DHGroupNumbers": {
                return Optional.ofNullable(clazz.cast(this.phase1DHGroupNumbers()));
            }
            case "Phase2DHGroupNumbers": {
                return Optional.ofNullable(clazz.cast(this.phase2DHGroupNumbers()));
            }
            case "IkeVersions": {
                return Optional.ofNullable(clazz.cast(this.ikeVersions()));
            }
            case "StartupAction": {
                return Optional.ofNullable(clazz.cast(this.startupAction()));
            }
            case "LogOptions": {
                return Optional.ofNullable(clazz.cast(this.logOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TunnelOption, T> g) {
        return obj -> g.apply((TunnelOption)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String outsideIpAddress;
        private String tunnelInsideCidr;
        private String tunnelInsideIpv6Cidr;
        private String preSharedKey;
        private Integer phase1LifetimeSeconds;
        private Integer phase2LifetimeSeconds;
        private Integer rekeyMarginTimeSeconds;
        private Integer rekeyFuzzPercentage;
        private Integer replayWindowSize;
        private Integer dpdTimeoutSeconds;
        private String dpdTimeoutAction;
        private List<Phase1EncryptionAlgorithmsListValue> phase1EncryptionAlgorithms = DefaultSdkAutoConstructList.getInstance();
        private List<Phase2EncryptionAlgorithmsListValue> phase2EncryptionAlgorithms = DefaultSdkAutoConstructList.getInstance();
        private List<Phase1IntegrityAlgorithmsListValue> phase1IntegrityAlgorithms = DefaultSdkAutoConstructList.getInstance();
        private List<Phase2IntegrityAlgorithmsListValue> phase2IntegrityAlgorithms = DefaultSdkAutoConstructList.getInstance();
        private List<Phase1DHGroupNumbersListValue> phase1DHGroupNumbers = DefaultSdkAutoConstructList.getInstance();
        private List<Phase2DHGroupNumbersListValue> phase2DHGroupNumbers = DefaultSdkAutoConstructList.getInstance();
        private List<IKEVersionsListValue> ikeVersions = DefaultSdkAutoConstructList.getInstance();
        private String startupAction;
        private VpnTunnelLogOptions logOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(TunnelOption model) {
            this.outsideIpAddress(model.outsideIpAddress);
            this.tunnelInsideCidr(model.tunnelInsideCidr);
            this.tunnelInsideIpv6Cidr(model.tunnelInsideIpv6Cidr);
            this.preSharedKey(model.preSharedKey);
            this.phase1LifetimeSeconds(model.phase1LifetimeSeconds);
            this.phase2LifetimeSeconds(model.phase2LifetimeSeconds);
            this.rekeyMarginTimeSeconds(model.rekeyMarginTimeSeconds);
            this.rekeyFuzzPercentage(model.rekeyFuzzPercentage);
            this.replayWindowSize(model.replayWindowSize);
            this.dpdTimeoutSeconds(model.dpdTimeoutSeconds);
            this.dpdTimeoutAction(model.dpdTimeoutAction);
            this.phase1EncryptionAlgorithms(model.phase1EncryptionAlgorithms);
            this.phase2EncryptionAlgorithms(model.phase2EncryptionAlgorithms);
            this.phase1IntegrityAlgorithms(model.phase1IntegrityAlgorithms);
            this.phase2IntegrityAlgorithms(model.phase2IntegrityAlgorithms);
            this.phase1DHGroupNumbers(model.phase1DHGroupNumbers);
            this.phase2DHGroupNumbers(model.phase2DHGroupNumbers);
            this.ikeVersions(model.ikeVersions);
            this.startupAction(model.startupAction);
            this.logOptions(model.logOptions);
        }

        public final String getOutsideIpAddress() {
            return this.outsideIpAddress;
        }

        public final void setOutsideIpAddress(String outsideIpAddress) {
            this.outsideIpAddress = outsideIpAddress;
        }

        @Override
        public final Builder outsideIpAddress(String outsideIpAddress) {
            this.outsideIpAddress = outsideIpAddress;
            return this;
        }

        public final String getTunnelInsideCidr() {
            return this.tunnelInsideCidr;
        }

        public final void setTunnelInsideCidr(String tunnelInsideCidr) {
            this.tunnelInsideCidr = tunnelInsideCidr;
        }

        @Override
        public final Builder tunnelInsideCidr(String tunnelInsideCidr) {
            this.tunnelInsideCidr = tunnelInsideCidr;
            return this;
        }

        public final String getTunnelInsideIpv6Cidr() {
            return this.tunnelInsideIpv6Cidr;
        }

        public final void setTunnelInsideIpv6Cidr(String tunnelInsideIpv6Cidr) {
            this.tunnelInsideIpv6Cidr = tunnelInsideIpv6Cidr;
        }

        @Override
        public final Builder tunnelInsideIpv6Cidr(String tunnelInsideIpv6Cidr) {
            this.tunnelInsideIpv6Cidr = tunnelInsideIpv6Cidr;
            return this;
        }

        public final String getPreSharedKey() {
            return this.preSharedKey;
        }

        public final void setPreSharedKey(String preSharedKey) {
            this.preSharedKey = preSharedKey;
        }

        @Override
        public final Builder preSharedKey(String preSharedKey) {
            this.preSharedKey = preSharedKey;
            return this;
        }

        public final Integer getPhase1LifetimeSeconds() {
            return this.phase1LifetimeSeconds;
        }

        public final void setPhase1LifetimeSeconds(Integer phase1LifetimeSeconds) {
            this.phase1LifetimeSeconds = phase1LifetimeSeconds;
        }

        @Override
        public final Builder phase1LifetimeSeconds(Integer phase1LifetimeSeconds) {
            this.phase1LifetimeSeconds = phase1LifetimeSeconds;
            return this;
        }

        public final Integer getPhase2LifetimeSeconds() {
            return this.phase2LifetimeSeconds;
        }

        public final void setPhase2LifetimeSeconds(Integer phase2LifetimeSeconds) {
            this.phase2LifetimeSeconds = phase2LifetimeSeconds;
        }

        @Override
        public final Builder phase2LifetimeSeconds(Integer phase2LifetimeSeconds) {
            this.phase2LifetimeSeconds = phase2LifetimeSeconds;
            return this;
        }

        public final Integer getRekeyMarginTimeSeconds() {
            return this.rekeyMarginTimeSeconds;
        }

        public final void setRekeyMarginTimeSeconds(Integer rekeyMarginTimeSeconds) {
            this.rekeyMarginTimeSeconds = rekeyMarginTimeSeconds;
        }

        @Override
        public final Builder rekeyMarginTimeSeconds(Integer rekeyMarginTimeSeconds) {
            this.rekeyMarginTimeSeconds = rekeyMarginTimeSeconds;
            return this;
        }

        public final Integer getRekeyFuzzPercentage() {
            return this.rekeyFuzzPercentage;
        }

        public final void setRekeyFuzzPercentage(Integer rekeyFuzzPercentage) {
            this.rekeyFuzzPercentage = rekeyFuzzPercentage;
        }

        @Override
        public final Builder rekeyFuzzPercentage(Integer rekeyFuzzPercentage) {
            this.rekeyFuzzPercentage = rekeyFuzzPercentage;
            return this;
        }

        public final Integer getReplayWindowSize() {
            return this.replayWindowSize;
        }

        public final void setReplayWindowSize(Integer replayWindowSize) {
            this.replayWindowSize = replayWindowSize;
        }

        @Override
        public final Builder replayWindowSize(Integer replayWindowSize) {
            this.replayWindowSize = replayWindowSize;
            return this;
        }

        public final Integer getDpdTimeoutSeconds() {
            return this.dpdTimeoutSeconds;
        }

        public final void setDpdTimeoutSeconds(Integer dpdTimeoutSeconds) {
            this.dpdTimeoutSeconds = dpdTimeoutSeconds;
        }

        @Override
        public final Builder dpdTimeoutSeconds(Integer dpdTimeoutSeconds) {
            this.dpdTimeoutSeconds = dpdTimeoutSeconds;
            return this;
        }

        public final String getDpdTimeoutAction() {
            return this.dpdTimeoutAction;
        }

        public final void setDpdTimeoutAction(String dpdTimeoutAction) {
            this.dpdTimeoutAction = dpdTimeoutAction;
        }

        @Override
        public final Builder dpdTimeoutAction(String dpdTimeoutAction) {
            this.dpdTimeoutAction = dpdTimeoutAction;
            return this;
        }

        public final List<Phase1EncryptionAlgorithmsListValue.Builder> getPhase1EncryptionAlgorithms() {
            List<Phase1EncryptionAlgorithmsListValue.Builder> result = Phase1EncryptionAlgorithmsListCopier.copyToBuilder(this.phase1EncryptionAlgorithms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPhase1EncryptionAlgorithms(Collection<Phase1EncryptionAlgorithmsListValue.BuilderImpl> phase1EncryptionAlgorithms) {
            this.phase1EncryptionAlgorithms = Phase1EncryptionAlgorithmsListCopier.copyFromBuilder(phase1EncryptionAlgorithms);
        }

        @Override
        public final Builder phase1EncryptionAlgorithms(Collection<Phase1EncryptionAlgorithmsListValue> phase1EncryptionAlgorithms) {
            this.phase1EncryptionAlgorithms = Phase1EncryptionAlgorithmsListCopier.copy(phase1EncryptionAlgorithms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase1EncryptionAlgorithms(Phase1EncryptionAlgorithmsListValue ... phase1EncryptionAlgorithms) {
            this.phase1EncryptionAlgorithms(Arrays.asList(phase1EncryptionAlgorithms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase1EncryptionAlgorithms(Consumer<Phase1EncryptionAlgorithmsListValue.Builder> ... phase1EncryptionAlgorithms) {
            this.phase1EncryptionAlgorithms(Stream.of(phase1EncryptionAlgorithms).map(c -> (Phase1EncryptionAlgorithmsListValue)((Phase1EncryptionAlgorithmsListValue.Builder)Phase1EncryptionAlgorithmsListValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Phase2EncryptionAlgorithmsListValue.Builder> getPhase2EncryptionAlgorithms() {
            List<Phase2EncryptionAlgorithmsListValue.Builder> result = Phase2EncryptionAlgorithmsListCopier.copyToBuilder(this.phase2EncryptionAlgorithms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPhase2EncryptionAlgorithms(Collection<Phase2EncryptionAlgorithmsListValue.BuilderImpl> phase2EncryptionAlgorithms) {
            this.phase2EncryptionAlgorithms = Phase2EncryptionAlgorithmsListCopier.copyFromBuilder(phase2EncryptionAlgorithms);
        }

        @Override
        public final Builder phase2EncryptionAlgorithms(Collection<Phase2EncryptionAlgorithmsListValue> phase2EncryptionAlgorithms) {
            this.phase2EncryptionAlgorithms = Phase2EncryptionAlgorithmsListCopier.copy(phase2EncryptionAlgorithms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase2EncryptionAlgorithms(Phase2EncryptionAlgorithmsListValue ... phase2EncryptionAlgorithms) {
            this.phase2EncryptionAlgorithms(Arrays.asList(phase2EncryptionAlgorithms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase2EncryptionAlgorithms(Consumer<Phase2EncryptionAlgorithmsListValue.Builder> ... phase2EncryptionAlgorithms) {
            this.phase2EncryptionAlgorithms(Stream.of(phase2EncryptionAlgorithms).map(c -> (Phase2EncryptionAlgorithmsListValue)((Phase2EncryptionAlgorithmsListValue.Builder)Phase2EncryptionAlgorithmsListValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Phase1IntegrityAlgorithmsListValue.Builder> getPhase1IntegrityAlgorithms() {
            List<Phase1IntegrityAlgorithmsListValue.Builder> result = Phase1IntegrityAlgorithmsListCopier.copyToBuilder(this.phase1IntegrityAlgorithms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPhase1IntegrityAlgorithms(Collection<Phase1IntegrityAlgorithmsListValue.BuilderImpl> phase1IntegrityAlgorithms) {
            this.phase1IntegrityAlgorithms = Phase1IntegrityAlgorithmsListCopier.copyFromBuilder(phase1IntegrityAlgorithms);
        }

        @Override
        public final Builder phase1IntegrityAlgorithms(Collection<Phase1IntegrityAlgorithmsListValue> phase1IntegrityAlgorithms) {
            this.phase1IntegrityAlgorithms = Phase1IntegrityAlgorithmsListCopier.copy(phase1IntegrityAlgorithms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase1IntegrityAlgorithms(Phase1IntegrityAlgorithmsListValue ... phase1IntegrityAlgorithms) {
            this.phase1IntegrityAlgorithms(Arrays.asList(phase1IntegrityAlgorithms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase1IntegrityAlgorithms(Consumer<Phase1IntegrityAlgorithmsListValue.Builder> ... phase1IntegrityAlgorithms) {
            this.phase1IntegrityAlgorithms(Stream.of(phase1IntegrityAlgorithms).map(c -> (Phase1IntegrityAlgorithmsListValue)((Phase1IntegrityAlgorithmsListValue.Builder)Phase1IntegrityAlgorithmsListValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Phase2IntegrityAlgorithmsListValue.Builder> getPhase2IntegrityAlgorithms() {
            List<Phase2IntegrityAlgorithmsListValue.Builder> result = Phase2IntegrityAlgorithmsListCopier.copyToBuilder(this.phase2IntegrityAlgorithms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPhase2IntegrityAlgorithms(Collection<Phase2IntegrityAlgorithmsListValue.BuilderImpl> phase2IntegrityAlgorithms) {
            this.phase2IntegrityAlgorithms = Phase2IntegrityAlgorithmsListCopier.copyFromBuilder(phase2IntegrityAlgorithms);
        }

        @Override
        public final Builder phase2IntegrityAlgorithms(Collection<Phase2IntegrityAlgorithmsListValue> phase2IntegrityAlgorithms) {
            this.phase2IntegrityAlgorithms = Phase2IntegrityAlgorithmsListCopier.copy(phase2IntegrityAlgorithms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase2IntegrityAlgorithms(Phase2IntegrityAlgorithmsListValue ... phase2IntegrityAlgorithms) {
            this.phase2IntegrityAlgorithms(Arrays.asList(phase2IntegrityAlgorithms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase2IntegrityAlgorithms(Consumer<Phase2IntegrityAlgorithmsListValue.Builder> ... phase2IntegrityAlgorithms) {
            this.phase2IntegrityAlgorithms(Stream.of(phase2IntegrityAlgorithms).map(c -> (Phase2IntegrityAlgorithmsListValue)((Phase2IntegrityAlgorithmsListValue.Builder)Phase2IntegrityAlgorithmsListValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Phase1DHGroupNumbersListValue.Builder> getPhase1DHGroupNumbers() {
            List<Phase1DHGroupNumbersListValue.Builder> result = Phase1DHGroupNumbersListCopier.copyToBuilder(this.phase1DHGroupNumbers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPhase1DHGroupNumbers(Collection<Phase1DHGroupNumbersListValue.BuilderImpl> phase1DHGroupNumbers) {
            this.phase1DHGroupNumbers = Phase1DHGroupNumbersListCopier.copyFromBuilder(phase1DHGroupNumbers);
        }

        @Override
        public final Builder phase1DHGroupNumbers(Collection<Phase1DHGroupNumbersListValue> phase1DHGroupNumbers) {
            this.phase1DHGroupNumbers = Phase1DHGroupNumbersListCopier.copy(phase1DHGroupNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase1DHGroupNumbers(Phase1DHGroupNumbersListValue ... phase1DHGroupNumbers) {
            this.phase1DHGroupNumbers(Arrays.asList(phase1DHGroupNumbers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase1DHGroupNumbers(Consumer<Phase1DHGroupNumbersListValue.Builder> ... phase1DHGroupNumbers) {
            this.phase1DHGroupNumbers(Stream.of(phase1DHGroupNumbers).map(c -> (Phase1DHGroupNumbersListValue)((Phase1DHGroupNumbersListValue.Builder)Phase1DHGroupNumbersListValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Phase2DHGroupNumbersListValue.Builder> getPhase2DHGroupNumbers() {
            List<Phase2DHGroupNumbersListValue.Builder> result = Phase2DHGroupNumbersListCopier.copyToBuilder(this.phase2DHGroupNumbers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPhase2DHGroupNumbers(Collection<Phase2DHGroupNumbersListValue.BuilderImpl> phase2DHGroupNumbers) {
            this.phase2DHGroupNumbers = Phase2DHGroupNumbersListCopier.copyFromBuilder(phase2DHGroupNumbers);
        }

        @Override
        public final Builder phase2DHGroupNumbers(Collection<Phase2DHGroupNumbersListValue> phase2DHGroupNumbers) {
            this.phase2DHGroupNumbers = Phase2DHGroupNumbersListCopier.copy(phase2DHGroupNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase2DHGroupNumbers(Phase2DHGroupNumbersListValue ... phase2DHGroupNumbers) {
            this.phase2DHGroupNumbers(Arrays.asList(phase2DHGroupNumbers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phase2DHGroupNumbers(Consumer<Phase2DHGroupNumbersListValue.Builder> ... phase2DHGroupNumbers) {
            this.phase2DHGroupNumbers(Stream.of(phase2DHGroupNumbers).map(c -> (Phase2DHGroupNumbersListValue)((Phase2DHGroupNumbersListValue.Builder)Phase2DHGroupNumbersListValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<IKEVersionsListValue.Builder> getIkeVersions() {
            List<IKEVersionsListValue.Builder> result = IKEVersionsListCopier.copyToBuilder(this.ikeVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIkeVersions(Collection<IKEVersionsListValue.BuilderImpl> ikeVersions) {
            this.ikeVersions = IKEVersionsListCopier.copyFromBuilder(ikeVersions);
        }

        @Override
        public final Builder ikeVersions(Collection<IKEVersionsListValue> ikeVersions) {
            this.ikeVersions = IKEVersionsListCopier.copy(ikeVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ikeVersions(IKEVersionsListValue ... ikeVersions) {
            this.ikeVersions(Arrays.asList(ikeVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ikeVersions(Consumer<IKEVersionsListValue.Builder> ... ikeVersions) {
            this.ikeVersions(Stream.of(ikeVersions).map(c -> (IKEVersionsListValue)((IKEVersionsListValue.Builder)IKEVersionsListValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStartupAction() {
            return this.startupAction;
        }

        public final void setStartupAction(String startupAction) {
            this.startupAction = startupAction;
        }

        @Override
        public final Builder startupAction(String startupAction) {
            this.startupAction = startupAction;
            return this;
        }

        public final VpnTunnelLogOptions.Builder getLogOptions() {
            return this.logOptions != null ? this.logOptions.toBuilder() : null;
        }

        public final void setLogOptions(VpnTunnelLogOptions.BuilderImpl logOptions) {
            this.logOptions = logOptions != null ? logOptions.build() : null;
        }

        @Override
        public final Builder logOptions(VpnTunnelLogOptions logOptions) {
            this.logOptions = logOptions;
            return this;
        }

        public TunnelOption build() {
            return new TunnelOption(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TunnelOption> {
        public Builder outsideIpAddress(String var1);

        public Builder tunnelInsideCidr(String var1);

        public Builder tunnelInsideIpv6Cidr(String var1);

        public Builder preSharedKey(String var1);

        public Builder phase1LifetimeSeconds(Integer var1);

        public Builder phase2LifetimeSeconds(Integer var1);

        public Builder rekeyMarginTimeSeconds(Integer var1);

        public Builder rekeyFuzzPercentage(Integer var1);

        public Builder replayWindowSize(Integer var1);

        public Builder dpdTimeoutSeconds(Integer var1);

        public Builder dpdTimeoutAction(String var1);

        public Builder phase1EncryptionAlgorithms(Collection<Phase1EncryptionAlgorithmsListValue> var1);

        public Builder phase1EncryptionAlgorithms(Phase1EncryptionAlgorithmsListValue ... var1);

        public Builder phase1EncryptionAlgorithms(Consumer<Phase1EncryptionAlgorithmsListValue.Builder> ... var1);

        public Builder phase2EncryptionAlgorithms(Collection<Phase2EncryptionAlgorithmsListValue> var1);

        public Builder phase2EncryptionAlgorithms(Phase2EncryptionAlgorithmsListValue ... var1);

        public Builder phase2EncryptionAlgorithms(Consumer<Phase2EncryptionAlgorithmsListValue.Builder> ... var1);

        public Builder phase1IntegrityAlgorithms(Collection<Phase1IntegrityAlgorithmsListValue> var1);

        public Builder phase1IntegrityAlgorithms(Phase1IntegrityAlgorithmsListValue ... var1);

        public Builder phase1IntegrityAlgorithms(Consumer<Phase1IntegrityAlgorithmsListValue.Builder> ... var1);

        public Builder phase2IntegrityAlgorithms(Collection<Phase2IntegrityAlgorithmsListValue> var1);

        public Builder phase2IntegrityAlgorithms(Phase2IntegrityAlgorithmsListValue ... var1);

        public Builder phase2IntegrityAlgorithms(Consumer<Phase2IntegrityAlgorithmsListValue.Builder> ... var1);

        public Builder phase1DHGroupNumbers(Collection<Phase1DHGroupNumbersListValue> var1);

        public Builder phase1DHGroupNumbers(Phase1DHGroupNumbersListValue ... var1);

        public Builder phase1DHGroupNumbers(Consumer<Phase1DHGroupNumbersListValue.Builder> ... var1);

        public Builder phase2DHGroupNumbers(Collection<Phase2DHGroupNumbersListValue> var1);

        public Builder phase2DHGroupNumbers(Phase2DHGroupNumbersListValue ... var1);

        public Builder phase2DHGroupNumbers(Consumer<Phase2DHGroupNumbersListValue.Builder> ... var1);

        public Builder ikeVersions(Collection<IKEVersionsListValue> var1);

        public Builder ikeVersions(IKEVersionsListValue ... var1);

        public Builder ikeVersions(Consumer<IKEVersionsListValue.Builder> ... var1);

        public Builder startupAction(String var1);

        public Builder logOptions(VpnTunnelLogOptions var1);

        default public Builder logOptions(Consumer<VpnTunnelLogOptions.Builder> logOptions) {
            return this.logOptions((VpnTunnelLogOptions)((VpnTunnelLogOptions.Builder)VpnTunnelLogOptions.builder().applyMutation(logOptions)).build());
        }
    }
}

