/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTableAnnouncement;
import software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTableAnnouncementListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTransitGatewayRouteTableAnnouncementsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeTransitGatewayRouteTableAnnouncementsResponse> {
    private static final SdkField<List<TransitGatewayRouteTableAnnouncement>> TRANSIT_GATEWAY_ROUTE_TABLE_ANNOUNCEMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TransitGatewayRouteTableAnnouncements").getter(DescribeTransitGatewayRouteTableAnnouncementsResponse.getter(DescribeTransitGatewayRouteTableAnnouncementsResponse::transitGatewayRouteTableAnnouncements)).setter(DescribeTransitGatewayRouteTableAnnouncementsResponse.setter(Builder::transitGatewayRouteTableAnnouncements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayRouteTableAnnouncements").unmarshallLocationName("transitGatewayRouteTableAnnouncements").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TransitGatewayRouteTableAnnouncement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeTransitGatewayRouteTableAnnouncementsResponse.getter(DescribeTransitGatewayRouteTableAnnouncementsResponse::nextToken)).setter(DescribeTransitGatewayRouteTableAnnouncementsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSIT_GATEWAY_ROUTE_TABLE_ANNOUNCEMENTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<TransitGatewayRouteTableAnnouncement> transitGatewayRouteTableAnnouncements;
    private final String nextToken;

    private DescribeTransitGatewayRouteTableAnnouncementsResponse(BuilderImpl builder) {
        super(builder);
        this.transitGatewayRouteTableAnnouncements = builder.transitGatewayRouteTableAnnouncements;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTransitGatewayRouteTableAnnouncements() {
        return this.transitGatewayRouteTableAnnouncements != null && !(this.transitGatewayRouteTableAnnouncements instanceof SdkAutoConstructList);
    }

    public final List<TransitGatewayRouteTableAnnouncement> transitGatewayRouteTableAnnouncements() {
        return this.transitGatewayRouteTableAnnouncements;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTransitGatewayRouteTableAnnouncements() ? this.transitGatewayRouteTableAnnouncements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTransitGatewayRouteTableAnnouncementsResponse)) {
            return false;
        }
        DescribeTransitGatewayRouteTableAnnouncementsResponse other = (DescribeTransitGatewayRouteTableAnnouncementsResponse)((Object)obj);
        return this.hasTransitGatewayRouteTableAnnouncements() == other.hasTransitGatewayRouteTableAnnouncements() && Objects.equals(this.transitGatewayRouteTableAnnouncements(), other.transitGatewayRouteTableAnnouncements()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeTransitGatewayRouteTableAnnouncementsResponse").add("TransitGatewayRouteTableAnnouncements", this.hasTransitGatewayRouteTableAnnouncements() ? this.transitGatewayRouteTableAnnouncements() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransitGatewayRouteTableAnnouncements": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayRouteTableAnnouncements()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTransitGatewayRouteTableAnnouncementsResponse, T> g) {
        return obj -> g.apply((DescribeTransitGatewayRouteTableAnnouncementsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<TransitGatewayRouteTableAnnouncement> transitGatewayRouteTableAnnouncements = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTransitGatewayRouteTableAnnouncementsResponse model) {
            super(model);
            this.transitGatewayRouteTableAnnouncements(model.transitGatewayRouteTableAnnouncements);
            this.nextToken(model.nextToken);
        }

        public final List<TransitGatewayRouteTableAnnouncement.Builder> getTransitGatewayRouteTableAnnouncements() {
            List<TransitGatewayRouteTableAnnouncement.Builder> result = TransitGatewayRouteTableAnnouncementListCopier.copyToBuilder(this.transitGatewayRouteTableAnnouncements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTransitGatewayRouteTableAnnouncements(Collection<TransitGatewayRouteTableAnnouncement.BuilderImpl> transitGatewayRouteTableAnnouncements) {
            this.transitGatewayRouteTableAnnouncements = TransitGatewayRouteTableAnnouncementListCopier.copyFromBuilder(transitGatewayRouteTableAnnouncements);
        }

        @Override
        public final Builder transitGatewayRouteTableAnnouncements(Collection<TransitGatewayRouteTableAnnouncement> transitGatewayRouteTableAnnouncements) {
            this.transitGatewayRouteTableAnnouncements = TransitGatewayRouteTableAnnouncementListCopier.copy(transitGatewayRouteTableAnnouncements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitGatewayRouteTableAnnouncements(TransitGatewayRouteTableAnnouncement ... transitGatewayRouteTableAnnouncements) {
            this.transitGatewayRouteTableAnnouncements(Arrays.asList(transitGatewayRouteTableAnnouncements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitGatewayRouteTableAnnouncements(Consumer<TransitGatewayRouteTableAnnouncement.Builder> ... transitGatewayRouteTableAnnouncements) {
            this.transitGatewayRouteTableAnnouncements(Stream.of(transitGatewayRouteTableAnnouncements).map(c -> (TransitGatewayRouteTableAnnouncement)((TransitGatewayRouteTableAnnouncement.Builder)TransitGatewayRouteTableAnnouncement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeTransitGatewayRouteTableAnnouncementsResponse build() {
            return new DescribeTransitGatewayRouteTableAnnouncementsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTransitGatewayRouteTableAnnouncementsResponse> {
        public Builder transitGatewayRouteTableAnnouncements(Collection<TransitGatewayRouteTableAnnouncement> var1);

        public Builder transitGatewayRouteTableAnnouncements(TransitGatewayRouteTableAnnouncement ... var1);

        public Builder transitGatewayRouteTableAnnouncements(Consumer<TransitGatewayRouteTableAnnouncement.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

