/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AllocationState {
    AVAILABLE("available"),
    UNDER_ASSESSMENT("under-assessment"),
    PERMANENT_FAILURE("permanent-failure"),
    RELEASED("released"),
    RELEASED_PERMANENT_FAILURE("released-permanent-failure"),
    PENDING("pending"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AllocationState> VALUE_MAP;
    private final String value;

    private AllocationState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AllocationState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AllocationState> knownValues() {
        EnumSet<AllocationState> knownValues = EnumSet.allOf(AllocationState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AllocationState.class, AllocationState::toString);
    }
}

