/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.DiskImageDescription;
import software.amazon.awssdk.services.ec2.model.DiskImageVolumeDescription;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportVolumeTaskDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImportVolumeTaskDetails> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(ImportVolumeTaskDetails.getter(ImportVolumeTaskDetails::availabilityZone)).setter(ImportVolumeTaskDetails.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").unmarshallLocationName("availabilityZone").build()}).build();
    private static final SdkField<Long> BYTES_CONVERTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("BytesConverted").getter(ImportVolumeTaskDetails.getter(ImportVolumeTaskDetails::bytesConverted)).setter(ImportVolumeTaskDetails.setter(Builder::bytesConverted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BytesConverted").unmarshallLocationName("bytesConverted").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ImportVolumeTaskDetails.getter(ImportVolumeTaskDetails::description)).setter(ImportVolumeTaskDetails.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<DiskImageDescription> IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Image").getter(ImportVolumeTaskDetails.getter(ImportVolumeTaskDetails::image)).setter(ImportVolumeTaskDetails.setter(Builder::image)).constructor(DiskImageDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Image").unmarshallLocationName("image").build()}).build();
    private static final SdkField<DiskImageVolumeDescription> VOLUME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Volume").getter(ImportVolumeTaskDetails.getter(ImportVolumeTaskDetails::volume)).setter(ImportVolumeTaskDetails.setter(Builder::volume)).constructor(DiskImageVolumeDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Volume").unmarshallLocationName("volume").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD, BYTES_CONVERTED_FIELD, DESCRIPTION_FIELD, IMAGE_FIELD, VOLUME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String availabilityZone;
    private final Long bytesConverted;
    private final String description;
    private final DiskImageDescription image;
    private final DiskImageVolumeDescription volume;

    private ImportVolumeTaskDetails(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.bytesConverted = builder.bytesConverted;
        this.description = builder.description;
        this.image = builder.image;
        this.volume = builder.volume;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final Long bytesConverted() {
        return this.bytesConverted;
    }

    public final String description() {
        return this.description;
    }

    public final DiskImageDescription image() {
        return this.image;
    }

    public final DiskImageVolumeDescription volume() {
        return this.volume;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.bytesConverted());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        hashCode = 31 * hashCode + Objects.hashCode(this.volume());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportVolumeTaskDetails)) {
            return false;
        }
        ImportVolumeTaskDetails other = (ImportVolumeTaskDetails)obj;
        return Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.bytesConverted(), other.bytesConverted()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.image(), other.image()) && Objects.equals(this.volume(), other.volume());
    }

    public final String toString() {
        return ToString.builder((String)"ImportVolumeTaskDetails").add("AvailabilityZone", (Object)this.availabilityZone()).add("BytesConverted", (Object)this.bytesConverted()).add("Description", (Object)this.description()).add("Image", (Object)this.image()).add("Volume", (Object)this.volume()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "BytesConverted": {
                return Optional.ofNullable(clazz.cast(this.bytesConverted()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Image": {
                return Optional.ofNullable(clazz.cast(this.image()));
            }
            case "Volume": {
                return Optional.ofNullable(clazz.cast(this.volume()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportVolumeTaskDetails, T> g) {
        return obj -> g.apply((ImportVolumeTaskDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String availabilityZone;
        private Long bytesConverted;
        private String description;
        private DiskImageDescription image;
        private DiskImageVolumeDescription volume;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportVolumeTaskDetails model) {
            this.availabilityZone(model.availabilityZone);
            this.bytesConverted(model.bytesConverted);
            this.description(model.description);
            this.image(model.image);
            this.volume(model.volume);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final Long getBytesConverted() {
            return this.bytesConverted;
        }

        public final void setBytesConverted(Long bytesConverted) {
            this.bytesConverted = bytesConverted;
        }

        @Override
        public final Builder bytesConverted(Long bytesConverted) {
            this.bytesConverted = bytesConverted;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final DiskImageDescription.Builder getImage() {
            return this.image != null ? this.image.toBuilder() : null;
        }

        public final void setImage(DiskImageDescription.BuilderImpl image) {
            this.image = image != null ? image.build() : null;
        }

        @Override
        public final Builder image(DiskImageDescription image) {
            this.image = image;
            return this;
        }

        public final DiskImageVolumeDescription.Builder getVolume() {
            return this.volume != null ? this.volume.toBuilder() : null;
        }

        public final void setVolume(DiskImageVolumeDescription.BuilderImpl volume) {
            this.volume = volume != null ? volume.build() : null;
        }

        @Override
        public final Builder volume(DiskImageVolumeDescription volume) {
            this.volume = volume;
            return this;
        }

        public ImportVolumeTaskDetails build() {
            return new ImportVolumeTaskDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImportVolumeTaskDetails> {
        public Builder availabilityZone(String var1);

        public Builder bytesConverted(Long var1);

        public Builder description(String var1);

        public Builder image(DiskImageDescription var1);

        default public Builder image(Consumer<DiskImageDescription.Builder> image) {
            return this.image((DiskImageDescription)((DiskImageDescription.Builder)DiskImageDescription.builder().applyMutation(image)).build());
        }

        public Builder volume(DiskImageVolumeDescription var1);

        default public Builder volume(Consumer<DiskImageVolumeDescription.Builder> volume) {
            return this.volume((DiskImageVolumeDescription)((DiskImageVolumeDescription.Builder)DiskImageVolumeDescription.builder().applyMutation(volume)).build());
        }
    }
}

