/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateOverridesListRequestCopier;
import software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateOverridesRequest;
import software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateSpecificationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FleetLaunchTemplateConfigRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FleetLaunchTemplateConfigRequest> {
    private static final SdkField<FleetLaunchTemplateSpecificationRequest> LAUNCH_TEMPLATE_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LaunchTemplateSpecification").getter(FleetLaunchTemplateConfigRequest.getter(FleetLaunchTemplateConfigRequest::launchTemplateSpecification)).setter(FleetLaunchTemplateConfigRequest.setter(Builder::launchTemplateSpecification)).constructor(FleetLaunchTemplateSpecificationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateSpecification").unmarshallLocationName("LaunchTemplateSpecification").build()}).build();
    private static final SdkField<List<FleetLaunchTemplateOverridesRequest>> OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Overrides").getter(FleetLaunchTemplateConfigRequest.getter(FleetLaunchTemplateConfigRequest::overrides)).setter(FleetLaunchTemplateConfigRequest.setter(Builder::overrides)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Overrides").unmarshallLocationName("Overrides").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FleetLaunchTemplateOverridesRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_TEMPLATE_SPECIFICATION_FIELD, OVERRIDES_FIELD));
    private static final long serialVersionUID = 1L;
    private final FleetLaunchTemplateSpecificationRequest launchTemplateSpecification;
    private final List<FleetLaunchTemplateOverridesRequest> overrides;

    private FleetLaunchTemplateConfigRequest(BuilderImpl builder) {
        this.launchTemplateSpecification = builder.launchTemplateSpecification;
        this.overrides = builder.overrides;
    }

    public final FleetLaunchTemplateSpecificationRequest launchTemplateSpecification() {
        return this.launchTemplateSpecification;
    }

    public final boolean hasOverrides() {
        return this.overrides != null && !(this.overrides instanceof SdkAutoConstructList);
    }

    public final List<FleetLaunchTemplateOverridesRequest> overrides() {
        return this.overrides;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplateSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOverrides() ? this.overrides() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetLaunchTemplateConfigRequest)) {
            return false;
        }
        FleetLaunchTemplateConfigRequest other = (FleetLaunchTemplateConfigRequest)obj;
        return Objects.equals(this.launchTemplateSpecification(), other.launchTemplateSpecification()) && this.hasOverrides() == other.hasOverrides() && Objects.equals(this.overrides(), other.overrides());
    }

    public final String toString() {
        return ToString.builder((String)"FleetLaunchTemplateConfigRequest").add("LaunchTemplateSpecification", (Object)this.launchTemplateSpecification()).add("Overrides", this.hasOverrides() ? this.overrides() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LaunchTemplateSpecification": {
                return Optional.ofNullable(clazz.cast(this.launchTemplateSpecification()));
            }
            case "Overrides": {
                return Optional.ofNullable(clazz.cast(this.overrides()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FleetLaunchTemplateConfigRequest, T> g) {
        return obj -> g.apply((FleetLaunchTemplateConfigRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private FleetLaunchTemplateSpecificationRequest launchTemplateSpecification;
        private List<FleetLaunchTemplateOverridesRequest> overrides = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FleetLaunchTemplateConfigRequest model) {
            this.launchTemplateSpecification(model.launchTemplateSpecification);
            this.overrides(model.overrides);
        }

        public final FleetLaunchTemplateSpecificationRequest.Builder getLaunchTemplateSpecification() {
            return this.launchTemplateSpecification != null ? this.launchTemplateSpecification.toBuilder() : null;
        }

        public final void setLaunchTemplateSpecification(FleetLaunchTemplateSpecificationRequest.BuilderImpl launchTemplateSpecification) {
            this.launchTemplateSpecification = launchTemplateSpecification != null ? launchTemplateSpecification.build() : null;
        }

        @Override
        public final Builder launchTemplateSpecification(FleetLaunchTemplateSpecificationRequest launchTemplateSpecification) {
            this.launchTemplateSpecification = launchTemplateSpecification;
            return this;
        }

        public final List<FleetLaunchTemplateOverridesRequest.Builder> getOverrides() {
            List<FleetLaunchTemplateOverridesRequest.Builder> result = FleetLaunchTemplateOverridesListRequestCopier.copyToBuilder(this.overrides);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOverrides(Collection<FleetLaunchTemplateOverridesRequest.BuilderImpl> overrides) {
            this.overrides = FleetLaunchTemplateOverridesListRequestCopier.copyFromBuilder(overrides);
        }

        @Override
        public final Builder overrides(Collection<FleetLaunchTemplateOverridesRequest> overrides) {
            this.overrides = FleetLaunchTemplateOverridesListRequestCopier.copy(overrides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder overrides(FleetLaunchTemplateOverridesRequest ... overrides) {
            this.overrides(Arrays.asList(overrides));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder overrides(Consumer<FleetLaunchTemplateOverridesRequest.Builder> ... overrides) {
            this.overrides(Stream.of(overrides).map(c -> (FleetLaunchTemplateOverridesRequest)((FleetLaunchTemplateOverridesRequest.Builder)FleetLaunchTemplateOverridesRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public FleetLaunchTemplateConfigRequest build() {
            return new FleetLaunchTemplateConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FleetLaunchTemplateConfigRequest> {
        public Builder launchTemplateSpecification(FleetLaunchTemplateSpecificationRequest var1);

        default public Builder launchTemplateSpecification(Consumer<FleetLaunchTemplateSpecificationRequest.Builder> launchTemplateSpecification) {
            return this.launchTemplateSpecification((FleetLaunchTemplateSpecificationRequest)((FleetLaunchTemplateSpecificationRequest.Builder)FleetLaunchTemplateSpecificationRequest.builder().applyMutation(launchTemplateSpecification)).build());
        }

        public Builder overrides(Collection<FleetLaunchTemplateOverridesRequest> var1);

        public Builder overrides(FleetLaunchTemplateOverridesRequest ... var1);

        public Builder overrides(Consumer<FleetLaunchTemplateOverridesRequest.Builder> ... var1);
    }
}

