/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplateVersionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplateVersionsResponse;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateVersion;

public class DescribeLaunchTemplateVersionsIterable
implements SdkIterable<DescribeLaunchTemplateVersionsResponse> {
    private final Ec2Client client;
    private final DescribeLaunchTemplateVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeLaunchTemplateVersionsIterable(Ec2Client client, DescribeLaunchTemplateVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeLaunchTemplateVersionsResponseFetcher();
    }

    public Iterator<DescribeLaunchTemplateVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<LaunchTemplateVersion> launchTemplateVersions() {
        Function<DescribeLaunchTemplateVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.launchTemplateVersions() != null) {
                return response.launchTemplateVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeLaunchTemplateVersionsResponseFetcher
    implements SyncPageFetcher<DescribeLaunchTemplateVersionsResponse> {
        private DescribeLaunchTemplateVersionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeLaunchTemplateVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeLaunchTemplateVersionsResponse nextPage(DescribeLaunchTemplateVersionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeLaunchTemplateVersionsIterable.this.client.describeLaunchTemplateVersions(DescribeLaunchTemplateVersionsIterable.this.firstRequest);
            }
            return DescribeLaunchTemplateVersionsIterable.this.client.describeLaunchTemplateVersions((DescribeLaunchTemplateVersionsRequest)((Object)DescribeLaunchTemplateVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

