/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessEndpointsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessEndpointsResponse;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessEndpoint;

public class DescribeVerifiedAccessEndpointsIterable
implements SdkIterable<DescribeVerifiedAccessEndpointsResponse> {
    private final Ec2Client client;
    private final DescribeVerifiedAccessEndpointsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeVerifiedAccessEndpointsIterable(Ec2Client client, DescribeVerifiedAccessEndpointsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeVerifiedAccessEndpointsResponseFetcher();
    }

    public Iterator<DescribeVerifiedAccessEndpointsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<VerifiedAccessEndpoint> verifiedAccessEndpoints() {
        Function<DescribeVerifiedAccessEndpointsResponse, Iterator> getIterator = response -> {
            if (response != null && response.verifiedAccessEndpoints() != null) {
                return response.verifiedAccessEndpoints().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeVerifiedAccessEndpointsResponseFetcher
    implements SyncPageFetcher<DescribeVerifiedAccessEndpointsResponse> {
        private DescribeVerifiedAccessEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeVerifiedAccessEndpointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeVerifiedAccessEndpointsResponse nextPage(DescribeVerifiedAccessEndpointsResponse previousPage) {
            if (previousPage == null) {
                return DescribeVerifiedAccessEndpointsIterable.this.client.describeVerifiedAccessEndpoints(DescribeVerifiedAccessEndpointsIterable.this.firstRequest);
            }
            return DescribeVerifiedAccessEndpointsIterable.this.client.describeVerifiedAccessEndpoints((DescribeVerifiedAccessEndpointsRequest)((Object)DescribeVerifiedAccessEndpointsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

