/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.model.DescribeHostsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeHostsResponse;
import software.amazon.awssdk.services.ec2.model.Host;

public class DescribeHostsPublisher
implements SdkPublisher<DescribeHostsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeHostsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeHostsPublisher(Ec2AsyncClient client, DescribeHostsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeHostsPublisher(Ec2AsyncClient client, DescribeHostsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeHostsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeHostsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Host> hosts() {
        Function<DescribeHostsResponse, Iterator> getIterator = response -> {
            if (response != null && response.hosts() != null) {
                return response.hosts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeHostsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeHostsResponseFetcher
    implements AsyncPageFetcher<DescribeHostsResponse> {
        private DescribeHostsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeHostsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeHostsResponse> nextPage(DescribeHostsResponse previousPage) {
            if (previousPage == null) {
                return DescribeHostsPublisher.this.client.describeHosts(DescribeHostsPublisher.this.firstRequest);
            }
            return DescribeHostsPublisher.this.client.describeHosts((DescribeHostsRequest)((Object)DescribeHostsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

