/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.model.GetSpotPlacementScoresRequest;
import software.amazon.awssdk.services.ec2.model.GetSpotPlacementScoresResponse;
import software.amazon.awssdk.services.ec2.model.SpotPlacementScore;

public class GetSpotPlacementScoresPublisher
implements SdkPublisher<GetSpotPlacementScoresResponse> {
    private final Ec2AsyncClient client;
    private final GetSpotPlacementScoresRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetSpotPlacementScoresPublisher(Ec2AsyncClient client, GetSpotPlacementScoresRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetSpotPlacementScoresPublisher(Ec2AsyncClient client, GetSpotPlacementScoresRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetSpotPlacementScoresResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetSpotPlacementScoresResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SpotPlacementScore> spotPlacementScores() {
        Function<GetSpotPlacementScoresResponse, Iterator> getIterator = response -> {
            if (response != null && response.spotPlacementScores() != null) {
                return response.spotPlacementScores().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetSpotPlacementScoresResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetSpotPlacementScoresResponseFetcher
    implements AsyncPageFetcher<GetSpotPlacementScoresResponse> {
        private GetSpotPlacementScoresResponseFetcher() {
        }

        public boolean hasNextPage(GetSpotPlacementScoresResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetSpotPlacementScoresResponse> nextPage(GetSpotPlacementScoresResponse previousPage) {
            if (previousPage == null) {
                return GetSpotPlacementScoresPublisher.this.client.getSpotPlacementScores(GetSpotPlacementScoresPublisher.this.firstRequest);
            }
            return GetSpotPlacementScoresPublisher.this.client.getSpotPlacementScores((GetSpotPlacementScoresRequest)((Object)GetSpotPlacementScoresPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

