/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.model.GetIpamPoolCidrsRequest;
import software.amazon.awssdk.services.ec2.model.GetIpamPoolCidrsResponse;
import software.amazon.awssdk.services.ec2.model.IpamPoolCidr;

public class GetIpamPoolCidrsPublisher
implements SdkPublisher<GetIpamPoolCidrsResponse> {
    private final Ec2AsyncClient client;
    private final GetIpamPoolCidrsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetIpamPoolCidrsPublisher(Ec2AsyncClient client, GetIpamPoolCidrsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetIpamPoolCidrsPublisher(Ec2AsyncClient client, GetIpamPoolCidrsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetIpamPoolCidrsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetIpamPoolCidrsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<IpamPoolCidr> ipamPoolCidrs() {
        Function<GetIpamPoolCidrsResponse, Iterator> getIterator = response -> {
            if (response != null && response.ipamPoolCidrs() != null) {
                return response.ipamPoolCidrs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetIpamPoolCidrsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetIpamPoolCidrsResponseFetcher
    implements AsyncPageFetcher<GetIpamPoolCidrsResponse> {
        private GetIpamPoolCidrsResponseFetcher() {
        }

        public boolean hasNextPage(GetIpamPoolCidrsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetIpamPoolCidrsResponse> nextPage(GetIpamPoolCidrsResponse previousPage) {
            if (previousPage == null) {
                return GetIpamPoolCidrsPublisher.this.client.getIpamPoolCidrs(GetIpamPoolCidrsPublisher.this.firstRequest);
            }
            return GetIpamPoolCidrsPublisher.this.client.getIpamPoolCidrs((GetIpamPoolCidrsRequest)((Object)GetIpamPoolCidrsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

