/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.IamInstanceProfileAssociation;
import software.amazon.awssdk.services.ec2.model.IamInstanceProfileAssociationSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeIamInstanceProfileAssociationsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeIamInstanceProfileAssociationsResponse> {
    private static final SdkField<List<IamInstanceProfileAssociation>> IAM_INSTANCE_PROFILE_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IamInstanceProfileAssociations").getter(DescribeIamInstanceProfileAssociationsResponse.getter(DescribeIamInstanceProfileAssociationsResponse::iamInstanceProfileAssociations)).setter(DescribeIamInstanceProfileAssociationsResponse.setter(Builder::iamInstanceProfileAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamInstanceProfileAssociationSet").unmarshallLocationName("iamInstanceProfileAssociationSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IamInstanceProfileAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeIamInstanceProfileAssociationsResponse.getter(DescribeIamInstanceProfileAssociationsResponse::nextToken)).setter(DescribeIamInstanceProfileAssociationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IAM_INSTANCE_PROFILE_ASSOCIATIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<IamInstanceProfileAssociation> iamInstanceProfileAssociations;
    private final String nextToken;

    private DescribeIamInstanceProfileAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.iamInstanceProfileAssociations = builder.iamInstanceProfileAssociations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasIamInstanceProfileAssociations() {
        return this.iamInstanceProfileAssociations != null && !(this.iamInstanceProfileAssociations instanceof SdkAutoConstructList);
    }

    public final List<IamInstanceProfileAssociation> iamInstanceProfileAssociations() {
        return this.iamInstanceProfileAssociations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIamInstanceProfileAssociations() ? this.iamInstanceProfileAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIamInstanceProfileAssociationsResponse)) {
            return false;
        }
        DescribeIamInstanceProfileAssociationsResponse other = (DescribeIamInstanceProfileAssociationsResponse)((Object)obj);
        return this.hasIamInstanceProfileAssociations() == other.hasIamInstanceProfileAssociations() && Objects.equals(this.iamInstanceProfileAssociations(), other.iamInstanceProfileAssociations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeIamInstanceProfileAssociationsResponse").add("IamInstanceProfileAssociations", this.hasIamInstanceProfileAssociations() ? this.iamInstanceProfileAssociations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IamInstanceProfileAssociations": {
                return Optional.ofNullable(clazz.cast(this.iamInstanceProfileAssociations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeIamInstanceProfileAssociationsResponse, T> g) {
        return obj -> g.apply((DescribeIamInstanceProfileAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<IamInstanceProfileAssociation> iamInstanceProfileAssociations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIamInstanceProfileAssociationsResponse model) {
            super(model);
            this.iamInstanceProfileAssociations(model.iamInstanceProfileAssociations);
            this.nextToken(model.nextToken);
        }

        public final List<IamInstanceProfileAssociation.Builder> getIamInstanceProfileAssociations() {
            List<IamInstanceProfileAssociation.Builder> result = IamInstanceProfileAssociationSetCopier.copyToBuilder(this.iamInstanceProfileAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIamInstanceProfileAssociations(Collection<IamInstanceProfileAssociation.BuilderImpl> iamInstanceProfileAssociations) {
            this.iamInstanceProfileAssociations = IamInstanceProfileAssociationSetCopier.copyFromBuilder(iamInstanceProfileAssociations);
        }

        @Override
        @Transient
        public final Builder iamInstanceProfileAssociations(Collection<IamInstanceProfileAssociation> iamInstanceProfileAssociations) {
            this.iamInstanceProfileAssociations = IamInstanceProfileAssociationSetCopier.copy(iamInstanceProfileAssociations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder iamInstanceProfileAssociations(IamInstanceProfileAssociation ... iamInstanceProfileAssociations) {
            this.iamInstanceProfileAssociations(Arrays.asList(iamInstanceProfileAssociations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder iamInstanceProfileAssociations(Consumer<IamInstanceProfileAssociation.Builder> ... iamInstanceProfileAssociations) {
            this.iamInstanceProfileAssociations(Stream.of(iamInstanceProfileAssociations).map(c -> (IamInstanceProfileAssociation)((IamInstanceProfileAssociation.Builder)IamInstanceProfileAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeIamInstanceProfileAssociationsResponse build() {
            return new DescribeIamInstanceProfileAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeIamInstanceProfileAssociationsResponse> {
        public Builder iamInstanceProfileAssociations(Collection<IamInstanceProfileAssociation> var1);

        public Builder iamInstanceProfileAssociations(IamInstanceProfileAssociation ... var1);

        public Builder iamInstanceProfileAssociations(Consumer<IamInstanceProfileAssociation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

