/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.PlacementGroupStrategy;
import software.amazon.awssdk.services.ec2.model.PlacementGroupStrategyListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PlacementGroupInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PlacementGroupInfo> {
    private static final SdkField<List<String>> SUPPORTED_STRATEGIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedStrategies").getter(PlacementGroupInfo.getter(PlacementGroupInfo::supportedStrategiesAsStrings)).setter(PlacementGroupInfo.setter(Builder::supportedStrategiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedStrategies").unmarshallLocationName("supportedStrategies").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUPPORTED_STRATEGIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> supportedStrategies;

    private PlacementGroupInfo(BuilderImpl builder) {
        this.supportedStrategies = builder.supportedStrategies;
    }

    public final List<PlacementGroupStrategy> supportedStrategies() {
        return PlacementGroupStrategyListCopier.copyStringToEnum(this.supportedStrategies);
    }

    public final boolean hasSupportedStrategies() {
        return this.supportedStrategies != null && !(this.supportedStrategies instanceof SdkAutoConstructList);
    }

    public final List<String> supportedStrategiesAsStrings() {
        return this.supportedStrategies;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedStrategies() ? this.supportedStrategiesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlacementGroupInfo)) {
            return false;
        }
        PlacementGroupInfo other = (PlacementGroupInfo)obj;
        return this.hasSupportedStrategies() == other.hasSupportedStrategies() && Objects.equals(this.supportedStrategiesAsStrings(), other.supportedStrategiesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"PlacementGroupInfo").add("SupportedStrategies", this.hasSupportedStrategies() ? this.supportedStrategiesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SupportedStrategies": {
                return Optional.ofNullable(clazz.cast(this.supportedStrategiesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PlacementGroupInfo, T> g) {
        return obj -> g.apply((PlacementGroupInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> supportedStrategies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PlacementGroupInfo model) {
            this.supportedStrategiesWithStrings(model.supportedStrategies);
        }

        public final Collection<String> getSupportedStrategies() {
            if (this.supportedStrategies instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedStrategies;
        }

        public final void setSupportedStrategies(Collection<String> supportedStrategies) {
            this.supportedStrategies = PlacementGroupStrategyListCopier.copy(supportedStrategies);
        }

        @Override
        @Transient
        public final Builder supportedStrategiesWithStrings(Collection<String> supportedStrategies) {
            this.supportedStrategies = PlacementGroupStrategyListCopier.copy(supportedStrategies);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder supportedStrategiesWithStrings(String ... supportedStrategies) {
            this.supportedStrategiesWithStrings(Arrays.asList(supportedStrategies));
            return this;
        }

        @Override
        @Transient
        public final Builder supportedStrategies(Collection<PlacementGroupStrategy> supportedStrategies) {
            this.supportedStrategies = PlacementGroupStrategyListCopier.copyEnumToString(supportedStrategies);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder supportedStrategies(PlacementGroupStrategy ... supportedStrategies) {
            this.supportedStrategies(Arrays.asList(supportedStrategies));
            return this;
        }

        public PlacementGroupInfo build() {
            return new PlacementGroupInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PlacementGroupInfo> {
        public Builder supportedStrategiesWithStrings(Collection<String> var1);

        public Builder supportedStrategiesWithStrings(String ... var1);

        public Builder supportedStrategies(Collection<PlacementGroupStrategy> var1);

        public Builder supportedStrategies(PlacementGroupStrategy ... var1);
    }
}

