/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.ReservationValue;
import software.amazon.awssdk.services.ec2.model.ReservedInstanceReservationValue;
import software.amazon.awssdk.services.ec2.model.ReservedInstanceReservationValueSetCopier;
import software.amazon.awssdk.services.ec2.model.TargetReservationValue;
import software.amazon.awssdk.services.ec2.model.TargetReservationValueSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetReservedInstancesExchangeQuoteResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, GetReservedInstancesExchangeQuoteResponse> {
    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrencyCode").getter(GetReservedInstancesExchangeQuoteResponse.getter(GetReservedInstancesExchangeQuoteResponse::currencyCode)).setter(GetReservedInstancesExchangeQuoteResponse.setter(Builder::currencyCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").unmarshallLocationName("currencyCode").build()}).build();
    private static final SdkField<Boolean> IS_VALID_EXCHANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsValidExchange").getter(GetReservedInstancesExchangeQuoteResponse.getter(GetReservedInstancesExchangeQuoteResponse::isValidExchange)).setter(GetReservedInstancesExchangeQuoteResponse.setter(Builder::isValidExchange)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsValidExchange").unmarshallLocationName("isValidExchange").build()}).build();
    private static final SdkField<Instant> OUTPUT_RESERVED_INSTANCES_WILL_EXPIRE_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("OutputReservedInstancesWillExpireAt").getter(GetReservedInstancesExchangeQuoteResponse.getter(GetReservedInstancesExchangeQuoteResponse::outputReservedInstancesWillExpireAt)).setter(GetReservedInstancesExchangeQuoteResponse.setter(Builder::outputReservedInstancesWillExpireAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputReservedInstancesWillExpireAt").unmarshallLocationName("outputReservedInstancesWillExpireAt").build()}).build();
    private static final SdkField<String> PAYMENT_DUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PaymentDue").getter(GetReservedInstancesExchangeQuoteResponse.getter(GetReservedInstancesExchangeQuoteResponse::paymentDue)).setter(GetReservedInstancesExchangeQuoteResponse.setter(Builder::paymentDue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaymentDue").unmarshallLocationName("paymentDue").build()}).build();
    private static final SdkField<ReservationValue> RESERVED_INSTANCE_VALUE_ROLLUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReservedInstanceValueRollup").getter(GetReservedInstancesExchangeQuoteResponse.getter(GetReservedInstancesExchangeQuoteResponse::reservedInstanceValueRollup)).setter(GetReservedInstancesExchangeQuoteResponse.setter(Builder::reservedInstanceValueRollup)).constructor(ReservationValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstanceValueRollup").unmarshallLocationName("reservedInstanceValueRollup").build()}).build();
    private static final SdkField<List<ReservedInstanceReservationValue>> RESERVED_INSTANCE_VALUE_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReservedInstanceValueSet").getter(GetReservedInstancesExchangeQuoteResponse.getter(GetReservedInstancesExchangeQuoteResponse::reservedInstanceValueSet)).setter(GetReservedInstancesExchangeQuoteResponse.setter(Builder::reservedInstanceValueSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstanceValueSet").unmarshallLocationName("reservedInstanceValueSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReservedInstanceReservationValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<ReservationValue> TARGET_CONFIGURATION_VALUE_ROLLUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TargetConfigurationValueRollup").getter(GetReservedInstancesExchangeQuoteResponse.getter(GetReservedInstancesExchangeQuoteResponse::targetConfigurationValueRollup)).setter(GetReservedInstancesExchangeQuoteResponse.setter(Builder::targetConfigurationValueRollup)).constructor(ReservationValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetConfigurationValueRollup").unmarshallLocationName("targetConfigurationValueRollup").build()}).build();
    private static final SdkField<List<TargetReservationValue>> TARGET_CONFIGURATION_VALUE_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetConfigurationValueSet").getter(GetReservedInstancesExchangeQuoteResponse.getter(GetReservedInstancesExchangeQuoteResponse::targetConfigurationValueSet)).setter(GetReservedInstancesExchangeQuoteResponse.setter(Builder::targetConfigurationValueSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetConfigurationValueSet").unmarshallLocationName("targetConfigurationValueSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TargetReservationValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> VALIDATION_FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ValidationFailureReason").getter(GetReservedInstancesExchangeQuoteResponse.getter(GetReservedInstancesExchangeQuoteResponse::validationFailureReason)).setter(GetReservedInstancesExchangeQuoteResponse.setter(Builder::validationFailureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationFailureReason").unmarshallLocationName("validationFailureReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENCY_CODE_FIELD, IS_VALID_EXCHANGE_FIELD, OUTPUT_RESERVED_INSTANCES_WILL_EXPIRE_AT_FIELD, PAYMENT_DUE_FIELD, RESERVED_INSTANCE_VALUE_ROLLUP_FIELD, RESERVED_INSTANCE_VALUE_SET_FIELD, TARGET_CONFIGURATION_VALUE_ROLLUP_FIELD, TARGET_CONFIGURATION_VALUE_SET_FIELD, VALIDATION_FAILURE_REASON_FIELD));
    private final String currencyCode;
    private final Boolean isValidExchange;
    private final Instant outputReservedInstancesWillExpireAt;
    private final String paymentDue;
    private final ReservationValue reservedInstanceValueRollup;
    private final List<ReservedInstanceReservationValue> reservedInstanceValueSet;
    private final ReservationValue targetConfigurationValueRollup;
    private final List<TargetReservationValue> targetConfigurationValueSet;
    private final String validationFailureReason;

    private GetReservedInstancesExchangeQuoteResponse(BuilderImpl builder) {
        super(builder);
        this.currencyCode = builder.currencyCode;
        this.isValidExchange = builder.isValidExchange;
        this.outputReservedInstancesWillExpireAt = builder.outputReservedInstancesWillExpireAt;
        this.paymentDue = builder.paymentDue;
        this.reservedInstanceValueRollup = builder.reservedInstanceValueRollup;
        this.reservedInstanceValueSet = builder.reservedInstanceValueSet;
        this.targetConfigurationValueRollup = builder.targetConfigurationValueRollup;
        this.targetConfigurationValueSet = builder.targetConfigurationValueSet;
        this.validationFailureReason = builder.validationFailureReason;
    }

    public final String currencyCode() {
        return this.currencyCode;
    }

    public final Boolean isValidExchange() {
        return this.isValidExchange;
    }

    public final Instant outputReservedInstancesWillExpireAt() {
        return this.outputReservedInstancesWillExpireAt;
    }

    public final String paymentDue() {
        return this.paymentDue;
    }

    public final ReservationValue reservedInstanceValueRollup() {
        return this.reservedInstanceValueRollup;
    }

    public final boolean hasReservedInstanceValueSet() {
        return this.reservedInstanceValueSet != null && !(this.reservedInstanceValueSet instanceof SdkAutoConstructList);
    }

    public final List<ReservedInstanceReservationValue> reservedInstanceValueSet() {
        return this.reservedInstanceValueSet;
    }

    public final ReservationValue targetConfigurationValueRollup() {
        return this.targetConfigurationValueRollup;
    }

    public final boolean hasTargetConfigurationValueSet() {
        return this.targetConfigurationValueSet != null && !(this.targetConfigurationValueSet instanceof SdkAutoConstructList);
    }

    public final List<TargetReservationValue> targetConfigurationValueSet() {
        return this.targetConfigurationValueSet;
    }

    public final String validationFailureReason() {
        return this.validationFailureReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.isValidExchange());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputReservedInstancesWillExpireAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.paymentDue());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedInstanceValueRollup());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReservedInstanceValueSet() ? this.reservedInstanceValueSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.targetConfigurationValueRollup());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetConfigurationValueSet() ? this.targetConfigurationValueSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.validationFailureReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReservedInstancesExchangeQuoteResponse)) {
            return false;
        }
        GetReservedInstancesExchangeQuoteResponse other = (GetReservedInstancesExchangeQuoteResponse)((Object)obj);
        return Objects.equals(this.currencyCode(), other.currencyCode()) && Objects.equals(this.isValidExchange(), other.isValidExchange()) && Objects.equals(this.outputReservedInstancesWillExpireAt(), other.outputReservedInstancesWillExpireAt()) && Objects.equals(this.paymentDue(), other.paymentDue()) && Objects.equals(this.reservedInstanceValueRollup(), other.reservedInstanceValueRollup()) && this.hasReservedInstanceValueSet() == other.hasReservedInstanceValueSet() && Objects.equals(this.reservedInstanceValueSet(), other.reservedInstanceValueSet()) && Objects.equals(this.targetConfigurationValueRollup(), other.targetConfigurationValueRollup()) && this.hasTargetConfigurationValueSet() == other.hasTargetConfigurationValueSet() && Objects.equals(this.targetConfigurationValueSet(), other.targetConfigurationValueSet()) && Objects.equals(this.validationFailureReason(), other.validationFailureReason());
    }

    public final String toString() {
        return ToString.builder((String)"GetReservedInstancesExchangeQuoteResponse").add("CurrencyCode", (Object)this.currencyCode()).add("IsValidExchange", (Object)this.isValidExchange()).add("OutputReservedInstancesWillExpireAt", (Object)this.outputReservedInstancesWillExpireAt()).add("PaymentDue", (Object)this.paymentDue()).add("ReservedInstanceValueRollup", (Object)this.reservedInstanceValueRollup()).add("ReservedInstanceValueSet", this.hasReservedInstanceValueSet() ? this.reservedInstanceValueSet() : null).add("TargetConfigurationValueRollup", (Object)this.targetConfigurationValueRollup()).add("TargetConfigurationValueSet", this.hasTargetConfigurationValueSet() ? this.targetConfigurationValueSet() : null).add("ValidationFailureReason", (Object)this.validationFailureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CurrencyCode": {
                return Optional.ofNullable(clazz.cast(this.currencyCode()));
            }
            case "IsValidExchange": {
                return Optional.ofNullable(clazz.cast(this.isValidExchange()));
            }
            case "OutputReservedInstancesWillExpireAt": {
                return Optional.ofNullable(clazz.cast(this.outputReservedInstancesWillExpireAt()));
            }
            case "PaymentDue": {
                return Optional.ofNullable(clazz.cast(this.paymentDue()));
            }
            case "ReservedInstanceValueRollup": {
                return Optional.ofNullable(clazz.cast(this.reservedInstanceValueRollup()));
            }
            case "ReservedInstanceValueSet": {
                return Optional.ofNullable(clazz.cast(this.reservedInstanceValueSet()));
            }
            case "TargetConfigurationValueRollup": {
                return Optional.ofNullable(clazz.cast(this.targetConfigurationValueRollup()));
            }
            case "TargetConfigurationValueSet": {
                return Optional.ofNullable(clazz.cast(this.targetConfigurationValueSet()));
            }
            case "ValidationFailureReason": {
                return Optional.ofNullable(clazz.cast(this.validationFailureReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetReservedInstancesExchangeQuoteResponse, T> g) {
        return obj -> g.apply((GetReservedInstancesExchangeQuoteResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String currencyCode;
        private Boolean isValidExchange;
        private Instant outputReservedInstancesWillExpireAt;
        private String paymentDue;
        private ReservationValue reservedInstanceValueRollup;
        private List<ReservedInstanceReservationValue> reservedInstanceValueSet = DefaultSdkAutoConstructList.getInstance();
        private ReservationValue targetConfigurationValueRollup;
        private List<TargetReservationValue> targetConfigurationValueSet = DefaultSdkAutoConstructList.getInstance();
        private String validationFailureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReservedInstancesExchangeQuoteResponse model) {
            super(model);
            this.currencyCode(model.currencyCode);
            this.isValidExchange(model.isValidExchange);
            this.outputReservedInstancesWillExpireAt(model.outputReservedInstancesWillExpireAt);
            this.paymentDue(model.paymentDue);
            this.reservedInstanceValueRollup(model.reservedInstanceValueRollup);
            this.reservedInstanceValueSet(model.reservedInstanceValueSet);
            this.targetConfigurationValueRollup(model.targetConfigurationValueRollup);
            this.targetConfigurationValueSet(model.targetConfigurationValueSet);
            this.validationFailureReason(model.validationFailureReason);
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        @Transient
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final Boolean getIsValidExchange() {
            return this.isValidExchange;
        }

        public final void setIsValidExchange(Boolean isValidExchange) {
            this.isValidExchange = isValidExchange;
        }

        @Override
        @Transient
        public final Builder isValidExchange(Boolean isValidExchange) {
            this.isValidExchange = isValidExchange;
            return this;
        }

        public final Instant getOutputReservedInstancesWillExpireAt() {
            return this.outputReservedInstancesWillExpireAt;
        }

        public final void setOutputReservedInstancesWillExpireAt(Instant outputReservedInstancesWillExpireAt) {
            this.outputReservedInstancesWillExpireAt = outputReservedInstancesWillExpireAt;
        }

        @Override
        @Transient
        public final Builder outputReservedInstancesWillExpireAt(Instant outputReservedInstancesWillExpireAt) {
            this.outputReservedInstancesWillExpireAt = outputReservedInstancesWillExpireAt;
            return this;
        }

        public final String getPaymentDue() {
            return this.paymentDue;
        }

        public final void setPaymentDue(String paymentDue) {
            this.paymentDue = paymentDue;
        }

        @Override
        @Transient
        public final Builder paymentDue(String paymentDue) {
            this.paymentDue = paymentDue;
            return this;
        }

        public final ReservationValue.Builder getReservedInstanceValueRollup() {
            return this.reservedInstanceValueRollup != null ? this.reservedInstanceValueRollup.toBuilder() : null;
        }

        public final void setReservedInstanceValueRollup(ReservationValue.BuilderImpl reservedInstanceValueRollup) {
            this.reservedInstanceValueRollup = reservedInstanceValueRollup != null ? reservedInstanceValueRollup.build() : null;
        }

        @Override
        @Transient
        public final Builder reservedInstanceValueRollup(ReservationValue reservedInstanceValueRollup) {
            this.reservedInstanceValueRollup = reservedInstanceValueRollup;
            return this;
        }

        public final List<ReservedInstanceReservationValue.Builder> getReservedInstanceValueSet() {
            List<ReservedInstanceReservationValue.Builder> result = ReservedInstanceReservationValueSetCopier.copyToBuilder(this.reservedInstanceValueSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReservedInstanceValueSet(Collection<ReservedInstanceReservationValue.BuilderImpl> reservedInstanceValueSet) {
            this.reservedInstanceValueSet = ReservedInstanceReservationValueSetCopier.copyFromBuilder(reservedInstanceValueSet);
        }

        @Override
        @Transient
        public final Builder reservedInstanceValueSet(Collection<ReservedInstanceReservationValue> reservedInstanceValueSet) {
            this.reservedInstanceValueSet = ReservedInstanceReservationValueSetCopier.copy(reservedInstanceValueSet);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder reservedInstanceValueSet(ReservedInstanceReservationValue ... reservedInstanceValueSet) {
            this.reservedInstanceValueSet(Arrays.asList(reservedInstanceValueSet));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder reservedInstanceValueSet(Consumer<ReservedInstanceReservationValue.Builder> ... reservedInstanceValueSet) {
            this.reservedInstanceValueSet(Stream.of(reservedInstanceValueSet).map(c -> (ReservedInstanceReservationValue)((ReservedInstanceReservationValue.Builder)ReservedInstanceReservationValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ReservationValue.Builder getTargetConfigurationValueRollup() {
            return this.targetConfigurationValueRollup != null ? this.targetConfigurationValueRollup.toBuilder() : null;
        }

        public final void setTargetConfigurationValueRollup(ReservationValue.BuilderImpl targetConfigurationValueRollup) {
            this.targetConfigurationValueRollup = targetConfigurationValueRollup != null ? targetConfigurationValueRollup.build() : null;
        }

        @Override
        @Transient
        public final Builder targetConfigurationValueRollup(ReservationValue targetConfigurationValueRollup) {
            this.targetConfigurationValueRollup = targetConfigurationValueRollup;
            return this;
        }

        public final List<TargetReservationValue.Builder> getTargetConfigurationValueSet() {
            List<TargetReservationValue.Builder> result = TargetReservationValueSetCopier.copyToBuilder(this.targetConfigurationValueSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetConfigurationValueSet(Collection<TargetReservationValue.BuilderImpl> targetConfigurationValueSet) {
            this.targetConfigurationValueSet = TargetReservationValueSetCopier.copyFromBuilder(targetConfigurationValueSet);
        }

        @Override
        @Transient
        public final Builder targetConfigurationValueSet(Collection<TargetReservationValue> targetConfigurationValueSet) {
            this.targetConfigurationValueSet = TargetReservationValueSetCopier.copy(targetConfigurationValueSet);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder targetConfigurationValueSet(TargetReservationValue ... targetConfigurationValueSet) {
            this.targetConfigurationValueSet(Arrays.asList(targetConfigurationValueSet));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder targetConfigurationValueSet(Consumer<TargetReservationValue.Builder> ... targetConfigurationValueSet) {
            this.targetConfigurationValueSet(Stream.of(targetConfigurationValueSet).map(c -> (TargetReservationValue)((TargetReservationValue.Builder)TargetReservationValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getValidationFailureReason() {
            return this.validationFailureReason;
        }

        public final void setValidationFailureReason(String validationFailureReason) {
            this.validationFailureReason = validationFailureReason;
        }

        @Override
        @Transient
        public final Builder validationFailureReason(String validationFailureReason) {
            this.validationFailureReason = validationFailureReason;
            return this;
        }

        @Override
        public GetReservedInstancesExchangeQuoteResponse build() {
            return new GetReservedInstancesExchangeQuoteResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetReservedInstancesExchangeQuoteResponse> {
        public Builder currencyCode(String var1);

        public Builder isValidExchange(Boolean var1);

        public Builder outputReservedInstancesWillExpireAt(Instant var1);

        public Builder paymentDue(String var1);

        public Builder reservedInstanceValueRollup(ReservationValue var1);

        default public Builder reservedInstanceValueRollup(Consumer<ReservationValue.Builder> reservedInstanceValueRollup) {
            return this.reservedInstanceValueRollup((ReservationValue)((ReservationValue.Builder)ReservationValue.builder().applyMutation(reservedInstanceValueRollup)).build());
        }

        public Builder reservedInstanceValueSet(Collection<ReservedInstanceReservationValue> var1);

        public Builder reservedInstanceValueSet(ReservedInstanceReservationValue ... var1);

        public Builder reservedInstanceValueSet(Consumer<ReservedInstanceReservationValue.Builder> ... var1);

        public Builder targetConfigurationValueRollup(ReservationValue var1);

        default public Builder targetConfigurationValueRollup(Consumer<ReservationValue.Builder> targetConfigurationValueRollup) {
            return this.targetConfigurationValueRollup((ReservationValue)((ReservationValue.Builder)ReservationValue.builder().applyMutation(targetConfigurationValueRollup)).build());
        }

        public Builder targetConfigurationValueSet(Collection<TargetReservationValue> var1);

        public Builder targetConfigurationValueSet(TargetReservationValue ... var1);

        public Builder targetConfigurationValueSet(Consumer<TargetReservationValue.Builder> ... var1);

        public Builder validationFailureReason(String var1);
    }
}

