/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.GroupIdStringListCopier;
import software.amazon.awssdk.services.ec2.model.InstanceIpv6Address;
import software.amazon.awssdk.services.ec2.model.InstanceIpv6AddressListCopier;
import software.amazon.awssdk.services.ec2.model.Ipv4PrefixListResponseCopier;
import software.amazon.awssdk.services.ec2.model.Ipv4PrefixSpecificationResponse;
import software.amazon.awssdk.services.ec2.model.Ipv6PrefixListResponseCopier;
import software.amazon.awssdk.services.ec2.model.Ipv6PrefixSpecificationResponse;
import software.amazon.awssdk.services.ec2.model.PrivateIpAddressSpecification;
import software.amazon.awssdk.services.ec2.model.PrivateIpAddressSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LaunchTemplateInstanceNetworkInterfaceSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LaunchTemplateInstanceNetworkInterfaceSpecification> {
    private static final SdkField<Boolean> ASSOCIATE_CARRIER_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AssociateCarrierIpAddress").getter(LaunchTemplateInstanceNetworkInterfaceSpecification.getter(LaunchTemplateInstanceNetworkInterfaceSpecification::associateCarrierIpAddress)).setter(LaunchTemplateInstanceNetworkInterfaceSpecification.setter(Builder::associateCarrierIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociateCarrierIpAddress").unmarshallLocationName("associateCarrierIpAddress").build()}).build();
    private static final SdkField<Boolean> ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AssociatePublicIpAddress").getter(LaunchTemplateInstanceNetworkInterfaceSpecification.getter(LaunchTemplateInstanceNetworkInterfaceSpecification::associatePublicIpAddress)).setter(LaunchTemplateInstanceNetworkInterfaceSpecification.setter(Builder::associatePublicIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatePublicIpAddress").unmarshallLocationName("associatePublicIpAddress").build()}).build();
    private static final SdkField<Boolean> DELETE_ON_TERMINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeleteOnTermination").getter(LaunchTemplateInstanceNetworkInterfaceSpecification.getter(LaunchTemplateInstanceNetworkInterfaceSpecification::deleteOnTermination)).setter(LaunchTemplateInstanceNetworkInterfaceSpecification.setter(Builder::deleteOnTermination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteOnTermination").unmarshallLocationName("deleteOnTermination").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(LaunchTemplateInstanceNetworkInterfaceSpecification.getter(LaunchTemplateInstanceNetworkInterfaceSpecification::description)).setter(LaunchTemplateInstanceNetworkInterfaceSpecification.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<Integer> DEVICE_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DeviceIndex").getter(LaunchTemplateInstanceNetworkInterfaceSpecification.getter(LaunchTemplateInstanceNetworkInterfaceSpecification::deviceIndex)).setter(LaunchTemplateInstanceNetworkInterfaceSpecification.setter(Builder::deviceIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceIndex").unmarshallLocationName("deviceIndex").build()}).build();
    private static final SdkField<List<String>> GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Groups").getter(LaunchTemplateInstanceNetworkInterfaceSpecification.getter(LaunchTemplateInstanceNetworkInterfaceSpecification::groups)).setter(LaunchTemplateInstanceNetworkInterfaceSpecification.setter(Builder::groups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupSet").unmarshallLocationName("groupSet").build(), ListTrait.builder().memberLocationName("groupId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").unmarshallLocationName("groupId").build()}).build()).build()}).build();
    private static final SdkField<String> INTERFACE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InterfaceType").getter(LaunchTemplateInstanceNetworkInterfaceSpecification.getter(LaunchTemplateInstanceNetworkInterfaceSpecification::interfaceType)).setter(LaunchTemplateInstanceNetworkInterfaceSpecification.setter(Builder::interfaceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InterfaceType").unmarshallLocationName("interfaceType").build()}).build();
    private static final SdkField<Integer> IPV6_ADDRESS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Ipv6AddressCount").getter(LaunchTemplateInstanceNetworkInterfaceSpecification.getter(LaunchTemplateInstanceNetworkInterfaceSpecification::ipv6AddressCount)).setter(LaunchTemplateInstanceNetworkInterfaceSpecification.setter(Builder::ipv6AddressCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6AddressCount").unmarshallLocationName("ipv6AddressCount").build()}).build();
    private static final SdkField<List<InstanceIpv6Address>> IPV6_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Ipv6Addresses").getter(LaunchTemplateInstanceNetworkInterfaceSpecification.getter(LaunchTemplateInstanceNetworkInterfaceSpecification::ipv6Addresses)).setter(LaunchTemplateInstanceNetworkInterfaceSpecification.setter(Builder::ipv6Addresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6AddressesSet").unmarshallLocationName("ipv6AddressesSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceIpv6Address::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInterfaceId").getter(LaunchTemplateInstanceNetworkInterfaceSpecification.getter(LaunchTemplateInstanceNetworkInterfaceSpecification::networkInterfaceId)).setter(LaunchTemplateInstanceNetworkInterfaceSpecification.setter(Builder::networkInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").unmarshallLocationName("networkInterfaceId").build()}).build();
    private static final SdkField<String> PRIVATE_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrivateIpAddress").getter(LaunchTemplateInstanceNetworkInterfaceSpecification.getter(LaunchTemplateInstanceNetworkInterfaceSpecification::privateIpAddress)).setter(LaunchTemplateInstanceNetworkInterfaceSpecification.setter(Builder::privateIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddress").unmarshallLocationName("privateIpAddress").build()}).build();
    private static final SdkField<List<PrivateIpAddressSpecification>> PRIVATE_IP_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PrivateIpAddresses").getter(LaunchTemplateInstanceNetworkInterfaceSpecification.getter(LaunchTemplateInstanceNetworkInterfaceSpecification::privateIpAddresses)).setter(LaunchTemplateInstanceNetworkInterfaceSpecification.setter(Builder::privateIpAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddressesSet").unmarshallLocationName("privateIpAddressesSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PrivateIpAddressSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Integer> SECONDARY_PRIVATE_IP_ADDRESS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SecondaryPrivateIpAddressCount").getter(LaunchTemplateInstanceNetworkInterfaceSpecification.getter(LaunchTemplateInstanceNetworkInterfaceSpecification::secondaryPrivateIpAddressCount)).setter(LaunchTemplateInstanceNetworkInterfaceSpecification.setter(Builder::secondaryPrivateIpAddressCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryPrivateIpAddressCount").unmarshallLocationName("secondaryPrivateIpAddressCount").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(LaunchTemplateInstanceNetworkInterfaceSpecification.getter(LaunchTemplateInstanceNetworkInterfaceSpecification::subnetId)).setter(LaunchTemplateInstanceNetworkInterfaceSpecification.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").unmarshallLocationName("subnetId").build()}).build();
    private static final SdkField<Integer> NETWORK_CARD_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NetworkCardIndex").getter(LaunchTemplateInstanceNetworkInterfaceSpecification.getter(LaunchTemplateInstanceNetworkInterfaceSpecification::networkCardIndex)).setter(LaunchTemplateInstanceNetworkInterfaceSpecification.setter(Builder::networkCardIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkCardIndex").unmarshallLocationName("networkCardIndex").build()}).build();
    private static final SdkField<List<Ipv4PrefixSpecificationResponse>> IPV4_PREFIXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Ipv4Prefixes").getter(LaunchTemplateInstanceNetworkInterfaceSpecification.getter(LaunchTemplateInstanceNetworkInterfaceSpecification::ipv4Prefixes)).setter(LaunchTemplateInstanceNetworkInterfaceSpecification.setter(Builder::ipv4Prefixes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv4PrefixSet").unmarshallLocationName("ipv4PrefixSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Ipv4PrefixSpecificationResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Integer> IPV4_PREFIX_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Ipv4PrefixCount").getter(LaunchTemplateInstanceNetworkInterfaceSpecification.getter(LaunchTemplateInstanceNetworkInterfaceSpecification::ipv4PrefixCount)).setter(LaunchTemplateInstanceNetworkInterfaceSpecification.setter(Builder::ipv4PrefixCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv4PrefixCount").unmarshallLocationName("ipv4PrefixCount").build()}).build();
    private static final SdkField<List<Ipv6PrefixSpecificationResponse>> IPV6_PREFIXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Ipv6Prefixes").getter(LaunchTemplateInstanceNetworkInterfaceSpecification.getter(LaunchTemplateInstanceNetworkInterfaceSpecification::ipv6Prefixes)).setter(LaunchTemplateInstanceNetworkInterfaceSpecification.setter(Builder::ipv6Prefixes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6PrefixSet").unmarshallLocationName("ipv6PrefixSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Ipv6PrefixSpecificationResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Integer> IPV6_PREFIX_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Ipv6PrefixCount").getter(LaunchTemplateInstanceNetworkInterfaceSpecification.getter(LaunchTemplateInstanceNetworkInterfaceSpecification::ipv6PrefixCount)).setter(LaunchTemplateInstanceNetworkInterfaceSpecification.setter(Builder::ipv6PrefixCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6PrefixCount").unmarshallLocationName("ipv6PrefixCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATE_CARRIER_IP_ADDRESS_FIELD, ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD, DELETE_ON_TERMINATION_FIELD, DESCRIPTION_FIELD, DEVICE_INDEX_FIELD, GROUPS_FIELD, INTERFACE_TYPE_FIELD, IPV6_ADDRESS_COUNT_FIELD, IPV6_ADDRESSES_FIELD, NETWORK_INTERFACE_ID_FIELD, PRIVATE_IP_ADDRESS_FIELD, PRIVATE_IP_ADDRESSES_FIELD, SECONDARY_PRIVATE_IP_ADDRESS_COUNT_FIELD, SUBNET_ID_FIELD, NETWORK_CARD_INDEX_FIELD, IPV4_PREFIXES_FIELD, IPV4_PREFIX_COUNT_FIELD, IPV6_PREFIXES_FIELD, IPV6_PREFIX_COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean associateCarrierIpAddress;
    private final Boolean associatePublicIpAddress;
    private final Boolean deleteOnTermination;
    private final String description;
    private final Integer deviceIndex;
    private final List<String> groups;
    private final String interfaceType;
    private final Integer ipv6AddressCount;
    private final List<InstanceIpv6Address> ipv6Addresses;
    private final String networkInterfaceId;
    private final String privateIpAddress;
    private final List<PrivateIpAddressSpecification> privateIpAddresses;
    private final Integer secondaryPrivateIpAddressCount;
    private final String subnetId;
    private final Integer networkCardIndex;
    private final List<Ipv4PrefixSpecificationResponse> ipv4Prefixes;
    private final Integer ipv4PrefixCount;
    private final List<Ipv6PrefixSpecificationResponse> ipv6Prefixes;
    private final Integer ipv6PrefixCount;

    private LaunchTemplateInstanceNetworkInterfaceSpecification(BuilderImpl builder) {
        this.associateCarrierIpAddress = builder.associateCarrierIpAddress;
        this.associatePublicIpAddress = builder.associatePublicIpAddress;
        this.deleteOnTermination = builder.deleteOnTermination;
        this.description = builder.description;
        this.deviceIndex = builder.deviceIndex;
        this.groups = builder.groups;
        this.interfaceType = builder.interfaceType;
        this.ipv6AddressCount = builder.ipv6AddressCount;
        this.ipv6Addresses = builder.ipv6Addresses;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.privateIpAddress = builder.privateIpAddress;
        this.privateIpAddresses = builder.privateIpAddresses;
        this.secondaryPrivateIpAddressCount = builder.secondaryPrivateIpAddressCount;
        this.subnetId = builder.subnetId;
        this.networkCardIndex = builder.networkCardIndex;
        this.ipv4Prefixes = builder.ipv4Prefixes;
        this.ipv4PrefixCount = builder.ipv4PrefixCount;
        this.ipv6Prefixes = builder.ipv6Prefixes;
        this.ipv6PrefixCount = builder.ipv6PrefixCount;
    }

    public final Boolean associateCarrierIpAddress() {
        return this.associateCarrierIpAddress;
    }

    public final Boolean associatePublicIpAddress() {
        return this.associatePublicIpAddress;
    }

    public final Boolean deleteOnTermination() {
        return this.deleteOnTermination;
    }

    public final String description() {
        return this.description;
    }

    public final Integer deviceIndex() {
        return this.deviceIndex;
    }

    public final boolean hasGroups() {
        return this.groups != null && !(this.groups instanceof SdkAutoConstructList);
    }

    public final List<String> groups() {
        return this.groups;
    }

    public final String interfaceType() {
        return this.interfaceType;
    }

    public final Integer ipv6AddressCount() {
        return this.ipv6AddressCount;
    }

    public final boolean hasIpv6Addresses() {
        return this.ipv6Addresses != null && !(this.ipv6Addresses instanceof SdkAutoConstructList);
    }

    public final List<InstanceIpv6Address> ipv6Addresses() {
        return this.ipv6Addresses;
    }

    public final String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public final String privateIpAddress() {
        return this.privateIpAddress;
    }

    public final boolean hasPrivateIpAddresses() {
        return this.privateIpAddresses != null && !(this.privateIpAddresses instanceof SdkAutoConstructList);
    }

    public final List<PrivateIpAddressSpecification> privateIpAddresses() {
        return this.privateIpAddresses;
    }

    public final Integer secondaryPrivateIpAddressCount() {
        return this.secondaryPrivateIpAddressCount;
    }

    public final String subnetId() {
        return this.subnetId;
    }

    public final Integer networkCardIndex() {
        return this.networkCardIndex;
    }

    public final boolean hasIpv4Prefixes() {
        return this.ipv4Prefixes != null && !(this.ipv4Prefixes instanceof SdkAutoConstructList);
    }

    public final List<Ipv4PrefixSpecificationResponse> ipv4Prefixes() {
        return this.ipv4Prefixes;
    }

    public final Integer ipv4PrefixCount() {
        return this.ipv4PrefixCount;
    }

    public final boolean hasIpv6Prefixes() {
        return this.ipv6Prefixes != null && !(this.ipv6Prefixes instanceof SdkAutoConstructList);
    }

    public final List<Ipv6PrefixSpecificationResponse> ipv6Prefixes() {
        return this.ipv6Prefixes;
    }

    public final Integer ipv6PrefixCount() {
        return this.ipv6PrefixCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.associateCarrierIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.associatePublicIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteOnTermination());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroups() ? this.groups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.interfaceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6AddressCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpv6Addresses() ? this.ipv6Addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrivateIpAddresses() ? this.privateIpAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.secondaryPrivateIpAddressCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkCardIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpv4Prefixes() ? this.ipv4Prefixes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv4PrefixCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpv6Prefixes() ? this.ipv6Prefixes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6PrefixCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchTemplateInstanceNetworkInterfaceSpecification)) {
            return false;
        }
        LaunchTemplateInstanceNetworkInterfaceSpecification other = (LaunchTemplateInstanceNetworkInterfaceSpecification)obj;
        return Objects.equals(this.associateCarrierIpAddress(), other.associateCarrierIpAddress()) && Objects.equals(this.associatePublicIpAddress(), other.associatePublicIpAddress()) && Objects.equals(this.deleteOnTermination(), other.deleteOnTermination()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.deviceIndex(), other.deviceIndex()) && this.hasGroups() == other.hasGroups() && Objects.equals(this.groups(), other.groups()) && Objects.equals(this.interfaceType(), other.interfaceType()) && Objects.equals(this.ipv6AddressCount(), other.ipv6AddressCount()) && this.hasIpv6Addresses() == other.hasIpv6Addresses() && Objects.equals(this.ipv6Addresses(), other.ipv6Addresses()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(this.privateIpAddress(), other.privateIpAddress()) && this.hasPrivateIpAddresses() == other.hasPrivateIpAddresses() && Objects.equals(this.privateIpAddresses(), other.privateIpAddresses()) && Objects.equals(this.secondaryPrivateIpAddressCount(), other.secondaryPrivateIpAddressCount()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.networkCardIndex(), other.networkCardIndex()) && this.hasIpv4Prefixes() == other.hasIpv4Prefixes() && Objects.equals(this.ipv4Prefixes(), other.ipv4Prefixes()) && Objects.equals(this.ipv4PrefixCount(), other.ipv4PrefixCount()) && this.hasIpv6Prefixes() == other.hasIpv6Prefixes() && Objects.equals(this.ipv6Prefixes(), other.ipv6Prefixes()) && Objects.equals(this.ipv6PrefixCount(), other.ipv6PrefixCount());
    }

    public final String toString() {
        return ToString.builder((String)"LaunchTemplateInstanceNetworkInterfaceSpecification").add("AssociateCarrierIpAddress", (Object)this.associateCarrierIpAddress()).add("AssociatePublicIpAddress", (Object)this.associatePublicIpAddress()).add("DeleteOnTermination", (Object)this.deleteOnTermination()).add("Description", (Object)this.description()).add("DeviceIndex", (Object)this.deviceIndex()).add("Groups", this.hasGroups() ? this.groups() : null).add("InterfaceType", (Object)this.interfaceType()).add("Ipv6AddressCount", (Object)this.ipv6AddressCount()).add("Ipv6Addresses", this.hasIpv6Addresses() ? this.ipv6Addresses() : null).add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("PrivateIpAddress", (Object)this.privateIpAddress()).add("PrivateIpAddresses", this.hasPrivateIpAddresses() ? this.privateIpAddresses() : null).add("SecondaryPrivateIpAddressCount", (Object)this.secondaryPrivateIpAddressCount()).add("SubnetId", (Object)this.subnetId()).add("NetworkCardIndex", (Object)this.networkCardIndex()).add("Ipv4Prefixes", this.hasIpv4Prefixes() ? this.ipv4Prefixes() : null).add("Ipv4PrefixCount", (Object)this.ipv4PrefixCount()).add("Ipv6Prefixes", this.hasIpv6Prefixes() ? this.ipv6Prefixes() : null).add("Ipv6PrefixCount", (Object)this.ipv6PrefixCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociateCarrierIpAddress": {
                return Optional.ofNullable(clazz.cast(this.associateCarrierIpAddress()));
            }
            case "AssociatePublicIpAddress": {
                return Optional.ofNullable(clazz.cast(this.associatePublicIpAddress()));
            }
            case "DeleteOnTermination": {
                return Optional.ofNullable(clazz.cast(this.deleteOnTermination()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DeviceIndex": {
                return Optional.ofNullable(clazz.cast(this.deviceIndex()));
            }
            case "Groups": {
                return Optional.ofNullable(clazz.cast(this.groups()));
            }
            case "InterfaceType": {
                return Optional.ofNullable(clazz.cast(this.interfaceType()));
            }
            case "Ipv6AddressCount": {
                return Optional.ofNullable(clazz.cast(this.ipv6AddressCount()));
            }
            case "Ipv6Addresses": {
                return Optional.ofNullable(clazz.cast(this.ipv6Addresses()));
            }
            case "NetworkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceId()));
            }
            case "PrivateIpAddress": {
                return Optional.ofNullable(clazz.cast(this.privateIpAddress()));
            }
            case "PrivateIpAddresses": {
                return Optional.ofNullable(clazz.cast(this.privateIpAddresses()));
            }
            case "SecondaryPrivateIpAddressCount": {
                return Optional.ofNullable(clazz.cast(this.secondaryPrivateIpAddressCount()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "NetworkCardIndex": {
                return Optional.ofNullable(clazz.cast(this.networkCardIndex()));
            }
            case "Ipv4Prefixes": {
                return Optional.ofNullable(clazz.cast(this.ipv4Prefixes()));
            }
            case "Ipv4PrefixCount": {
                return Optional.ofNullable(clazz.cast(this.ipv4PrefixCount()));
            }
            case "Ipv6Prefixes": {
                return Optional.ofNullable(clazz.cast(this.ipv6Prefixes()));
            }
            case "Ipv6PrefixCount": {
                return Optional.ofNullable(clazz.cast(this.ipv6PrefixCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LaunchTemplateInstanceNetworkInterfaceSpecification, T> g) {
        return obj -> g.apply((LaunchTemplateInstanceNetworkInterfaceSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean associateCarrierIpAddress;
        private Boolean associatePublicIpAddress;
        private Boolean deleteOnTermination;
        private String description;
        private Integer deviceIndex;
        private List<String> groups = DefaultSdkAutoConstructList.getInstance();
        private String interfaceType;
        private Integer ipv6AddressCount;
        private List<InstanceIpv6Address> ipv6Addresses = DefaultSdkAutoConstructList.getInstance();
        private String networkInterfaceId;
        private String privateIpAddress;
        private List<PrivateIpAddressSpecification> privateIpAddresses = DefaultSdkAutoConstructList.getInstance();
        private Integer secondaryPrivateIpAddressCount;
        private String subnetId;
        private Integer networkCardIndex;
        private List<Ipv4PrefixSpecificationResponse> ipv4Prefixes = DefaultSdkAutoConstructList.getInstance();
        private Integer ipv4PrefixCount;
        private List<Ipv6PrefixSpecificationResponse> ipv6Prefixes = DefaultSdkAutoConstructList.getInstance();
        private Integer ipv6PrefixCount;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchTemplateInstanceNetworkInterfaceSpecification model) {
            this.associateCarrierIpAddress(model.associateCarrierIpAddress);
            this.associatePublicIpAddress(model.associatePublicIpAddress);
            this.deleteOnTermination(model.deleteOnTermination);
            this.description(model.description);
            this.deviceIndex(model.deviceIndex);
            this.groups(model.groups);
            this.interfaceType(model.interfaceType);
            this.ipv6AddressCount(model.ipv6AddressCount);
            this.ipv6Addresses(model.ipv6Addresses);
            this.networkInterfaceId(model.networkInterfaceId);
            this.privateIpAddress(model.privateIpAddress);
            this.privateIpAddresses(model.privateIpAddresses);
            this.secondaryPrivateIpAddressCount(model.secondaryPrivateIpAddressCount);
            this.subnetId(model.subnetId);
            this.networkCardIndex(model.networkCardIndex);
            this.ipv4Prefixes(model.ipv4Prefixes);
            this.ipv4PrefixCount(model.ipv4PrefixCount);
            this.ipv6Prefixes(model.ipv6Prefixes);
            this.ipv6PrefixCount(model.ipv6PrefixCount);
        }

        public final Boolean getAssociateCarrierIpAddress() {
            return this.associateCarrierIpAddress;
        }

        public final void setAssociateCarrierIpAddress(Boolean associateCarrierIpAddress) {
            this.associateCarrierIpAddress = associateCarrierIpAddress;
        }

        @Override
        @Transient
        public final Builder associateCarrierIpAddress(Boolean associateCarrierIpAddress) {
            this.associateCarrierIpAddress = associateCarrierIpAddress;
            return this;
        }

        public final Boolean getAssociatePublicIpAddress() {
            return this.associatePublicIpAddress;
        }

        public final void setAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
        }

        @Override
        @Transient
        public final Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        public final Boolean getDeleteOnTermination() {
            return this.deleteOnTermination;
        }

        public final void setDeleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        @Override
        @Transient
        public final Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getDeviceIndex() {
            return this.deviceIndex;
        }

        public final void setDeviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
        }

        @Override
        @Transient
        public final Builder deviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
            return this;
        }

        public final Collection<String> getGroups() {
            if (this.groups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.groups;
        }

        public final void setGroups(Collection<String> groups) {
            this.groups = GroupIdStringListCopier.copy(groups);
        }

        @Override
        @Transient
        public final Builder groups(Collection<String> groups) {
            this.groups = GroupIdStringListCopier.copy(groups);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder groups(String ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        public final String getInterfaceType() {
            return this.interfaceType;
        }

        public final void setInterfaceType(String interfaceType) {
            this.interfaceType = interfaceType;
        }

        @Override
        @Transient
        public final Builder interfaceType(String interfaceType) {
            this.interfaceType = interfaceType;
            return this;
        }

        public final Integer getIpv6AddressCount() {
            return this.ipv6AddressCount;
        }

        public final void setIpv6AddressCount(Integer ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
        }

        @Override
        @Transient
        public final Builder ipv6AddressCount(Integer ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
            return this;
        }

        public final List<InstanceIpv6Address.Builder> getIpv6Addresses() {
            List<InstanceIpv6Address.Builder> result = InstanceIpv6AddressListCopier.copyToBuilder(this.ipv6Addresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpv6Addresses(Collection<InstanceIpv6Address.BuilderImpl> ipv6Addresses) {
            this.ipv6Addresses = InstanceIpv6AddressListCopier.copyFromBuilder(ipv6Addresses);
        }

        @Override
        @Transient
        public final Builder ipv6Addresses(Collection<InstanceIpv6Address> ipv6Addresses) {
            this.ipv6Addresses = InstanceIpv6AddressListCopier.copy(ipv6Addresses);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ipv6Addresses(InstanceIpv6Address ... ipv6Addresses) {
            this.ipv6Addresses(Arrays.asList(ipv6Addresses));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ipv6Addresses(Consumer<InstanceIpv6Address.Builder> ... ipv6Addresses) {
            this.ipv6Addresses(Stream.of(ipv6Addresses).map(c -> (InstanceIpv6Address)((InstanceIpv6Address.Builder)InstanceIpv6Address.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        @Transient
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final String getPrivateIpAddress() {
            return this.privateIpAddress;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        @Override
        @Transient
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final List<PrivateIpAddressSpecification.Builder> getPrivateIpAddresses() {
            List<PrivateIpAddressSpecification.Builder> result = PrivateIpAddressSpecificationListCopier.copyToBuilder(this.privateIpAddresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrivateIpAddresses(Collection<PrivateIpAddressSpecification.BuilderImpl> privateIpAddresses) {
            this.privateIpAddresses = PrivateIpAddressSpecificationListCopier.copyFromBuilder(privateIpAddresses);
        }

        @Override
        @Transient
        public final Builder privateIpAddresses(Collection<PrivateIpAddressSpecification> privateIpAddresses) {
            this.privateIpAddresses = PrivateIpAddressSpecificationListCopier.copy(privateIpAddresses);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder privateIpAddresses(PrivateIpAddressSpecification ... privateIpAddresses) {
            this.privateIpAddresses(Arrays.asList(privateIpAddresses));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder privateIpAddresses(Consumer<PrivateIpAddressSpecification.Builder> ... privateIpAddresses) {
            this.privateIpAddresses(Stream.of(privateIpAddresses).map(c -> (PrivateIpAddressSpecification)((PrivateIpAddressSpecification.Builder)PrivateIpAddressSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getSecondaryPrivateIpAddressCount() {
            return this.secondaryPrivateIpAddressCount;
        }

        public final void setSecondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
            this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
        }

        @Override
        @Transient
        public final Builder secondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
            this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
            return this;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        @Transient
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final Integer getNetworkCardIndex() {
            return this.networkCardIndex;
        }

        public final void setNetworkCardIndex(Integer networkCardIndex) {
            this.networkCardIndex = networkCardIndex;
        }

        @Override
        @Transient
        public final Builder networkCardIndex(Integer networkCardIndex) {
            this.networkCardIndex = networkCardIndex;
            return this;
        }

        public final List<Ipv4PrefixSpecificationResponse.Builder> getIpv4Prefixes() {
            List<Ipv4PrefixSpecificationResponse.Builder> result = Ipv4PrefixListResponseCopier.copyToBuilder(this.ipv4Prefixes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpv4Prefixes(Collection<Ipv4PrefixSpecificationResponse.BuilderImpl> ipv4Prefixes) {
            this.ipv4Prefixes = Ipv4PrefixListResponseCopier.copyFromBuilder(ipv4Prefixes);
        }

        @Override
        @Transient
        public final Builder ipv4Prefixes(Collection<Ipv4PrefixSpecificationResponse> ipv4Prefixes) {
            this.ipv4Prefixes = Ipv4PrefixListResponseCopier.copy(ipv4Prefixes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ipv4Prefixes(Ipv4PrefixSpecificationResponse ... ipv4Prefixes) {
            this.ipv4Prefixes(Arrays.asList(ipv4Prefixes));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ipv4Prefixes(Consumer<Ipv4PrefixSpecificationResponse.Builder> ... ipv4Prefixes) {
            this.ipv4Prefixes(Stream.of(ipv4Prefixes).map(c -> (Ipv4PrefixSpecificationResponse)((Ipv4PrefixSpecificationResponse.Builder)Ipv4PrefixSpecificationResponse.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getIpv4PrefixCount() {
            return this.ipv4PrefixCount;
        }

        public final void setIpv4PrefixCount(Integer ipv4PrefixCount) {
            this.ipv4PrefixCount = ipv4PrefixCount;
        }

        @Override
        @Transient
        public final Builder ipv4PrefixCount(Integer ipv4PrefixCount) {
            this.ipv4PrefixCount = ipv4PrefixCount;
            return this;
        }

        public final List<Ipv6PrefixSpecificationResponse.Builder> getIpv6Prefixes() {
            List<Ipv6PrefixSpecificationResponse.Builder> result = Ipv6PrefixListResponseCopier.copyToBuilder(this.ipv6Prefixes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpv6Prefixes(Collection<Ipv6PrefixSpecificationResponse.BuilderImpl> ipv6Prefixes) {
            this.ipv6Prefixes = Ipv6PrefixListResponseCopier.copyFromBuilder(ipv6Prefixes);
        }

        @Override
        @Transient
        public final Builder ipv6Prefixes(Collection<Ipv6PrefixSpecificationResponse> ipv6Prefixes) {
            this.ipv6Prefixes = Ipv6PrefixListResponseCopier.copy(ipv6Prefixes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ipv6Prefixes(Ipv6PrefixSpecificationResponse ... ipv6Prefixes) {
            this.ipv6Prefixes(Arrays.asList(ipv6Prefixes));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ipv6Prefixes(Consumer<Ipv6PrefixSpecificationResponse.Builder> ... ipv6Prefixes) {
            this.ipv6Prefixes(Stream.of(ipv6Prefixes).map(c -> (Ipv6PrefixSpecificationResponse)((Ipv6PrefixSpecificationResponse.Builder)Ipv6PrefixSpecificationResponse.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getIpv6PrefixCount() {
            return this.ipv6PrefixCount;
        }

        public final void setIpv6PrefixCount(Integer ipv6PrefixCount) {
            this.ipv6PrefixCount = ipv6PrefixCount;
        }

        @Override
        @Transient
        public final Builder ipv6PrefixCount(Integer ipv6PrefixCount) {
            this.ipv6PrefixCount = ipv6PrefixCount;
            return this;
        }

        public LaunchTemplateInstanceNetworkInterfaceSpecification build() {
            return new LaunchTemplateInstanceNetworkInterfaceSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LaunchTemplateInstanceNetworkInterfaceSpecification> {
        public Builder associateCarrierIpAddress(Boolean var1);

        public Builder associatePublicIpAddress(Boolean var1);

        public Builder deleteOnTermination(Boolean var1);

        public Builder description(String var1);

        public Builder deviceIndex(Integer var1);

        public Builder groups(Collection<String> var1);

        public Builder groups(String ... var1);

        public Builder interfaceType(String var1);

        public Builder ipv6AddressCount(Integer var1);

        public Builder ipv6Addresses(Collection<InstanceIpv6Address> var1);

        public Builder ipv6Addresses(InstanceIpv6Address ... var1);

        public Builder ipv6Addresses(Consumer<InstanceIpv6Address.Builder> ... var1);

        public Builder networkInterfaceId(String var1);

        public Builder privateIpAddress(String var1);

        public Builder privateIpAddresses(Collection<PrivateIpAddressSpecification> var1);

        public Builder privateIpAddresses(PrivateIpAddressSpecification ... var1);

        public Builder privateIpAddresses(Consumer<PrivateIpAddressSpecification.Builder> ... var1);

        public Builder secondaryPrivateIpAddressCount(Integer var1);

        public Builder subnetId(String var1);

        public Builder networkCardIndex(Integer var1);

        public Builder ipv4Prefixes(Collection<Ipv4PrefixSpecificationResponse> var1);

        public Builder ipv4Prefixes(Ipv4PrefixSpecificationResponse ... var1);

        public Builder ipv4Prefixes(Consumer<Ipv4PrefixSpecificationResponse.Builder> ... var1);

        public Builder ipv4PrefixCount(Integer var1);

        public Builder ipv6Prefixes(Collection<Ipv6PrefixSpecificationResponse> var1);

        public Builder ipv6Prefixes(Ipv6PrefixSpecificationResponse ... var1);

        public Builder ipv6Prefixes(Consumer<Ipv6PrefixSpecificationResponse.Builder> ... var1);

        public Builder ipv6PrefixCount(Integer var1);
    }
}

