/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.HistoryRecord;
import software.amazon.awssdk.services.ec2.model.HistoryRecordsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSpotFleetRequestHistoryResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeSpotFleetRequestHistoryResponse> {
    private static final SdkField<List<HistoryRecord>> HISTORY_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HistoryRecords").getter(DescribeSpotFleetRequestHistoryResponse.getter(DescribeSpotFleetRequestHistoryResponse::historyRecords)).setter(DescribeSpotFleetRequestHistoryResponse.setter(Builder::historyRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HistoryRecordSet").unmarshallLocationName("historyRecordSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HistoryRecord::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Instant> LAST_EVALUATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastEvaluatedTime").getter(DescribeSpotFleetRequestHistoryResponse.getter(DescribeSpotFleetRequestHistoryResponse::lastEvaluatedTime)).setter(DescribeSpotFleetRequestHistoryResponse.setter(Builder::lastEvaluatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastEvaluatedTime").unmarshallLocationName("lastEvaluatedTime").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeSpotFleetRequestHistoryResponse.getter(DescribeSpotFleetRequestHistoryResponse::nextToken)).setter(DescribeSpotFleetRequestHistoryResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final SdkField<String> SPOT_FLEET_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SpotFleetRequestId").getter(DescribeSpotFleetRequestHistoryResponse.getter(DescribeSpotFleetRequestHistoryResponse::spotFleetRequestId)).setter(DescribeSpotFleetRequestHistoryResponse.setter(Builder::spotFleetRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotFleetRequestId").unmarshallLocationName("spotFleetRequestId").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(DescribeSpotFleetRequestHistoryResponse.getter(DescribeSpotFleetRequestHistoryResponse::startTime)).setter(DescribeSpotFleetRequestHistoryResponse.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").unmarshallLocationName("startTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HISTORY_RECORDS_FIELD, LAST_EVALUATED_TIME_FIELD, NEXT_TOKEN_FIELD, SPOT_FLEET_REQUEST_ID_FIELD, START_TIME_FIELD));
    private final List<HistoryRecord> historyRecords;
    private final Instant lastEvaluatedTime;
    private final String nextToken;
    private final String spotFleetRequestId;
    private final Instant startTime;

    private DescribeSpotFleetRequestHistoryResponse(BuilderImpl builder) {
        super(builder);
        this.historyRecords = builder.historyRecords;
        this.lastEvaluatedTime = builder.lastEvaluatedTime;
        this.nextToken = builder.nextToken;
        this.spotFleetRequestId = builder.spotFleetRequestId;
        this.startTime = builder.startTime;
    }

    public final boolean hasHistoryRecords() {
        return this.historyRecords != null && !(this.historyRecords instanceof SdkAutoConstructList);
    }

    public final List<HistoryRecord> historyRecords() {
        return this.historyRecords;
    }

    public final Instant lastEvaluatedTime() {
        return this.lastEvaluatedTime;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String spotFleetRequestId() {
        return this.spotFleetRequestId;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHistoryRecords() ? this.historyRecords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastEvaluatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.spotFleetRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSpotFleetRequestHistoryResponse)) {
            return false;
        }
        DescribeSpotFleetRequestHistoryResponse other = (DescribeSpotFleetRequestHistoryResponse)((Object)obj);
        return this.hasHistoryRecords() == other.hasHistoryRecords() && Objects.equals(this.historyRecords(), other.historyRecords()) && Objects.equals(this.lastEvaluatedTime(), other.lastEvaluatedTime()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.spotFleetRequestId(), other.spotFleetRequestId()) && Objects.equals(this.startTime(), other.startTime());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeSpotFleetRequestHistoryResponse").add("HistoryRecords", this.hasHistoryRecords() ? this.historyRecords() : null).add("LastEvaluatedTime", (Object)this.lastEvaluatedTime()).add("NextToken", (Object)this.nextToken()).add("SpotFleetRequestId", (Object)this.spotFleetRequestId()).add("StartTime", (Object)this.startTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HistoryRecords": {
                return Optional.ofNullable(clazz.cast(this.historyRecords()));
            }
            case "LastEvaluatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastEvaluatedTime()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "SpotFleetRequestId": {
                return Optional.ofNullable(clazz.cast(this.spotFleetRequestId()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSpotFleetRequestHistoryResponse, T> g) {
        return obj -> g.apply((DescribeSpotFleetRequestHistoryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<HistoryRecord> historyRecords = DefaultSdkAutoConstructList.getInstance();
        private Instant lastEvaluatedTime;
        private String nextToken;
        private String spotFleetRequestId;
        private Instant startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSpotFleetRequestHistoryResponse model) {
            super(model);
            this.historyRecords(model.historyRecords);
            this.lastEvaluatedTime(model.lastEvaluatedTime);
            this.nextToken(model.nextToken);
            this.spotFleetRequestId(model.spotFleetRequestId);
            this.startTime(model.startTime);
        }

        public final List<HistoryRecord.Builder> getHistoryRecords() {
            List<HistoryRecord.Builder> result = HistoryRecordsCopier.copyToBuilder(this.historyRecords);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHistoryRecords(Collection<HistoryRecord.BuilderImpl> historyRecords) {
            this.historyRecords = HistoryRecordsCopier.copyFromBuilder(historyRecords);
        }

        @Override
        @Transient
        public final Builder historyRecords(Collection<HistoryRecord> historyRecords) {
            this.historyRecords = HistoryRecordsCopier.copy(historyRecords);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder historyRecords(HistoryRecord ... historyRecords) {
            this.historyRecords(Arrays.asList(historyRecords));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder historyRecords(Consumer<HistoryRecord.Builder> ... historyRecords) {
            this.historyRecords(Stream.of(historyRecords).map(c -> (HistoryRecord)((HistoryRecord.Builder)HistoryRecord.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getLastEvaluatedTime() {
            return this.lastEvaluatedTime;
        }

        public final void setLastEvaluatedTime(Instant lastEvaluatedTime) {
            this.lastEvaluatedTime = lastEvaluatedTime;
        }

        @Override
        @Transient
        public final Builder lastEvaluatedTime(Instant lastEvaluatedTime) {
            this.lastEvaluatedTime = lastEvaluatedTime;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getSpotFleetRequestId() {
            return this.spotFleetRequestId;
        }

        public final void setSpotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
        }

        @Override
        @Transient
        public final Builder spotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        @Transient
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        @Override
        public DescribeSpotFleetRequestHistoryResponse build() {
            return new DescribeSpotFleetRequestHistoryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSpotFleetRequestHistoryResponse> {
        public Builder historyRecords(Collection<HistoryRecord> var1);

        public Builder historyRecords(HistoryRecord ... var1);

        public Builder historyRecords(Consumer<HistoryRecord.Builder> ... var1);

        public Builder lastEvaluatedTime(Instant var1);

        public Builder nextToken(String var1);

        public Builder spotFleetRequestId(String var1);

        public Builder startTime(Instant var1);
    }
}

