/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.BatchState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CancelSpotFleetRequestsSuccessItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CancelSpotFleetRequestsSuccessItem> {
    private static final SdkField<String> CURRENT_SPOT_FLEET_REQUEST_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentSpotFleetRequestState").getter(CancelSpotFleetRequestsSuccessItem.getter(CancelSpotFleetRequestsSuccessItem::currentSpotFleetRequestStateAsString)).setter(CancelSpotFleetRequestsSuccessItem.setter(Builder::currentSpotFleetRequestState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentSpotFleetRequestState").unmarshallLocationName("currentSpotFleetRequestState").build()}).build();
    private static final SdkField<String> PREVIOUS_SPOT_FLEET_REQUEST_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreviousSpotFleetRequestState").getter(CancelSpotFleetRequestsSuccessItem.getter(CancelSpotFleetRequestsSuccessItem::previousSpotFleetRequestStateAsString)).setter(CancelSpotFleetRequestsSuccessItem.setter(Builder::previousSpotFleetRequestState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousSpotFleetRequestState").unmarshallLocationName("previousSpotFleetRequestState").build()}).build();
    private static final SdkField<String> SPOT_FLEET_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SpotFleetRequestId").getter(CancelSpotFleetRequestsSuccessItem.getter(CancelSpotFleetRequestsSuccessItem::spotFleetRequestId)).setter(CancelSpotFleetRequestsSuccessItem.setter(Builder::spotFleetRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotFleetRequestId").unmarshallLocationName("spotFleetRequestId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENT_SPOT_FLEET_REQUEST_STATE_FIELD, PREVIOUS_SPOT_FLEET_REQUEST_STATE_FIELD, SPOT_FLEET_REQUEST_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String currentSpotFleetRequestState;
    private final String previousSpotFleetRequestState;
    private final String spotFleetRequestId;

    private CancelSpotFleetRequestsSuccessItem(BuilderImpl builder) {
        this.currentSpotFleetRequestState = builder.currentSpotFleetRequestState;
        this.previousSpotFleetRequestState = builder.previousSpotFleetRequestState;
        this.spotFleetRequestId = builder.spotFleetRequestId;
    }

    public final BatchState currentSpotFleetRequestState() {
        return BatchState.fromValue(this.currentSpotFleetRequestState);
    }

    public final String currentSpotFleetRequestStateAsString() {
        return this.currentSpotFleetRequestState;
    }

    public final BatchState previousSpotFleetRequestState() {
        return BatchState.fromValue(this.previousSpotFleetRequestState);
    }

    public final String previousSpotFleetRequestStateAsString() {
        return this.previousSpotFleetRequestState;
    }

    public final String spotFleetRequestId() {
        return this.spotFleetRequestId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.currentSpotFleetRequestStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.previousSpotFleetRequestStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.spotFleetRequestId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelSpotFleetRequestsSuccessItem)) {
            return false;
        }
        CancelSpotFleetRequestsSuccessItem other = (CancelSpotFleetRequestsSuccessItem)obj;
        return Objects.equals(this.currentSpotFleetRequestStateAsString(), other.currentSpotFleetRequestStateAsString()) && Objects.equals(this.previousSpotFleetRequestStateAsString(), other.previousSpotFleetRequestStateAsString()) && Objects.equals(this.spotFleetRequestId(), other.spotFleetRequestId());
    }

    public final String toString() {
        return ToString.builder((String)"CancelSpotFleetRequestsSuccessItem").add("CurrentSpotFleetRequestState", (Object)this.currentSpotFleetRequestStateAsString()).add("PreviousSpotFleetRequestState", (Object)this.previousSpotFleetRequestStateAsString()).add("SpotFleetRequestId", (Object)this.spotFleetRequestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CurrentSpotFleetRequestState": {
                return Optional.ofNullable(clazz.cast(this.currentSpotFleetRequestStateAsString()));
            }
            case "PreviousSpotFleetRequestState": {
                return Optional.ofNullable(clazz.cast(this.previousSpotFleetRequestStateAsString()));
            }
            case "SpotFleetRequestId": {
                return Optional.ofNullable(clazz.cast(this.spotFleetRequestId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CancelSpotFleetRequestsSuccessItem, T> g) {
        return obj -> g.apply((CancelSpotFleetRequestsSuccessItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String currentSpotFleetRequestState;
        private String previousSpotFleetRequestState;
        private String spotFleetRequestId;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelSpotFleetRequestsSuccessItem model) {
            this.currentSpotFleetRequestState(model.currentSpotFleetRequestState);
            this.previousSpotFleetRequestState(model.previousSpotFleetRequestState);
            this.spotFleetRequestId(model.spotFleetRequestId);
        }

        public final String getCurrentSpotFleetRequestState() {
            return this.currentSpotFleetRequestState;
        }

        public final void setCurrentSpotFleetRequestState(String currentSpotFleetRequestState) {
            this.currentSpotFleetRequestState = currentSpotFleetRequestState;
        }

        @Override
        @Transient
        public final Builder currentSpotFleetRequestState(String currentSpotFleetRequestState) {
            this.currentSpotFleetRequestState = currentSpotFleetRequestState;
            return this;
        }

        @Override
        @Transient
        public final Builder currentSpotFleetRequestState(BatchState currentSpotFleetRequestState) {
            this.currentSpotFleetRequestState(currentSpotFleetRequestState == null ? null : currentSpotFleetRequestState.toString());
            return this;
        }

        public final String getPreviousSpotFleetRequestState() {
            return this.previousSpotFleetRequestState;
        }

        public final void setPreviousSpotFleetRequestState(String previousSpotFleetRequestState) {
            this.previousSpotFleetRequestState = previousSpotFleetRequestState;
        }

        @Override
        @Transient
        public final Builder previousSpotFleetRequestState(String previousSpotFleetRequestState) {
            this.previousSpotFleetRequestState = previousSpotFleetRequestState;
            return this;
        }

        @Override
        @Transient
        public final Builder previousSpotFleetRequestState(BatchState previousSpotFleetRequestState) {
            this.previousSpotFleetRequestState(previousSpotFleetRequestState == null ? null : previousSpotFleetRequestState.toString());
            return this;
        }

        public final String getSpotFleetRequestId() {
            return this.spotFleetRequestId;
        }

        public final void setSpotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
        }

        @Override
        @Transient
        public final Builder spotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
            return this;
        }

        public CancelSpotFleetRequestsSuccessItem build() {
            return new CancelSpotFleetRequestsSuccessItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CancelSpotFleetRequestsSuccessItem> {
        public Builder currentSpotFleetRequestState(String var1);

        public Builder currentSpotFleetRequestState(BatchState var1);

        public Builder previousSpotFleetRequestState(String var1);

        public Builder previousSpotFleetRequestState(BatchState var1);

        public Builder spotFleetRequestId(String var1);
    }
}

