/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.DestinationFileFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DestinationOptionsRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DestinationOptionsRequest> {
    private static final SdkField<String> FILE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileFormat").getter(DestinationOptionsRequest.getter(DestinationOptionsRequest::fileFormatAsString)).setter(DestinationOptionsRequest.setter(Builder::fileFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileFormat").unmarshallLocationName("FileFormat").build()}).build();
    private static final SdkField<Boolean> HIVE_COMPATIBLE_PARTITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("HiveCompatiblePartitions").getter(DestinationOptionsRequest.getter(DestinationOptionsRequest::hiveCompatiblePartitions)).setter(DestinationOptionsRequest.setter(Builder::hiveCompatiblePartitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HiveCompatiblePartitions").unmarshallLocationName("HiveCompatiblePartitions").build()}).build();
    private static final SdkField<Boolean> PER_HOUR_PARTITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PerHourPartition").getter(DestinationOptionsRequest.getter(DestinationOptionsRequest::perHourPartition)).setter(DestinationOptionsRequest.setter(Builder::perHourPartition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerHourPartition").unmarshallLocationName("PerHourPartition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_FORMAT_FIELD, HIVE_COMPATIBLE_PARTITIONS_FIELD, PER_HOUR_PARTITION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String fileFormat;
    private final Boolean hiveCompatiblePartitions;
    private final Boolean perHourPartition;

    private DestinationOptionsRequest(BuilderImpl builder) {
        this.fileFormat = builder.fileFormat;
        this.hiveCompatiblePartitions = builder.hiveCompatiblePartitions;
        this.perHourPartition = builder.perHourPartition;
    }

    public final DestinationFileFormat fileFormat() {
        return DestinationFileFormat.fromValue(this.fileFormat);
    }

    public final String fileFormatAsString() {
        return this.fileFormat;
    }

    public final Boolean hiveCompatiblePartitions() {
        return this.hiveCompatiblePartitions;
    }

    public final Boolean perHourPartition() {
        return this.perHourPartition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fileFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hiveCompatiblePartitions());
        hashCode = 31 * hashCode + Objects.hashCode(this.perHourPartition());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DestinationOptionsRequest)) {
            return false;
        }
        DestinationOptionsRequest other = (DestinationOptionsRequest)obj;
        return Objects.equals(this.fileFormatAsString(), other.fileFormatAsString()) && Objects.equals(this.hiveCompatiblePartitions(), other.hiveCompatiblePartitions()) && Objects.equals(this.perHourPartition(), other.perHourPartition());
    }

    public final String toString() {
        return ToString.builder((String)"DestinationOptionsRequest").add("FileFormat", (Object)this.fileFormatAsString()).add("HiveCompatiblePartitions", (Object)this.hiveCompatiblePartitions()).add("PerHourPartition", (Object)this.perHourPartition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FileFormat": {
                return Optional.ofNullable(clazz.cast(this.fileFormatAsString()));
            }
            case "HiveCompatiblePartitions": {
                return Optional.ofNullable(clazz.cast(this.hiveCompatiblePartitions()));
            }
            case "PerHourPartition": {
                return Optional.ofNullable(clazz.cast(this.perHourPartition()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DestinationOptionsRequest, T> g) {
        return obj -> g.apply((DestinationOptionsRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fileFormat;
        private Boolean hiveCompatiblePartitions;
        private Boolean perHourPartition;

        private BuilderImpl() {
        }

        private BuilderImpl(DestinationOptionsRequest model) {
            this.fileFormat(model.fileFormat);
            this.hiveCompatiblePartitions(model.hiveCompatiblePartitions);
            this.perHourPartition(model.perHourPartition);
        }

        public final String getFileFormat() {
            return this.fileFormat;
        }

        public final void setFileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
        }

        @Override
        @Transient
        public final Builder fileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
            return this;
        }

        @Override
        @Transient
        public final Builder fileFormat(DestinationFileFormat fileFormat) {
            this.fileFormat(fileFormat == null ? null : fileFormat.toString());
            return this;
        }

        public final Boolean getHiveCompatiblePartitions() {
            return this.hiveCompatiblePartitions;
        }

        public final void setHiveCompatiblePartitions(Boolean hiveCompatiblePartitions) {
            this.hiveCompatiblePartitions = hiveCompatiblePartitions;
        }

        @Override
        @Transient
        public final Builder hiveCompatiblePartitions(Boolean hiveCompatiblePartitions) {
            this.hiveCompatiblePartitions = hiveCompatiblePartitions;
            return this;
        }

        public final Boolean getPerHourPartition() {
            return this.perHourPartition;
        }

        public final void setPerHourPartition(Boolean perHourPartition) {
            this.perHourPartition = perHourPartition;
        }

        @Override
        @Transient
        public final Builder perHourPartition(Boolean perHourPartition) {
            this.perHourPartition = perHourPartition;
            return this;
        }

        public DestinationOptionsRequest build() {
            return new DestinationOptionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DestinationOptionsRequest> {
        public Builder fileFormat(String var1);

        public Builder fileFormat(DestinationFileFormat var1);

        public Builder hiveCompatiblePartitions(Boolean var1);

        public Builder perHourPartition(Boolean var1);
    }
}

