/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayConnectPeersRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayConnectPeersResponse;
import software.amazon.awssdk.services.ec2.model.TransitGatewayConnectPeer;

public class DescribeTransitGatewayConnectPeersIterable
implements SdkIterable<DescribeTransitGatewayConnectPeersResponse> {
    private final Ec2Client client;
    private final DescribeTransitGatewayConnectPeersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeTransitGatewayConnectPeersIterable(Ec2Client client, DescribeTransitGatewayConnectPeersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeTransitGatewayConnectPeersResponseFetcher();
    }

    public Iterator<DescribeTransitGatewayConnectPeersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TransitGatewayConnectPeer> transitGatewayConnectPeers() {
        Function<DescribeTransitGatewayConnectPeersResponse, Iterator> getIterator = response -> {
            if (response != null && response.transitGatewayConnectPeers() != null) {
                return response.transitGatewayConnectPeers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeTransitGatewayConnectPeersResponseFetcher
    implements SyncPageFetcher<DescribeTransitGatewayConnectPeersResponse> {
        private DescribeTransitGatewayConnectPeersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTransitGatewayConnectPeersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeTransitGatewayConnectPeersResponse nextPage(DescribeTransitGatewayConnectPeersResponse previousPage) {
            if (previousPage == null) {
                return DescribeTransitGatewayConnectPeersIterable.this.client.describeTransitGatewayConnectPeers(DescribeTransitGatewayConnectPeersIterable.this.firstRequest);
            }
            return DescribeTransitGatewayConnectPeersIterable.this.client.describeTransitGatewayConnectPeers((DescribeTransitGatewayConnectPeersRequest)((Object)DescribeTransitGatewayConnectPeersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

