/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.InstanceEventWindowTimeRangeRequest;
import software.amazon.awssdk.services.ec2.model.InstanceEventWindowTimeRangeRequestSetCopier;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateInstanceEventWindowRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateInstanceEventWindowRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateInstanceEventWindowRequest.getter(CreateInstanceEventWindowRequest::name)).setter(CreateInstanceEventWindowRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").unmarshallLocationName("Name").build()}).build();
    private static final SdkField<List<InstanceEventWindowTimeRangeRequest>> TIME_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TimeRanges").getter(CreateInstanceEventWindowRequest.getter(CreateInstanceEventWindowRequest::timeRanges)).setter(CreateInstanceEventWindowRequest.setter(Builder::timeRanges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeRange").unmarshallLocationName("TimeRange").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceEventWindowTimeRangeRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CRON_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CronExpression").getter(CreateInstanceEventWindowRequest.getter(CreateInstanceEventWindowRequest::cronExpression)).setter(CreateInstanceEventWindowRequest.setter(Builder::cronExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CronExpression").unmarshallLocationName("CronExpression").build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(CreateInstanceEventWindowRequest.getter(CreateInstanceEventWindowRequest::tagSpecifications)).setter(CreateInstanceEventWindowRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TIME_RANGES_FIELD, CRON_EXPRESSION_FIELD, TAG_SPECIFICATIONS_FIELD));
    private final String name;
    private final List<InstanceEventWindowTimeRangeRequest> timeRanges;
    private final String cronExpression;
    private final List<TagSpecification> tagSpecifications;

    private CreateInstanceEventWindowRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.timeRanges = builder.timeRanges;
        this.cronExpression = builder.cronExpression;
        this.tagSpecifications = builder.tagSpecifications;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasTimeRanges() {
        return this.timeRanges != null && !(this.timeRanges instanceof SdkAutoConstructList);
    }

    public final List<InstanceEventWindowTimeRangeRequest> timeRanges() {
        return this.timeRanges;
    }

    public final String cronExpression() {
        return this.cronExpression;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTimeRanges() ? this.timeRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.cronExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInstanceEventWindowRequest)) {
            return false;
        }
        CreateInstanceEventWindowRequest other = (CreateInstanceEventWindowRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && this.hasTimeRanges() == other.hasTimeRanges() && Objects.equals(this.timeRanges(), other.timeRanges()) && Objects.equals(this.cronExpression(), other.cronExpression()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications());
    }

    public final String toString() {
        return ToString.builder((String)"CreateInstanceEventWindowRequest").add("Name", (Object)this.name()).add("TimeRanges", this.hasTimeRanges() ? this.timeRanges() : null).add("CronExpression", (Object)this.cronExpression()).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "TimeRanges": {
                return Optional.ofNullable(clazz.cast(this.timeRanges()));
            }
            case "CronExpression": {
                return Optional.ofNullable(clazz.cast(this.cronExpression()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateInstanceEventWindowRequest, T> g) {
        return obj -> g.apply((CreateInstanceEventWindowRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String name;
        private List<InstanceEventWindowTimeRangeRequest> timeRanges = DefaultSdkAutoConstructList.getInstance();
        private String cronExpression;
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInstanceEventWindowRequest model) {
            super(model);
            this.name(model.name);
            this.timeRanges(model.timeRanges);
            this.cronExpression(model.cronExpression);
            this.tagSpecifications(model.tagSpecifications);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final List<InstanceEventWindowTimeRangeRequest.Builder> getTimeRanges() {
            List<InstanceEventWindowTimeRangeRequest.Builder> result = InstanceEventWindowTimeRangeRequestSetCopier.copyToBuilder(this.timeRanges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder timeRanges(Collection<InstanceEventWindowTimeRangeRequest> timeRanges) {
            this.timeRanges = InstanceEventWindowTimeRangeRequestSetCopier.copy(timeRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timeRanges(InstanceEventWindowTimeRangeRequest ... timeRanges) {
            this.timeRanges(Arrays.asList(timeRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timeRanges(Consumer<InstanceEventWindowTimeRangeRequest.Builder> ... timeRanges) {
            this.timeRanges(Stream.of(timeRanges).map(c -> (InstanceEventWindowTimeRangeRequest)((InstanceEventWindowTimeRangeRequest.Builder)InstanceEventWindowTimeRangeRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTimeRanges(Collection<InstanceEventWindowTimeRangeRequest.BuilderImpl> timeRanges) {
            this.timeRanges = InstanceEventWindowTimeRangeRequestSetCopier.copyFromBuilder(timeRanges);
        }

        public final String getCronExpression() {
            return this.cronExpression;
        }

        @Override
        public final Builder cronExpression(String cronExpression) {
            this.cronExpression = cronExpression;
            return this;
        }

        public final void setCronExpression(String cronExpression) {
            this.cronExpression = cronExpression;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateInstanceEventWindowRequest build() {
            return new CreateInstanceEventWindowRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateInstanceEventWindowRequest> {
        public Builder name(String var1);

        public Builder timeRanges(Collection<InstanceEventWindowTimeRangeRequest> var1);

        public Builder timeRanges(InstanceEventWindowTimeRangeRequest ... var1);

        public Builder timeRanges(Consumer<InstanceEventWindowTimeRangeRequest.Builder> ... var1);

        public Builder cronExpression(String var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

