/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PciId
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PciId> {
    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceId").getter(PciId.getter(PciId::deviceId)).setter(PciId.setter(Builder::deviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceId").unmarshallLocationName("DeviceId").build()}).build();
    private static final SdkField<String> VENDOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VendorId").getter(PciId.getter(PciId::vendorId)).setter(PciId.setter(Builder::vendorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VendorId").unmarshallLocationName("VendorId").build()}).build();
    private static final SdkField<String> SUBSYSTEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubsystemId").getter(PciId.getter(PciId::subsystemId)).setter(PciId.setter(Builder::subsystemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubsystemId").unmarshallLocationName("SubsystemId").build()}).build();
    private static final SdkField<String> SUBSYSTEM_VENDOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubsystemVendorId").getter(PciId.getter(PciId::subsystemVendorId)).setter(PciId.setter(Builder::subsystemVendorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubsystemVendorId").unmarshallLocationName("SubsystemVendorId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_ID_FIELD, VENDOR_ID_FIELD, SUBSYSTEM_ID_FIELD, SUBSYSTEM_VENDOR_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String deviceId;
    private final String vendorId;
    private final String subsystemId;
    private final String subsystemVendorId;

    private PciId(BuilderImpl builder) {
        this.deviceId = builder.deviceId;
        this.vendorId = builder.vendorId;
        this.subsystemId = builder.subsystemId;
        this.subsystemVendorId = builder.subsystemVendorId;
    }

    public final String deviceId() {
        return this.deviceId;
    }

    public final String vendorId() {
        return this.vendorId;
    }

    public final String subsystemId() {
        return this.subsystemId;
    }

    public final String subsystemVendorId() {
        return this.subsystemVendorId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vendorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subsystemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subsystemVendorId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PciId)) {
            return false;
        }
        PciId other = (PciId)obj;
        return Objects.equals(this.deviceId(), other.deviceId()) && Objects.equals(this.vendorId(), other.vendorId()) && Objects.equals(this.subsystemId(), other.subsystemId()) && Objects.equals(this.subsystemVendorId(), other.subsystemVendorId());
    }

    public final String toString() {
        return ToString.builder((String)"PciId").add("DeviceId", (Object)this.deviceId()).add("VendorId", (Object)this.vendorId()).add("SubsystemId", (Object)this.subsystemId()).add("SubsystemVendorId", (Object)this.subsystemVendorId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceId": {
                return Optional.ofNullable(clazz.cast(this.deviceId()));
            }
            case "VendorId": {
                return Optional.ofNullable(clazz.cast(this.vendorId()));
            }
            case "SubsystemId": {
                return Optional.ofNullable(clazz.cast(this.subsystemId()));
            }
            case "SubsystemVendorId": {
                return Optional.ofNullable(clazz.cast(this.subsystemVendorId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PciId, T> g) {
        return obj -> g.apply((PciId)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deviceId;
        private String vendorId;
        private String subsystemId;
        private String subsystemVendorId;

        private BuilderImpl() {
        }

        private BuilderImpl(PciId model) {
            this.deviceId(model.deviceId);
            this.vendorId(model.vendorId);
            this.subsystemId(model.subsystemId);
            this.subsystemVendorId(model.subsystemVendorId);
        }

        public final String getDeviceId() {
            return this.deviceId;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        @Override
        @Transient
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final String getVendorId() {
            return this.vendorId;
        }

        public final void setVendorId(String vendorId) {
            this.vendorId = vendorId;
        }

        @Override
        @Transient
        public final Builder vendorId(String vendorId) {
            this.vendorId = vendorId;
            return this;
        }

        public final String getSubsystemId() {
            return this.subsystemId;
        }

        public final void setSubsystemId(String subsystemId) {
            this.subsystemId = subsystemId;
        }

        @Override
        @Transient
        public final Builder subsystemId(String subsystemId) {
            this.subsystemId = subsystemId;
            return this;
        }

        public final String getSubsystemVendorId() {
            return this.subsystemVendorId;
        }

        public final void setSubsystemVendorId(String subsystemVendorId) {
            this.subsystemVendorId = subsystemVendorId;
        }

        @Override
        @Transient
        public final Builder subsystemVendorId(String subsystemVendorId) {
            this.subsystemVendorId = subsystemVendorId;
            return this;
        }

        public PciId build() {
            return new PciId(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PciId> {
        public Builder deviceId(String var1);

        public Builder vendorId(String var1);

        public Builder subsystemId(String var1);

        public Builder subsystemVendorId(String var1);
    }
}

