/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.ScheduledInstanceRecurrence;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScheduledInstanceAvailability
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScheduledInstanceAvailability> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(ScheduledInstanceAvailability.getter(ScheduledInstanceAvailability::availabilityZone)).setter(ScheduledInstanceAvailability.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").unmarshallLocationName("availabilityZone").build()}).build();
    private static final SdkField<Integer> AVAILABLE_INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AvailableInstanceCount").getter(ScheduledInstanceAvailability.getter(ScheduledInstanceAvailability::availableInstanceCount)).setter(ScheduledInstanceAvailability.setter(Builder::availableInstanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableInstanceCount").unmarshallLocationName("availableInstanceCount").build()}).build();
    private static final SdkField<Instant> FIRST_SLOT_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("FirstSlotStartTime").getter(ScheduledInstanceAvailability.getter(ScheduledInstanceAvailability::firstSlotStartTime)).setter(ScheduledInstanceAvailability.setter(Builder::firstSlotStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstSlotStartTime").unmarshallLocationName("firstSlotStartTime").build()}).build();
    private static final SdkField<String> HOURLY_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HourlyPrice").getter(ScheduledInstanceAvailability.getter(ScheduledInstanceAvailability::hourlyPrice)).setter(ScheduledInstanceAvailability.setter(Builder::hourlyPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HourlyPrice").unmarshallLocationName("hourlyPrice").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(ScheduledInstanceAvailability.getter(ScheduledInstanceAvailability::instanceType)).setter(ScheduledInstanceAvailability.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").unmarshallLocationName("instanceType").build()}).build();
    private static final SdkField<Integer> MAX_TERM_DURATION_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxTermDurationInDays").getter(ScheduledInstanceAvailability.getter(ScheduledInstanceAvailability::maxTermDurationInDays)).setter(ScheduledInstanceAvailability.setter(Builder::maxTermDurationInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxTermDurationInDays").unmarshallLocationName("maxTermDurationInDays").build()}).build();
    private static final SdkField<Integer> MIN_TERM_DURATION_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinTermDurationInDays").getter(ScheduledInstanceAvailability.getter(ScheduledInstanceAvailability::minTermDurationInDays)).setter(ScheduledInstanceAvailability.setter(Builder::minTermDurationInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinTermDurationInDays").unmarshallLocationName("minTermDurationInDays").build()}).build();
    private static final SdkField<String> NETWORK_PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkPlatform").getter(ScheduledInstanceAvailability.getter(ScheduledInstanceAvailability::networkPlatform)).setter(ScheduledInstanceAvailability.setter(Builder::networkPlatform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkPlatform").unmarshallLocationName("networkPlatform").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Platform").getter(ScheduledInstanceAvailability.getter(ScheduledInstanceAvailability::platform)).setter(ScheduledInstanceAvailability.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform").unmarshallLocationName("platform").build()}).build();
    private static final SdkField<String> PURCHASE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PurchaseToken").getter(ScheduledInstanceAvailability.getter(ScheduledInstanceAvailability::purchaseToken)).setter(ScheduledInstanceAvailability.setter(Builder::purchaseToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PurchaseToken").unmarshallLocationName("purchaseToken").build()}).build();
    private static final SdkField<ScheduledInstanceRecurrence> RECURRENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Recurrence").getter(ScheduledInstanceAvailability.getter(ScheduledInstanceAvailability::recurrence)).setter(ScheduledInstanceAvailability.setter(Builder::recurrence)).constructor(ScheduledInstanceRecurrence::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recurrence").unmarshallLocationName("recurrence").build()}).build();
    private static final SdkField<Integer> SLOT_DURATION_IN_HOURS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SlotDurationInHours").getter(ScheduledInstanceAvailability.getter(ScheduledInstanceAvailability::slotDurationInHours)).setter(ScheduledInstanceAvailability.setter(Builder::slotDurationInHours)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SlotDurationInHours").unmarshallLocationName("slotDurationInHours").build()}).build();
    private static final SdkField<Integer> TOTAL_SCHEDULED_INSTANCE_HOURS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalScheduledInstanceHours").getter(ScheduledInstanceAvailability.getter(ScheduledInstanceAvailability::totalScheduledInstanceHours)).setter(ScheduledInstanceAvailability.setter(Builder::totalScheduledInstanceHours)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalScheduledInstanceHours").unmarshallLocationName("totalScheduledInstanceHours").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD, AVAILABLE_INSTANCE_COUNT_FIELD, FIRST_SLOT_START_TIME_FIELD, HOURLY_PRICE_FIELD, INSTANCE_TYPE_FIELD, MAX_TERM_DURATION_IN_DAYS_FIELD, MIN_TERM_DURATION_IN_DAYS_FIELD, NETWORK_PLATFORM_FIELD, PLATFORM_FIELD, PURCHASE_TOKEN_FIELD, RECURRENCE_FIELD, SLOT_DURATION_IN_HOURS_FIELD, TOTAL_SCHEDULED_INSTANCE_HOURS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String availabilityZone;
    private final Integer availableInstanceCount;
    private final Instant firstSlotStartTime;
    private final String hourlyPrice;
    private final String instanceType;
    private final Integer maxTermDurationInDays;
    private final Integer minTermDurationInDays;
    private final String networkPlatform;
    private final String platform;
    private final String purchaseToken;
    private final ScheduledInstanceRecurrence recurrence;
    private final Integer slotDurationInHours;
    private final Integer totalScheduledInstanceHours;

    private ScheduledInstanceAvailability(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.availableInstanceCount = builder.availableInstanceCount;
        this.firstSlotStartTime = builder.firstSlotStartTime;
        this.hourlyPrice = builder.hourlyPrice;
        this.instanceType = builder.instanceType;
        this.maxTermDurationInDays = builder.maxTermDurationInDays;
        this.minTermDurationInDays = builder.minTermDurationInDays;
        this.networkPlatform = builder.networkPlatform;
        this.platform = builder.platform;
        this.purchaseToken = builder.purchaseToken;
        this.recurrence = builder.recurrence;
        this.slotDurationInHours = builder.slotDurationInHours;
        this.totalScheduledInstanceHours = builder.totalScheduledInstanceHours;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final Integer availableInstanceCount() {
        return this.availableInstanceCount;
    }

    public final Instant firstSlotStartTime() {
        return this.firstSlotStartTime;
    }

    public final String hourlyPrice() {
        return this.hourlyPrice;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final Integer maxTermDurationInDays() {
        return this.maxTermDurationInDays;
    }

    public final Integer minTermDurationInDays() {
        return this.minTermDurationInDays;
    }

    public final String networkPlatform() {
        return this.networkPlatform;
    }

    public final String platform() {
        return this.platform;
    }

    public final String purchaseToken() {
        return this.purchaseToken;
    }

    public final ScheduledInstanceRecurrence recurrence() {
        return this.recurrence;
    }

    public final Integer slotDurationInHours() {
        return this.slotDurationInHours;
    }

    public final Integer totalScheduledInstanceHours() {
        return this.totalScheduledInstanceHours;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.availableInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.firstSlotStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hourlyPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxTermDurationInDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.minTermDurationInDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkPlatform());
        hashCode = 31 * hashCode + Objects.hashCode(this.platform());
        hashCode = 31 * hashCode + Objects.hashCode(this.purchaseToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.recurrence());
        hashCode = 31 * hashCode + Objects.hashCode(this.slotDurationInHours());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalScheduledInstanceHours());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledInstanceAvailability)) {
            return false;
        }
        ScheduledInstanceAvailability other = (ScheduledInstanceAvailability)obj;
        return Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.availableInstanceCount(), other.availableInstanceCount()) && Objects.equals(this.firstSlotStartTime(), other.firstSlotStartTime()) && Objects.equals(this.hourlyPrice(), other.hourlyPrice()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.maxTermDurationInDays(), other.maxTermDurationInDays()) && Objects.equals(this.minTermDurationInDays(), other.minTermDurationInDays()) && Objects.equals(this.networkPlatform(), other.networkPlatform()) && Objects.equals(this.platform(), other.platform()) && Objects.equals(this.purchaseToken(), other.purchaseToken()) && Objects.equals(this.recurrence(), other.recurrence()) && Objects.equals(this.slotDurationInHours(), other.slotDurationInHours()) && Objects.equals(this.totalScheduledInstanceHours(), other.totalScheduledInstanceHours());
    }

    public final String toString() {
        return ToString.builder((String)"ScheduledInstanceAvailability").add("AvailabilityZone", (Object)this.availabilityZone()).add("AvailableInstanceCount", (Object)this.availableInstanceCount()).add("FirstSlotStartTime", (Object)this.firstSlotStartTime()).add("HourlyPrice", (Object)this.hourlyPrice()).add("InstanceType", (Object)this.instanceType()).add("MaxTermDurationInDays", (Object)this.maxTermDurationInDays()).add("MinTermDurationInDays", (Object)this.minTermDurationInDays()).add("NetworkPlatform", (Object)this.networkPlatform()).add("Platform", (Object)this.platform()).add("PurchaseToken", (Object)this.purchaseToken()).add("Recurrence", (Object)this.recurrence()).add("SlotDurationInHours", (Object)this.slotDurationInHours()).add("TotalScheduledInstanceHours", (Object)this.totalScheduledInstanceHours()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "AvailableInstanceCount": {
                return Optional.ofNullable(clazz.cast(this.availableInstanceCount()));
            }
            case "FirstSlotStartTime": {
                return Optional.ofNullable(clazz.cast(this.firstSlotStartTime()));
            }
            case "HourlyPrice": {
                return Optional.ofNullable(clazz.cast(this.hourlyPrice()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "MaxTermDurationInDays": {
                return Optional.ofNullable(clazz.cast(this.maxTermDurationInDays()));
            }
            case "MinTermDurationInDays": {
                return Optional.ofNullable(clazz.cast(this.minTermDurationInDays()));
            }
            case "NetworkPlatform": {
                return Optional.ofNullable(clazz.cast(this.networkPlatform()));
            }
            case "Platform": {
                return Optional.ofNullable(clazz.cast(this.platform()));
            }
            case "PurchaseToken": {
                return Optional.ofNullable(clazz.cast(this.purchaseToken()));
            }
            case "Recurrence": {
                return Optional.ofNullable(clazz.cast(this.recurrence()));
            }
            case "SlotDurationInHours": {
                return Optional.ofNullable(clazz.cast(this.slotDurationInHours()));
            }
            case "TotalScheduledInstanceHours": {
                return Optional.ofNullable(clazz.cast(this.totalScheduledInstanceHours()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScheduledInstanceAvailability, T> g) {
        return obj -> g.apply((ScheduledInstanceAvailability)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String availabilityZone;
        private Integer availableInstanceCount;
        private Instant firstSlotStartTime;
        private String hourlyPrice;
        private String instanceType;
        private Integer maxTermDurationInDays;
        private Integer minTermDurationInDays;
        private String networkPlatform;
        private String platform;
        private String purchaseToken;
        private ScheduledInstanceRecurrence recurrence;
        private Integer slotDurationInHours;
        private Integer totalScheduledInstanceHours;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledInstanceAvailability model) {
            this.availabilityZone(model.availabilityZone);
            this.availableInstanceCount(model.availableInstanceCount);
            this.firstSlotStartTime(model.firstSlotStartTime);
            this.hourlyPrice(model.hourlyPrice);
            this.instanceType(model.instanceType);
            this.maxTermDurationInDays(model.maxTermDurationInDays);
            this.minTermDurationInDays(model.minTermDurationInDays);
            this.networkPlatform(model.networkPlatform);
            this.platform(model.platform);
            this.purchaseToken(model.purchaseToken);
            this.recurrence(model.recurrence);
            this.slotDurationInHours(model.slotDurationInHours);
            this.totalScheduledInstanceHours(model.totalScheduledInstanceHours);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        @Transient
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final Integer getAvailableInstanceCount() {
            return this.availableInstanceCount;
        }

        public final void setAvailableInstanceCount(Integer availableInstanceCount) {
            this.availableInstanceCount = availableInstanceCount;
        }

        @Override
        @Transient
        public final Builder availableInstanceCount(Integer availableInstanceCount) {
            this.availableInstanceCount = availableInstanceCount;
            return this;
        }

        public final Instant getFirstSlotStartTime() {
            return this.firstSlotStartTime;
        }

        public final void setFirstSlotStartTime(Instant firstSlotStartTime) {
            this.firstSlotStartTime = firstSlotStartTime;
        }

        @Override
        @Transient
        public final Builder firstSlotStartTime(Instant firstSlotStartTime) {
            this.firstSlotStartTime = firstSlotStartTime;
            return this;
        }

        public final String getHourlyPrice() {
            return this.hourlyPrice;
        }

        public final void setHourlyPrice(String hourlyPrice) {
            this.hourlyPrice = hourlyPrice;
        }

        @Override
        @Transient
        public final Builder hourlyPrice(String hourlyPrice) {
            this.hourlyPrice = hourlyPrice;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        @Transient
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final Integer getMaxTermDurationInDays() {
            return this.maxTermDurationInDays;
        }

        public final void setMaxTermDurationInDays(Integer maxTermDurationInDays) {
            this.maxTermDurationInDays = maxTermDurationInDays;
        }

        @Override
        @Transient
        public final Builder maxTermDurationInDays(Integer maxTermDurationInDays) {
            this.maxTermDurationInDays = maxTermDurationInDays;
            return this;
        }

        public final Integer getMinTermDurationInDays() {
            return this.minTermDurationInDays;
        }

        public final void setMinTermDurationInDays(Integer minTermDurationInDays) {
            this.minTermDurationInDays = minTermDurationInDays;
        }

        @Override
        @Transient
        public final Builder minTermDurationInDays(Integer minTermDurationInDays) {
            this.minTermDurationInDays = minTermDurationInDays;
            return this;
        }

        public final String getNetworkPlatform() {
            return this.networkPlatform;
        }

        public final void setNetworkPlatform(String networkPlatform) {
            this.networkPlatform = networkPlatform;
        }

        @Override
        @Transient
        public final Builder networkPlatform(String networkPlatform) {
            this.networkPlatform = networkPlatform;
            return this;
        }

        public final String getPlatform() {
            return this.platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        @Transient
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final String getPurchaseToken() {
            return this.purchaseToken;
        }

        public final void setPurchaseToken(String purchaseToken) {
            this.purchaseToken = purchaseToken;
        }

        @Override
        @Transient
        public final Builder purchaseToken(String purchaseToken) {
            this.purchaseToken = purchaseToken;
            return this;
        }

        public final ScheduledInstanceRecurrence.Builder getRecurrence() {
            return this.recurrence != null ? this.recurrence.toBuilder() : null;
        }

        public final void setRecurrence(ScheduledInstanceRecurrence.BuilderImpl recurrence) {
            this.recurrence = recurrence != null ? recurrence.build() : null;
        }

        @Override
        @Transient
        public final Builder recurrence(ScheduledInstanceRecurrence recurrence) {
            this.recurrence = recurrence;
            return this;
        }

        public final Integer getSlotDurationInHours() {
            return this.slotDurationInHours;
        }

        public final void setSlotDurationInHours(Integer slotDurationInHours) {
            this.slotDurationInHours = slotDurationInHours;
        }

        @Override
        @Transient
        public final Builder slotDurationInHours(Integer slotDurationInHours) {
            this.slotDurationInHours = slotDurationInHours;
            return this;
        }

        public final Integer getTotalScheduledInstanceHours() {
            return this.totalScheduledInstanceHours;
        }

        public final void setTotalScheduledInstanceHours(Integer totalScheduledInstanceHours) {
            this.totalScheduledInstanceHours = totalScheduledInstanceHours;
        }

        @Override
        @Transient
        public final Builder totalScheduledInstanceHours(Integer totalScheduledInstanceHours) {
            this.totalScheduledInstanceHours = totalScheduledInstanceHours;
            return this;
        }

        public ScheduledInstanceAvailability build() {
            return new ScheduledInstanceAvailability(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScheduledInstanceAvailability> {
        public Builder availabilityZone(String var1);

        public Builder availableInstanceCount(Integer var1);

        public Builder firstSlotStartTime(Instant var1);

        public Builder hourlyPrice(String var1);

        public Builder instanceType(String var1);

        public Builder maxTermDurationInDays(Integer var1);

        public Builder minTermDurationInDays(Integer var1);

        public Builder networkPlatform(String var1);

        public Builder platform(String var1);

        public Builder purchaseToken(String var1);

        public Builder recurrence(ScheduledInstanceRecurrence var1);

        default public Builder recurrence(Consumer<ScheduledInstanceRecurrence.Builder> recurrence) {
            return this.recurrence((ScheduledInstanceRecurrence)((ScheduledInstanceRecurrence.Builder)ScheduledInstanceRecurrence.builder().applyMutation(recurrence)).build());
        }

        public Builder slotDurationInHours(Integer var1);

        public Builder totalScheduledInstanceHours(Integer var1);
    }
}

