/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AllocationStrategy {
    LOWEST_PRICE("lowestPrice"),
    DIVERSIFIED("diversified"),
    CAPACITY_OPTIMIZED("capacityOptimized"),
    CAPACITY_OPTIMIZED_PRIORITIZED("capacityOptimizedPrioritized"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AllocationStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AllocationStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AllocationStrategy.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AllocationStrategy> knownValues() {
        return Stream.of(AllocationStrategy.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

