/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AnalysisStatus;
import software.amazon.awssdk.services.ec2.model.FindingsFound;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkInsightsAccessScopeAnalysis
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkInsightsAccessScopeAnalysis> {
    private static final SdkField<String> NETWORK_INSIGHTS_ACCESS_SCOPE_ANALYSIS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInsightsAccessScopeAnalysisId").getter(NetworkInsightsAccessScopeAnalysis.getter(NetworkInsightsAccessScopeAnalysis::networkInsightsAccessScopeAnalysisId)).setter(NetworkInsightsAccessScopeAnalysis.setter(Builder::networkInsightsAccessScopeAnalysisId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInsightsAccessScopeAnalysisId").unmarshallLocationName("networkInsightsAccessScopeAnalysisId").build()}).build();
    private static final SdkField<String> NETWORK_INSIGHTS_ACCESS_SCOPE_ANALYSIS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInsightsAccessScopeAnalysisArn").getter(NetworkInsightsAccessScopeAnalysis.getter(NetworkInsightsAccessScopeAnalysis::networkInsightsAccessScopeAnalysisArn)).setter(NetworkInsightsAccessScopeAnalysis.setter(Builder::networkInsightsAccessScopeAnalysisArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInsightsAccessScopeAnalysisArn").unmarshallLocationName("networkInsightsAccessScopeAnalysisArn").build()}).build();
    private static final SdkField<String> NETWORK_INSIGHTS_ACCESS_SCOPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInsightsAccessScopeId").getter(NetworkInsightsAccessScopeAnalysis.getter(NetworkInsightsAccessScopeAnalysis::networkInsightsAccessScopeId)).setter(NetworkInsightsAccessScopeAnalysis.setter(Builder::networkInsightsAccessScopeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInsightsAccessScopeId").unmarshallLocationName("networkInsightsAccessScopeId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(NetworkInsightsAccessScopeAnalysis.getter(NetworkInsightsAccessScopeAnalysis::statusAsString)).setter(NetworkInsightsAccessScopeAnalysis.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(NetworkInsightsAccessScopeAnalysis.getter(NetworkInsightsAccessScopeAnalysis::statusMessage)).setter(NetworkInsightsAccessScopeAnalysis.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").unmarshallLocationName("statusMessage").build()}).build();
    private static final SdkField<String> WARNING_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WarningMessage").getter(NetworkInsightsAccessScopeAnalysis.getter(NetworkInsightsAccessScopeAnalysis::warningMessage)).setter(NetworkInsightsAccessScopeAnalysis.setter(Builder::warningMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarningMessage").unmarshallLocationName("warningMessage").build()}).build();
    private static final SdkField<Instant> START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartDate").getter(NetworkInsightsAccessScopeAnalysis.getter(NetworkInsightsAccessScopeAnalysis::startDate)).setter(NetworkInsightsAccessScopeAnalysis.setter(Builder::startDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDate").unmarshallLocationName("startDate").build()}).build();
    private static final SdkField<Instant> END_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndDate").getter(NetworkInsightsAccessScopeAnalysis.getter(NetworkInsightsAccessScopeAnalysis::endDate)).setter(NetworkInsightsAccessScopeAnalysis.setter(Builder::endDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDate").unmarshallLocationName("endDate").build()}).build();
    private static final SdkField<String> FINDINGS_FOUND_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FindingsFound").getter(NetworkInsightsAccessScopeAnalysis.getter(NetworkInsightsAccessScopeAnalysis::findingsFoundAsString)).setter(NetworkInsightsAccessScopeAnalysis.setter(Builder::findingsFound)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FindingsFound").unmarshallLocationName("findingsFound").build()}).build();
    private static final SdkField<Integer> ANALYZED_ENI_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AnalyzedEniCount").getter(NetworkInsightsAccessScopeAnalysis.getter(NetworkInsightsAccessScopeAnalysis::analyzedEniCount)).setter(NetworkInsightsAccessScopeAnalysis.setter(Builder::analyzedEniCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalyzedEniCount").unmarshallLocationName("analyzedEniCount").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(NetworkInsightsAccessScopeAnalysis.getter(NetworkInsightsAccessScopeAnalysis::tags)).setter(NetworkInsightsAccessScopeAnalysis.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_INSIGHTS_ACCESS_SCOPE_ANALYSIS_ID_FIELD, NETWORK_INSIGHTS_ACCESS_SCOPE_ANALYSIS_ARN_FIELD, NETWORK_INSIGHTS_ACCESS_SCOPE_ID_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, WARNING_MESSAGE_FIELD, START_DATE_FIELD, END_DATE_FIELD, FINDINGS_FOUND_FIELD, ANALYZED_ENI_COUNT_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String networkInsightsAccessScopeAnalysisId;
    private final String networkInsightsAccessScopeAnalysisArn;
    private final String networkInsightsAccessScopeId;
    private final String status;
    private final String statusMessage;
    private final String warningMessage;
    private final Instant startDate;
    private final Instant endDate;
    private final String findingsFound;
    private final Integer analyzedEniCount;
    private final List<Tag> tags;

    private NetworkInsightsAccessScopeAnalysis(BuilderImpl builder) {
        this.networkInsightsAccessScopeAnalysisId = builder.networkInsightsAccessScopeAnalysisId;
        this.networkInsightsAccessScopeAnalysisArn = builder.networkInsightsAccessScopeAnalysisArn;
        this.networkInsightsAccessScopeId = builder.networkInsightsAccessScopeId;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.warningMessage = builder.warningMessage;
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
        this.findingsFound = builder.findingsFound;
        this.analyzedEniCount = builder.analyzedEniCount;
        this.tags = builder.tags;
    }

    public final String networkInsightsAccessScopeAnalysisId() {
        return this.networkInsightsAccessScopeAnalysisId;
    }

    public final String networkInsightsAccessScopeAnalysisArn() {
        return this.networkInsightsAccessScopeAnalysisArn;
    }

    public final String networkInsightsAccessScopeId() {
        return this.networkInsightsAccessScopeId;
    }

    public final AnalysisStatus status() {
        return AnalysisStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final String warningMessage() {
        return this.warningMessage;
    }

    public final Instant startDate() {
        return this.startDate;
    }

    public final Instant endDate() {
        return this.endDate;
    }

    public final FindingsFound findingsFound() {
        return FindingsFound.fromValue(this.findingsFound);
    }

    public final String findingsFoundAsString() {
        return this.findingsFound;
    }

    public final Integer analyzedEniCount() {
        return this.analyzedEniCount;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInsightsAccessScopeAnalysisId());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInsightsAccessScopeAnalysisArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInsightsAccessScopeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.warningMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.startDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.findingsFoundAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.analyzedEniCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInsightsAccessScopeAnalysis)) {
            return false;
        }
        NetworkInsightsAccessScopeAnalysis other = (NetworkInsightsAccessScopeAnalysis)obj;
        return Objects.equals(this.networkInsightsAccessScopeAnalysisId(), other.networkInsightsAccessScopeAnalysisId()) && Objects.equals(this.networkInsightsAccessScopeAnalysisArn(), other.networkInsightsAccessScopeAnalysisArn()) && Objects.equals(this.networkInsightsAccessScopeId(), other.networkInsightsAccessScopeId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.warningMessage(), other.warningMessage()) && Objects.equals(this.startDate(), other.startDate()) && Objects.equals(this.endDate(), other.endDate()) && Objects.equals(this.findingsFoundAsString(), other.findingsFoundAsString()) && Objects.equals(this.analyzedEniCount(), other.analyzedEniCount()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkInsightsAccessScopeAnalysis").add("NetworkInsightsAccessScopeAnalysisId", (Object)this.networkInsightsAccessScopeAnalysisId()).add("NetworkInsightsAccessScopeAnalysisArn", (Object)this.networkInsightsAccessScopeAnalysisArn()).add("NetworkInsightsAccessScopeId", (Object)this.networkInsightsAccessScopeId()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("WarningMessage", (Object)this.warningMessage()).add("StartDate", (Object)this.startDate()).add("EndDate", (Object)this.endDate()).add("FindingsFound", (Object)this.findingsFoundAsString()).add("AnalyzedEniCount", (Object)this.analyzedEniCount()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkInsightsAccessScopeAnalysisId": {
                return Optional.ofNullable(clazz.cast(this.networkInsightsAccessScopeAnalysisId()));
            }
            case "NetworkInsightsAccessScopeAnalysisArn": {
                return Optional.ofNullable(clazz.cast(this.networkInsightsAccessScopeAnalysisArn()));
            }
            case "NetworkInsightsAccessScopeId": {
                return Optional.ofNullable(clazz.cast(this.networkInsightsAccessScopeId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "WarningMessage": {
                return Optional.ofNullable(clazz.cast(this.warningMessage()));
            }
            case "StartDate": {
                return Optional.ofNullable(clazz.cast(this.startDate()));
            }
            case "EndDate": {
                return Optional.ofNullable(clazz.cast(this.endDate()));
            }
            case "FindingsFound": {
                return Optional.ofNullable(clazz.cast(this.findingsFoundAsString()));
            }
            case "AnalyzedEniCount": {
                return Optional.ofNullable(clazz.cast(this.analyzedEniCount()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkInsightsAccessScopeAnalysis, T> g) {
        return obj -> g.apply((NetworkInsightsAccessScopeAnalysis)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String networkInsightsAccessScopeAnalysisId;
        private String networkInsightsAccessScopeAnalysisArn;
        private String networkInsightsAccessScopeId;
        private String status;
        private String statusMessage;
        private String warningMessage;
        private Instant startDate;
        private Instant endDate;
        private String findingsFound;
        private Integer analyzedEniCount;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInsightsAccessScopeAnalysis model) {
            this.networkInsightsAccessScopeAnalysisId(model.networkInsightsAccessScopeAnalysisId);
            this.networkInsightsAccessScopeAnalysisArn(model.networkInsightsAccessScopeAnalysisArn);
            this.networkInsightsAccessScopeId(model.networkInsightsAccessScopeId);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.warningMessage(model.warningMessage);
            this.startDate(model.startDate);
            this.endDate(model.endDate);
            this.findingsFound(model.findingsFound);
            this.analyzedEniCount(model.analyzedEniCount);
            this.tags(model.tags);
        }

        public final String getNetworkInsightsAccessScopeAnalysisId() {
            return this.networkInsightsAccessScopeAnalysisId;
        }

        public final void setNetworkInsightsAccessScopeAnalysisId(String networkInsightsAccessScopeAnalysisId) {
            this.networkInsightsAccessScopeAnalysisId = networkInsightsAccessScopeAnalysisId;
        }

        @Override
        public final Builder networkInsightsAccessScopeAnalysisId(String networkInsightsAccessScopeAnalysisId) {
            this.networkInsightsAccessScopeAnalysisId = networkInsightsAccessScopeAnalysisId;
            return this;
        }

        public final String getNetworkInsightsAccessScopeAnalysisArn() {
            return this.networkInsightsAccessScopeAnalysisArn;
        }

        public final void setNetworkInsightsAccessScopeAnalysisArn(String networkInsightsAccessScopeAnalysisArn) {
            this.networkInsightsAccessScopeAnalysisArn = networkInsightsAccessScopeAnalysisArn;
        }

        @Override
        public final Builder networkInsightsAccessScopeAnalysisArn(String networkInsightsAccessScopeAnalysisArn) {
            this.networkInsightsAccessScopeAnalysisArn = networkInsightsAccessScopeAnalysisArn;
            return this;
        }

        public final String getNetworkInsightsAccessScopeId() {
            return this.networkInsightsAccessScopeId;
        }

        public final void setNetworkInsightsAccessScopeId(String networkInsightsAccessScopeId) {
            this.networkInsightsAccessScopeId = networkInsightsAccessScopeId;
        }

        @Override
        public final Builder networkInsightsAccessScopeId(String networkInsightsAccessScopeId) {
            this.networkInsightsAccessScopeId = networkInsightsAccessScopeId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AnalysisStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getWarningMessage() {
            return this.warningMessage;
        }

        public final void setWarningMessage(String warningMessage) {
            this.warningMessage = warningMessage;
        }

        @Override
        public final Builder warningMessage(String warningMessage) {
            this.warningMessage = warningMessage;
            return this;
        }

        public final Instant getStartDate() {
            return this.startDate;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final Instant getEndDate() {
            return this.endDate;
        }

        public final void setEndDate(Instant endDate) {
            this.endDate = endDate;
        }

        @Override
        public final Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public final String getFindingsFound() {
            return this.findingsFound;
        }

        public final void setFindingsFound(String findingsFound) {
            this.findingsFound = findingsFound;
        }

        @Override
        public final Builder findingsFound(String findingsFound) {
            this.findingsFound = findingsFound;
            return this;
        }

        @Override
        public final Builder findingsFound(FindingsFound findingsFound) {
            this.findingsFound(findingsFound == null ? null : findingsFound.toString());
            return this;
        }

        public final Integer getAnalyzedEniCount() {
            return this.analyzedEniCount;
        }

        public final void setAnalyzedEniCount(Integer analyzedEniCount) {
            this.analyzedEniCount = analyzedEniCount;
        }

        @Override
        public final Builder analyzedEniCount(Integer analyzedEniCount) {
            this.analyzedEniCount = analyzedEniCount;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public NetworkInsightsAccessScopeAnalysis build() {
            return new NetworkInsightsAccessScopeAnalysis(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkInsightsAccessScopeAnalysis> {
        public Builder networkInsightsAccessScopeAnalysisId(String var1);

        public Builder networkInsightsAccessScopeAnalysisArn(String var1);

        public Builder networkInsightsAccessScopeId(String var1);

        public Builder status(String var1);

        public Builder status(AnalysisStatus var1);

        public Builder statusMessage(String var1);

        public Builder warningMessage(String var1);

        public Builder startDate(Instant var1);

        public Builder endDate(Instant var1);

        public Builder findingsFound(String var1);

        public Builder findingsFound(FindingsFound var1);

        public Builder analyzedEniCount(Integer var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

