/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRestoreImageTaskRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateRestoreImageTaskRequest> {
    private static final SdkField<String> BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Bucket").getter(CreateRestoreImageTaskRequest.getter(CreateRestoreImageTaskRequest::bucket)).setter(CreateRestoreImageTaskRequest.setter(Builder::bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bucket").unmarshallLocationName("Bucket").build()}).build();
    private static final SdkField<String> OBJECT_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObjectKey").getter(CreateRestoreImageTaskRequest.getter(CreateRestoreImageTaskRequest::objectKey)).setter(CreateRestoreImageTaskRequest.setter(Builder::objectKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectKey").unmarshallLocationName("ObjectKey").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateRestoreImageTaskRequest.getter(CreateRestoreImageTaskRequest::name)).setter(CreateRestoreImageTaskRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").unmarshallLocationName("Name").build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(CreateRestoreImageTaskRequest.getter(CreateRestoreImageTaskRequest::tagSpecifications)).setter(CreateRestoreImageTaskRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_FIELD, OBJECT_KEY_FIELD, NAME_FIELD, TAG_SPECIFICATIONS_FIELD));
    private final String bucket;
    private final String objectKey;
    private final String name;
    private final List<TagSpecification> tagSpecifications;

    private CreateRestoreImageTaskRequest(BuilderImpl builder) {
        super(builder);
        this.bucket = builder.bucket;
        this.objectKey = builder.objectKey;
        this.name = builder.name;
        this.tagSpecifications = builder.tagSpecifications;
    }

    public final String bucket() {
        return this.bucket;
    }

    public final String objectKey() {
        return this.objectKey;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRestoreImageTaskRequest)) {
            return false;
        }
        CreateRestoreImageTaskRequest other = (CreateRestoreImageTaskRequest)((Object)obj);
        return Objects.equals(this.bucket(), other.bucket()) && Objects.equals(this.objectKey(), other.objectKey()) && Objects.equals(this.name(), other.name()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications());
    }

    public final String toString() {
        return ToString.builder((String)"CreateRestoreImageTaskRequest").add("Bucket", (Object)this.bucket()).add("ObjectKey", (Object)this.objectKey()).add("Name", (Object)this.name()).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bucket": {
                return Optional.ofNullable(clazz.cast(this.bucket()));
            }
            case "ObjectKey": {
                return Optional.ofNullable(clazz.cast(this.objectKey()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRestoreImageTaskRequest, T> g) {
        return obj -> g.apply((CreateRestoreImageTaskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String bucket;
        private String objectKey;
        private String name;
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRestoreImageTaskRequest model) {
            super(model);
            this.bucket(model.bucket);
            this.objectKey(model.objectKey);
            this.name(model.name);
            this.tagSpecifications(model.tagSpecifications);
        }

        public final String getBucket() {
            return this.bucket;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final String getObjectKey() {
            return this.objectKey;
        }

        public final void setObjectKey(String objectKey) {
            this.objectKey = objectKey;
        }

        @Override
        public final Builder objectKey(String objectKey) {
            this.objectKey = objectKey;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRestoreImageTaskRequest build() {
            return new CreateRestoreImageTaskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRestoreImageTaskRequest> {
        public Builder bucket(String var1);

        public Builder objectKey(String var1);

        public Builder name(String var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

