/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RIProductDescription {
    LINUX_UNIX("Linux/UNIX"),
    LINUX_UNIX_AMAZON_VPC("Linux/UNIX (Amazon VPC)"),
    WINDOWS("Windows"),
    WINDOWS_AMAZON_VPC("Windows (Amazon VPC)"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RIProductDescription> VALUE_MAP;
    private final String value;

    private RIProductDescription(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RIProductDescription fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RIProductDescription> knownValues() {
        EnumSet<RIProductDescription> knownValues = EnumSet.allOf(RIProductDescription.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RIProductDescription.class, RIProductDescription::toString);
    }
}

