/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AcceleratorCount;
import software.amazon.awssdk.services.ec2.model.AcceleratorManufacturer;
import software.amazon.awssdk.services.ec2.model.AcceleratorManufacturerSetCopier;
import software.amazon.awssdk.services.ec2.model.AcceleratorName;
import software.amazon.awssdk.services.ec2.model.AcceleratorNameSetCopier;
import software.amazon.awssdk.services.ec2.model.AcceleratorTotalMemoryMiB;
import software.amazon.awssdk.services.ec2.model.AcceleratorType;
import software.amazon.awssdk.services.ec2.model.AcceleratorTypeSetCopier;
import software.amazon.awssdk.services.ec2.model.BareMetal;
import software.amazon.awssdk.services.ec2.model.BaselineEbsBandwidthMbps;
import software.amazon.awssdk.services.ec2.model.BurstablePerformance;
import software.amazon.awssdk.services.ec2.model.CpuManufacturer;
import software.amazon.awssdk.services.ec2.model.CpuManufacturerSetCopier;
import software.amazon.awssdk.services.ec2.model.ExcludedInstanceTypeSetCopier;
import software.amazon.awssdk.services.ec2.model.InstanceGeneration;
import software.amazon.awssdk.services.ec2.model.InstanceGenerationSetCopier;
import software.amazon.awssdk.services.ec2.model.LocalStorage;
import software.amazon.awssdk.services.ec2.model.LocalStorageType;
import software.amazon.awssdk.services.ec2.model.LocalStorageTypeSetCopier;
import software.amazon.awssdk.services.ec2.model.MemoryGiBPerVCpu;
import software.amazon.awssdk.services.ec2.model.MemoryMiB;
import software.amazon.awssdk.services.ec2.model.NetworkInterfaceCount;
import software.amazon.awssdk.services.ec2.model.TotalLocalStorageGB;
import software.amazon.awssdk.services.ec2.model.VCpuCountRange;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceRequirements
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceRequirements> {
    private static final SdkField<VCpuCountRange> V_CPU_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VCpuCount").getter(InstanceRequirements.getter(InstanceRequirements::vCpuCount)).setter(InstanceRequirements.setter(Builder::vCpuCount)).constructor(VCpuCountRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VCpuCount").unmarshallLocationName("vCpuCount").build()}).build();
    private static final SdkField<MemoryMiB> MEMORY_MIB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MemoryMiB").getter(InstanceRequirements.getter(InstanceRequirements::memoryMiB)).setter(InstanceRequirements.setter(Builder::memoryMiB)).constructor(MemoryMiB::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemoryMiB").unmarshallLocationName("memoryMiB").build()}).build();
    private static final SdkField<List<String>> CPU_MANUFACTURERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CpuManufacturers").getter(InstanceRequirements.getter(InstanceRequirements::cpuManufacturersAsStrings)).setter(InstanceRequirements.setter(Builder::cpuManufacturersWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CpuManufacturerSet").unmarshallLocationName("cpuManufacturerSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<MemoryGiBPerVCpu> MEMORY_GI_B_PER_V_CPU_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MemoryGiBPerVCpu").getter(InstanceRequirements.getter(InstanceRequirements::memoryGiBPerVCpu)).setter(InstanceRequirements.setter(Builder::memoryGiBPerVCpu)).constructor(MemoryGiBPerVCpu::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemoryGiBPerVCpu").unmarshallLocationName("memoryGiBPerVCpu").build()}).build();
    private static final SdkField<List<String>> EXCLUDED_INSTANCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExcludedInstanceTypes").getter(InstanceRequirements.getter(InstanceRequirements::excludedInstanceTypes)).setter(InstanceRequirements.setter(Builder::excludedInstanceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludedInstanceTypeSet").unmarshallLocationName("excludedInstanceTypeSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> INSTANCE_GENERATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceGenerations").getter(InstanceRequirements.getter(InstanceRequirements::instanceGenerationsAsStrings)).setter(InstanceRequirements.setter(Builder::instanceGenerationsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGenerationSet").unmarshallLocationName("instanceGenerationSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Integer> SPOT_MAX_PRICE_PERCENTAGE_OVER_LOWEST_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SpotMaxPricePercentageOverLowestPrice").getter(InstanceRequirements.getter(InstanceRequirements::spotMaxPricePercentageOverLowestPrice)).setter(InstanceRequirements.setter(Builder::spotMaxPricePercentageOverLowestPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotMaxPricePercentageOverLowestPrice").unmarshallLocationName("spotMaxPricePercentageOverLowestPrice").build()}).build();
    private static final SdkField<Integer> ON_DEMAND_MAX_PRICE_PERCENTAGE_OVER_LOWEST_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("OnDemandMaxPricePercentageOverLowestPrice").getter(InstanceRequirements.getter(InstanceRequirements::onDemandMaxPricePercentageOverLowestPrice)).setter(InstanceRequirements.setter(Builder::onDemandMaxPricePercentageOverLowestPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandMaxPricePercentageOverLowestPrice").unmarshallLocationName("onDemandMaxPricePercentageOverLowestPrice").build()}).build();
    private static final SdkField<String> BARE_METAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BareMetal").getter(InstanceRequirements.getter(InstanceRequirements::bareMetalAsString)).setter(InstanceRequirements.setter(Builder::bareMetal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BareMetal").unmarshallLocationName("bareMetal").build()}).build();
    private static final SdkField<String> BURSTABLE_PERFORMANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BurstablePerformance").getter(InstanceRequirements.getter(InstanceRequirements::burstablePerformanceAsString)).setter(InstanceRequirements.setter(Builder::burstablePerformance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BurstablePerformance").unmarshallLocationName("burstablePerformance").build()}).build();
    private static final SdkField<Boolean> REQUIRE_HIBERNATE_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RequireHibernateSupport").getter(InstanceRequirements.getter(InstanceRequirements::requireHibernateSupport)).setter(InstanceRequirements.setter(Builder::requireHibernateSupport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequireHibernateSupport").unmarshallLocationName("requireHibernateSupport").build()}).build();
    private static final SdkField<NetworkInterfaceCount> NETWORK_INTERFACE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkInterfaceCount").getter(InstanceRequirements.getter(InstanceRequirements::networkInterfaceCount)).setter(InstanceRequirements.setter(Builder::networkInterfaceCount)).constructor(NetworkInterfaceCount::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceCount").unmarshallLocationName("networkInterfaceCount").build()}).build();
    private static final SdkField<String> LOCAL_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalStorage").getter(InstanceRequirements.getter(InstanceRequirements::localStorageAsString)).setter(InstanceRequirements.setter(Builder::localStorage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalStorage").unmarshallLocationName("localStorage").build()}).build();
    private static final SdkField<List<String>> LOCAL_STORAGE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LocalStorageTypes").getter(InstanceRequirements.getter(InstanceRequirements::localStorageTypesAsStrings)).setter(InstanceRequirements.setter(Builder::localStorageTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalStorageTypeSet").unmarshallLocationName("localStorageTypeSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<TotalLocalStorageGB> TOTAL_LOCAL_STORAGE_GB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TotalLocalStorageGB").getter(InstanceRequirements.getter(InstanceRequirements::totalLocalStorageGB)).setter(InstanceRequirements.setter(Builder::totalLocalStorageGB)).constructor(TotalLocalStorageGB::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalLocalStorageGB").unmarshallLocationName("totalLocalStorageGB").build()}).build();
    private static final SdkField<BaselineEbsBandwidthMbps> BASELINE_EBS_BANDWIDTH_MBPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BaselineEbsBandwidthMbps").getter(InstanceRequirements.getter(InstanceRequirements::baselineEbsBandwidthMbps)).setter(InstanceRequirements.setter(Builder::baselineEbsBandwidthMbps)).constructor(BaselineEbsBandwidthMbps::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaselineEbsBandwidthMbps").unmarshallLocationName("baselineEbsBandwidthMbps").build()}).build();
    private static final SdkField<List<String>> ACCELERATOR_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AcceleratorTypes").getter(InstanceRequirements.getter(InstanceRequirements::acceleratorTypesAsStrings)).setter(InstanceRequirements.setter(Builder::acceleratorTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceleratorTypeSet").unmarshallLocationName("acceleratorTypeSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<AcceleratorCount> ACCELERATOR_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AcceleratorCount").getter(InstanceRequirements.getter(InstanceRequirements::acceleratorCount)).setter(InstanceRequirements.setter(Builder::acceleratorCount)).constructor(AcceleratorCount::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceleratorCount").unmarshallLocationName("acceleratorCount").build()}).build();
    private static final SdkField<List<String>> ACCELERATOR_MANUFACTURERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AcceleratorManufacturers").getter(InstanceRequirements.getter(InstanceRequirements::acceleratorManufacturersAsStrings)).setter(InstanceRequirements.setter(Builder::acceleratorManufacturersWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceleratorManufacturerSet").unmarshallLocationName("acceleratorManufacturerSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ACCELERATOR_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AcceleratorNames").getter(InstanceRequirements.getter(InstanceRequirements::acceleratorNamesAsStrings)).setter(InstanceRequirements.setter(Builder::acceleratorNamesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceleratorNameSet").unmarshallLocationName("acceleratorNameSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<AcceleratorTotalMemoryMiB> ACCELERATOR_TOTAL_MEMORY_MIB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AcceleratorTotalMemoryMiB").getter(InstanceRequirements.getter(InstanceRequirements::acceleratorTotalMemoryMiB)).setter(InstanceRequirements.setter(Builder::acceleratorTotalMemoryMiB)).constructor(AcceleratorTotalMemoryMiB::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceleratorTotalMemoryMiB").unmarshallLocationName("acceleratorTotalMemoryMiB").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(V_CPU_COUNT_FIELD, MEMORY_MIB_FIELD, CPU_MANUFACTURERS_FIELD, MEMORY_GI_B_PER_V_CPU_FIELD, EXCLUDED_INSTANCE_TYPES_FIELD, INSTANCE_GENERATIONS_FIELD, SPOT_MAX_PRICE_PERCENTAGE_OVER_LOWEST_PRICE_FIELD, ON_DEMAND_MAX_PRICE_PERCENTAGE_OVER_LOWEST_PRICE_FIELD, BARE_METAL_FIELD, BURSTABLE_PERFORMANCE_FIELD, REQUIRE_HIBERNATE_SUPPORT_FIELD, NETWORK_INTERFACE_COUNT_FIELD, LOCAL_STORAGE_FIELD, LOCAL_STORAGE_TYPES_FIELD, TOTAL_LOCAL_STORAGE_GB_FIELD, BASELINE_EBS_BANDWIDTH_MBPS_FIELD, ACCELERATOR_TYPES_FIELD, ACCELERATOR_COUNT_FIELD, ACCELERATOR_MANUFACTURERS_FIELD, ACCELERATOR_NAMES_FIELD, ACCELERATOR_TOTAL_MEMORY_MIB_FIELD));
    private static final long serialVersionUID = 1L;
    private final VCpuCountRange vCpuCount;
    private final MemoryMiB memoryMiB;
    private final List<String> cpuManufacturers;
    private final MemoryGiBPerVCpu memoryGiBPerVCpu;
    private final List<String> excludedInstanceTypes;
    private final List<String> instanceGenerations;
    private final Integer spotMaxPricePercentageOverLowestPrice;
    private final Integer onDemandMaxPricePercentageOverLowestPrice;
    private final String bareMetal;
    private final String burstablePerformance;
    private final Boolean requireHibernateSupport;
    private final NetworkInterfaceCount networkInterfaceCount;
    private final String localStorage;
    private final List<String> localStorageTypes;
    private final TotalLocalStorageGB totalLocalStorageGB;
    private final BaselineEbsBandwidthMbps baselineEbsBandwidthMbps;
    private final List<String> acceleratorTypes;
    private final AcceleratorCount acceleratorCount;
    private final List<String> acceleratorManufacturers;
    private final List<String> acceleratorNames;
    private final AcceleratorTotalMemoryMiB acceleratorTotalMemoryMiB;

    private InstanceRequirements(BuilderImpl builder) {
        this.vCpuCount = builder.vCpuCount;
        this.memoryMiB = builder.memoryMiB;
        this.cpuManufacturers = builder.cpuManufacturers;
        this.memoryGiBPerVCpu = builder.memoryGiBPerVCpu;
        this.excludedInstanceTypes = builder.excludedInstanceTypes;
        this.instanceGenerations = builder.instanceGenerations;
        this.spotMaxPricePercentageOverLowestPrice = builder.spotMaxPricePercentageOverLowestPrice;
        this.onDemandMaxPricePercentageOverLowestPrice = builder.onDemandMaxPricePercentageOverLowestPrice;
        this.bareMetal = builder.bareMetal;
        this.burstablePerformance = builder.burstablePerformance;
        this.requireHibernateSupport = builder.requireHibernateSupport;
        this.networkInterfaceCount = builder.networkInterfaceCount;
        this.localStorage = builder.localStorage;
        this.localStorageTypes = builder.localStorageTypes;
        this.totalLocalStorageGB = builder.totalLocalStorageGB;
        this.baselineEbsBandwidthMbps = builder.baselineEbsBandwidthMbps;
        this.acceleratorTypes = builder.acceleratorTypes;
        this.acceleratorCount = builder.acceleratorCount;
        this.acceleratorManufacturers = builder.acceleratorManufacturers;
        this.acceleratorNames = builder.acceleratorNames;
        this.acceleratorTotalMemoryMiB = builder.acceleratorTotalMemoryMiB;
    }

    public final VCpuCountRange vCpuCount() {
        return this.vCpuCount;
    }

    public final MemoryMiB memoryMiB() {
        return this.memoryMiB;
    }

    public final List<CpuManufacturer> cpuManufacturers() {
        return CpuManufacturerSetCopier.copyStringToEnum(this.cpuManufacturers);
    }

    public final boolean hasCpuManufacturers() {
        return this.cpuManufacturers != null && !(this.cpuManufacturers instanceof SdkAutoConstructList);
    }

    public final List<String> cpuManufacturersAsStrings() {
        return this.cpuManufacturers;
    }

    public final MemoryGiBPerVCpu memoryGiBPerVCpu() {
        return this.memoryGiBPerVCpu;
    }

    public final boolean hasExcludedInstanceTypes() {
        return this.excludedInstanceTypes != null && !(this.excludedInstanceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> excludedInstanceTypes() {
        return this.excludedInstanceTypes;
    }

    public final List<InstanceGeneration> instanceGenerations() {
        return InstanceGenerationSetCopier.copyStringToEnum(this.instanceGenerations);
    }

    public final boolean hasInstanceGenerations() {
        return this.instanceGenerations != null && !(this.instanceGenerations instanceof SdkAutoConstructList);
    }

    public final List<String> instanceGenerationsAsStrings() {
        return this.instanceGenerations;
    }

    public final Integer spotMaxPricePercentageOverLowestPrice() {
        return this.spotMaxPricePercentageOverLowestPrice;
    }

    public final Integer onDemandMaxPricePercentageOverLowestPrice() {
        return this.onDemandMaxPricePercentageOverLowestPrice;
    }

    public final BareMetal bareMetal() {
        return BareMetal.fromValue(this.bareMetal);
    }

    public final String bareMetalAsString() {
        return this.bareMetal;
    }

    public final BurstablePerformance burstablePerformance() {
        return BurstablePerformance.fromValue(this.burstablePerformance);
    }

    public final String burstablePerformanceAsString() {
        return this.burstablePerformance;
    }

    public final Boolean requireHibernateSupport() {
        return this.requireHibernateSupport;
    }

    public final NetworkInterfaceCount networkInterfaceCount() {
        return this.networkInterfaceCount;
    }

    public final LocalStorage localStorage() {
        return LocalStorage.fromValue(this.localStorage);
    }

    public final String localStorageAsString() {
        return this.localStorage;
    }

    public final List<LocalStorageType> localStorageTypes() {
        return LocalStorageTypeSetCopier.copyStringToEnum(this.localStorageTypes);
    }

    public final boolean hasLocalStorageTypes() {
        return this.localStorageTypes != null && !(this.localStorageTypes instanceof SdkAutoConstructList);
    }

    public final List<String> localStorageTypesAsStrings() {
        return this.localStorageTypes;
    }

    public final TotalLocalStorageGB totalLocalStorageGB() {
        return this.totalLocalStorageGB;
    }

    public final BaselineEbsBandwidthMbps baselineEbsBandwidthMbps() {
        return this.baselineEbsBandwidthMbps;
    }

    public final List<AcceleratorType> acceleratorTypes() {
        return AcceleratorTypeSetCopier.copyStringToEnum(this.acceleratorTypes);
    }

    public final boolean hasAcceleratorTypes() {
        return this.acceleratorTypes != null && !(this.acceleratorTypes instanceof SdkAutoConstructList);
    }

    public final List<String> acceleratorTypesAsStrings() {
        return this.acceleratorTypes;
    }

    public final AcceleratorCount acceleratorCount() {
        return this.acceleratorCount;
    }

    public final List<AcceleratorManufacturer> acceleratorManufacturers() {
        return AcceleratorManufacturerSetCopier.copyStringToEnum(this.acceleratorManufacturers);
    }

    public final boolean hasAcceleratorManufacturers() {
        return this.acceleratorManufacturers != null && !(this.acceleratorManufacturers instanceof SdkAutoConstructList);
    }

    public final List<String> acceleratorManufacturersAsStrings() {
        return this.acceleratorManufacturers;
    }

    public final List<AcceleratorName> acceleratorNames() {
        return AcceleratorNameSetCopier.copyStringToEnum(this.acceleratorNames);
    }

    public final boolean hasAcceleratorNames() {
        return this.acceleratorNames != null && !(this.acceleratorNames instanceof SdkAutoConstructList);
    }

    public final List<String> acceleratorNamesAsStrings() {
        return this.acceleratorNames;
    }

    public final AcceleratorTotalMemoryMiB acceleratorTotalMemoryMiB() {
        return this.acceleratorTotalMemoryMiB;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vCpuCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryMiB());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCpuManufacturers() ? this.cpuManufacturersAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryGiBPerVCpu());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludedInstanceTypes() ? this.excludedInstanceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceGenerations() ? this.instanceGenerationsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.spotMaxPricePercentageOverLowestPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.onDemandMaxPricePercentageOverLowestPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.bareMetalAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.burstablePerformanceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.requireHibernateSupport());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.localStorageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLocalStorageTypes() ? this.localStorageTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.totalLocalStorageGB());
        hashCode = 31 * hashCode + Objects.hashCode(this.baselineEbsBandwidthMbps());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAcceleratorTypes() ? this.acceleratorTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.acceleratorCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAcceleratorManufacturers() ? this.acceleratorManufacturersAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAcceleratorNames() ? this.acceleratorNamesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.acceleratorTotalMemoryMiB());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceRequirements)) {
            return false;
        }
        InstanceRequirements other = (InstanceRequirements)obj;
        return Objects.equals(this.vCpuCount(), other.vCpuCount()) && Objects.equals(this.memoryMiB(), other.memoryMiB()) && this.hasCpuManufacturers() == other.hasCpuManufacturers() && Objects.equals(this.cpuManufacturersAsStrings(), other.cpuManufacturersAsStrings()) && Objects.equals(this.memoryGiBPerVCpu(), other.memoryGiBPerVCpu()) && this.hasExcludedInstanceTypes() == other.hasExcludedInstanceTypes() && Objects.equals(this.excludedInstanceTypes(), other.excludedInstanceTypes()) && this.hasInstanceGenerations() == other.hasInstanceGenerations() && Objects.equals(this.instanceGenerationsAsStrings(), other.instanceGenerationsAsStrings()) && Objects.equals(this.spotMaxPricePercentageOverLowestPrice(), other.spotMaxPricePercentageOverLowestPrice()) && Objects.equals(this.onDemandMaxPricePercentageOverLowestPrice(), other.onDemandMaxPricePercentageOverLowestPrice()) && Objects.equals(this.bareMetalAsString(), other.bareMetalAsString()) && Objects.equals(this.burstablePerformanceAsString(), other.burstablePerformanceAsString()) && Objects.equals(this.requireHibernateSupport(), other.requireHibernateSupport()) && Objects.equals(this.networkInterfaceCount(), other.networkInterfaceCount()) && Objects.equals(this.localStorageAsString(), other.localStorageAsString()) && this.hasLocalStorageTypes() == other.hasLocalStorageTypes() && Objects.equals(this.localStorageTypesAsStrings(), other.localStorageTypesAsStrings()) && Objects.equals(this.totalLocalStorageGB(), other.totalLocalStorageGB()) && Objects.equals(this.baselineEbsBandwidthMbps(), other.baselineEbsBandwidthMbps()) && this.hasAcceleratorTypes() == other.hasAcceleratorTypes() && Objects.equals(this.acceleratorTypesAsStrings(), other.acceleratorTypesAsStrings()) && Objects.equals(this.acceleratorCount(), other.acceleratorCount()) && this.hasAcceleratorManufacturers() == other.hasAcceleratorManufacturers() && Objects.equals(this.acceleratorManufacturersAsStrings(), other.acceleratorManufacturersAsStrings()) && this.hasAcceleratorNames() == other.hasAcceleratorNames() && Objects.equals(this.acceleratorNamesAsStrings(), other.acceleratorNamesAsStrings()) && Objects.equals(this.acceleratorTotalMemoryMiB(), other.acceleratorTotalMemoryMiB());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceRequirements").add("VCpuCount", (Object)this.vCpuCount()).add("MemoryMiB", (Object)this.memoryMiB()).add("CpuManufacturers", this.hasCpuManufacturers() ? this.cpuManufacturersAsStrings() : null).add("MemoryGiBPerVCpu", (Object)this.memoryGiBPerVCpu()).add("ExcludedInstanceTypes", this.hasExcludedInstanceTypes() ? this.excludedInstanceTypes() : null).add("InstanceGenerations", this.hasInstanceGenerations() ? this.instanceGenerationsAsStrings() : null).add("SpotMaxPricePercentageOverLowestPrice", (Object)this.spotMaxPricePercentageOverLowestPrice()).add("OnDemandMaxPricePercentageOverLowestPrice", (Object)this.onDemandMaxPricePercentageOverLowestPrice()).add("BareMetal", (Object)this.bareMetalAsString()).add("BurstablePerformance", (Object)this.burstablePerformanceAsString()).add("RequireHibernateSupport", (Object)this.requireHibernateSupport()).add("NetworkInterfaceCount", (Object)this.networkInterfaceCount()).add("LocalStorage", (Object)this.localStorageAsString()).add("LocalStorageTypes", this.hasLocalStorageTypes() ? this.localStorageTypesAsStrings() : null).add("TotalLocalStorageGB", (Object)this.totalLocalStorageGB()).add("BaselineEbsBandwidthMbps", (Object)this.baselineEbsBandwidthMbps()).add("AcceleratorTypes", this.hasAcceleratorTypes() ? this.acceleratorTypesAsStrings() : null).add("AcceleratorCount", (Object)this.acceleratorCount()).add("AcceleratorManufacturers", this.hasAcceleratorManufacturers() ? this.acceleratorManufacturersAsStrings() : null).add("AcceleratorNames", this.hasAcceleratorNames() ? this.acceleratorNamesAsStrings() : null).add("AcceleratorTotalMemoryMiB", (Object)this.acceleratorTotalMemoryMiB()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VCpuCount": {
                return Optional.ofNullable(clazz.cast(this.vCpuCount()));
            }
            case "MemoryMiB": {
                return Optional.ofNullable(clazz.cast(this.memoryMiB()));
            }
            case "CpuManufacturers": {
                return Optional.ofNullable(clazz.cast(this.cpuManufacturersAsStrings()));
            }
            case "MemoryGiBPerVCpu": {
                return Optional.ofNullable(clazz.cast(this.memoryGiBPerVCpu()));
            }
            case "ExcludedInstanceTypes": {
                return Optional.ofNullable(clazz.cast(this.excludedInstanceTypes()));
            }
            case "InstanceGenerations": {
                return Optional.ofNullable(clazz.cast(this.instanceGenerationsAsStrings()));
            }
            case "SpotMaxPricePercentageOverLowestPrice": {
                return Optional.ofNullable(clazz.cast(this.spotMaxPricePercentageOverLowestPrice()));
            }
            case "OnDemandMaxPricePercentageOverLowestPrice": {
                return Optional.ofNullable(clazz.cast(this.onDemandMaxPricePercentageOverLowestPrice()));
            }
            case "BareMetal": {
                return Optional.ofNullable(clazz.cast(this.bareMetalAsString()));
            }
            case "BurstablePerformance": {
                return Optional.ofNullable(clazz.cast(this.burstablePerformanceAsString()));
            }
            case "RequireHibernateSupport": {
                return Optional.ofNullable(clazz.cast(this.requireHibernateSupport()));
            }
            case "NetworkInterfaceCount": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceCount()));
            }
            case "LocalStorage": {
                return Optional.ofNullable(clazz.cast(this.localStorageAsString()));
            }
            case "LocalStorageTypes": {
                return Optional.ofNullable(clazz.cast(this.localStorageTypesAsStrings()));
            }
            case "TotalLocalStorageGB": {
                return Optional.ofNullable(clazz.cast(this.totalLocalStorageGB()));
            }
            case "BaselineEbsBandwidthMbps": {
                return Optional.ofNullable(clazz.cast(this.baselineEbsBandwidthMbps()));
            }
            case "AcceleratorTypes": {
                return Optional.ofNullable(clazz.cast(this.acceleratorTypesAsStrings()));
            }
            case "AcceleratorCount": {
                return Optional.ofNullable(clazz.cast(this.acceleratorCount()));
            }
            case "AcceleratorManufacturers": {
                return Optional.ofNullable(clazz.cast(this.acceleratorManufacturersAsStrings()));
            }
            case "AcceleratorNames": {
                return Optional.ofNullable(clazz.cast(this.acceleratorNamesAsStrings()));
            }
            case "AcceleratorTotalMemoryMiB": {
                return Optional.ofNullable(clazz.cast(this.acceleratorTotalMemoryMiB()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceRequirements, T> g) {
        return obj -> g.apply((InstanceRequirements)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private VCpuCountRange vCpuCount;
        private MemoryMiB memoryMiB;
        private List<String> cpuManufacturers = DefaultSdkAutoConstructList.getInstance();
        private MemoryGiBPerVCpu memoryGiBPerVCpu;
        private List<String> excludedInstanceTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> instanceGenerations = DefaultSdkAutoConstructList.getInstance();
        private Integer spotMaxPricePercentageOverLowestPrice;
        private Integer onDemandMaxPricePercentageOverLowestPrice;
        private String bareMetal;
        private String burstablePerformance;
        private Boolean requireHibernateSupport;
        private NetworkInterfaceCount networkInterfaceCount;
        private String localStorage;
        private List<String> localStorageTypes = DefaultSdkAutoConstructList.getInstance();
        private TotalLocalStorageGB totalLocalStorageGB;
        private BaselineEbsBandwidthMbps baselineEbsBandwidthMbps;
        private List<String> acceleratorTypes = DefaultSdkAutoConstructList.getInstance();
        private AcceleratorCount acceleratorCount;
        private List<String> acceleratorManufacturers = DefaultSdkAutoConstructList.getInstance();
        private List<String> acceleratorNames = DefaultSdkAutoConstructList.getInstance();
        private AcceleratorTotalMemoryMiB acceleratorTotalMemoryMiB;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceRequirements model) {
            this.vCpuCount(model.vCpuCount);
            this.memoryMiB(model.memoryMiB);
            this.cpuManufacturersWithStrings(model.cpuManufacturers);
            this.memoryGiBPerVCpu(model.memoryGiBPerVCpu);
            this.excludedInstanceTypes(model.excludedInstanceTypes);
            this.instanceGenerationsWithStrings(model.instanceGenerations);
            this.spotMaxPricePercentageOverLowestPrice(model.spotMaxPricePercentageOverLowestPrice);
            this.onDemandMaxPricePercentageOverLowestPrice(model.onDemandMaxPricePercentageOverLowestPrice);
            this.bareMetal(model.bareMetal);
            this.burstablePerformance(model.burstablePerformance);
            this.requireHibernateSupport(model.requireHibernateSupport);
            this.networkInterfaceCount(model.networkInterfaceCount);
            this.localStorage(model.localStorage);
            this.localStorageTypesWithStrings(model.localStorageTypes);
            this.totalLocalStorageGB(model.totalLocalStorageGB);
            this.baselineEbsBandwidthMbps(model.baselineEbsBandwidthMbps);
            this.acceleratorTypesWithStrings(model.acceleratorTypes);
            this.acceleratorCount(model.acceleratorCount);
            this.acceleratorManufacturersWithStrings(model.acceleratorManufacturers);
            this.acceleratorNamesWithStrings(model.acceleratorNames);
            this.acceleratorTotalMemoryMiB(model.acceleratorTotalMemoryMiB);
        }

        public final VCpuCountRange.Builder getVCpuCount() {
            return this.vCpuCount != null ? this.vCpuCount.toBuilder() : null;
        }

        public final void setVCpuCount(VCpuCountRange.BuilderImpl vCpuCount) {
            this.vCpuCount = vCpuCount != null ? vCpuCount.build() : null;
        }

        @Override
        public final Builder vCpuCount(VCpuCountRange vCpuCount) {
            this.vCpuCount = vCpuCount;
            return this;
        }

        public final MemoryMiB.Builder getMemoryMiB() {
            return this.memoryMiB != null ? this.memoryMiB.toBuilder() : null;
        }

        public final void setMemoryMiB(MemoryMiB.BuilderImpl memoryMiB) {
            this.memoryMiB = memoryMiB != null ? memoryMiB.build() : null;
        }

        @Override
        public final Builder memoryMiB(MemoryMiB memoryMiB) {
            this.memoryMiB = memoryMiB;
            return this;
        }

        public final Collection<String> getCpuManufacturers() {
            if (this.cpuManufacturers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.cpuManufacturers;
        }

        public final void setCpuManufacturers(Collection<String> cpuManufacturers) {
            this.cpuManufacturers = CpuManufacturerSetCopier.copy(cpuManufacturers);
        }

        @Override
        public final Builder cpuManufacturersWithStrings(Collection<String> cpuManufacturers) {
            this.cpuManufacturers = CpuManufacturerSetCopier.copy(cpuManufacturers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cpuManufacturersWithStrings(String ... cpuManufacturers) {
            this.cpuManufacturersWithStrings(Arrays.asList(cpuManufacturers));
            return this;
        }

        @Override
        public final Builder cpuManufacturers(Collection<CpuManufacturer> cpuManufacturers) {
            this.cpuManufacturers = CpuManufacturerSetCopier.copyEnumToString(cpuManufacturers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cpuManufacturers(CpuManufacturer ... cpuManufacturers) {
            this.cpuManufacturers(Arrays.asList(cpuManufacturers));
            return this;
        }

        public final MemoryGiBPerVCpu.Builder getMemoryGiBPerVCpu() {
            return this.memoryGiBPerVCpu != null ? this.memoryGiBPerVCpu.toBuilder() : null;
        }

        public final void setMemoryGiBPerVCpu(MemoryGiBPerVCpu.BuilderImpl memoryGiBPerVCpu) {
            this.memoryGiBPerVCpu = memoryGiBPerVCpu != null ? memoryGiBPerVCpu.build() : null;
        }

        @Override
        public final Builder memoryGiBPerVCpu(MemoryGiBPerVCpu memoryGiBPerVCpu) {
            this.memoryGiBPerVCpu = memoryGiBPerVCpu;
            return this;
        }

        public final Collection<String> getExcludedInstanceTypes() {
            if (this.excludedInstanceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.excludedInstanceTypes;
        }

        public final void setExcludedInstanceTypes(Collection<String> excludedInstanceTypes) {
            this.excludedInstanceTypes = ExcludedInstanceTypeSetCopier.copy(excludedInstanceTypes);
        }

        @Override
        public final Builder excludedInstanceTypes(Collection<String> excludedInstanceTypes) {
            this.excludedInstanceTypes = ExcludedInstanceTypeSetCopier.copy(excludedInstanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludedInstanceTypes(String ... excludedInstanceTypes) {
            this.excludedInstanceTypes(Arrays.asList(excludedInstanceTypes));
            return this;
        }

        public final Collection<String> getInstanceGenerations() {
            if (this.instanceGenerations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.instanceGenerations;
        }

        public final void setInstanceGenerations(Collection<String> instanceGenerations) {
            this.instanceGenerations = InstanceGenerationSetCopier.copy(instanceGenerations);
        }

        @Override
        public final Builder instanceGenerationsWithStrings(Collection<String> instanceGenerations) {
            this.instanceGenerations = InstanceGenerationSetCopier.copy(instanceGenerations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGenerationsWithStrings(String ... instanceGenerations) {
            this.instanceGenerationsWithStrings(Arrays.asList(instanceGenerations));
            return this;
        }

        @Override
        public final Builder instanceGenerations(Collection<InstanceGeneration> instanceGenerations) {
            this.instanceGenerations = InstanceGenerationSetCopier.copyEnumToString(instanceGenerations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGenerations(InstanceGeneration ... instanceGenerations) {
            this.instanceGenerations(Arrays.asList(instanceGenerations));
            return this;
        }

        public final Integer getSpotMaxPricePercentageOverLowestPrice() {
            return this.spotMaxPricePercentageOverLowestPrice;
        }

        public final void setSpotMaxPricePercentageOverLowestPrice(Integer spotMaxPricePercentageOverLowestPrice) {
            this.spotMaxPricePercentageOverLowestPrice = spotMaxPricePercentageOverLowestPrice;
        }

        @Override
        public final Builder spotMaxPricePercentageOverLowestPrice(Integer spotMaxPricePercentageOverLowestPrice) {
            this.spotMaxPricePercentageOverLowestPrice = spotMaxPricePercentageOverLowestPrice;
            return this;
        }

        public final Integer getOnDemandMaxPricePercentageOverLowestPrice() {
            return this.onDemandMaxPricePercentageOverLowestPrice;
        }

        public final void setOnDemandMaxPricePercentageOverLowestPrice(Integer onDemandMaxPricePercentageOverLowestPrice) {
            this.onDemandMaxPricePercentageOverLowestPrice = onDemandMaxPricePercentageOverLowestPrice;
        }

        @Override
        public final Builder onDemandMaxPricePercentageOverLowestPrice(Integer onDemandMaxPricePercentageOverLowestPrice) {
            this.onDemandMaxPricePercentageOverLowestPrice = onDemandMaxPricePercentageOverLowestPrice;
            return this;
        }

        public final String getBareMetal() {
            return this.bareMetal;
        }

        public final void setBareMetal(String bareMetal) {
            this.bareMetal = bareMetal;
        }

        @Override
        public final Builder bareMetal(String bareMetal) {
            this.bareMetal = bareMetal;
            return this;
        }

        @Override
        public final Builder bareMetal(BareMetal bareMetal) {
            this.bareMetal(bareMetal == null ? null : bareMetal.toString());
            return this;
        }

        public final String getBurstablePerformance() {
            return this.burstablePerformance;
        }

        public final void setBurstablePerformance(String burstablePerformance) {
            this.burstablePerformance = burstablePerformance;
        }

        @Override
        public final Builder burstablePerformance(String burstablePerformance) {
            this.burstablePerformance = burstablePerformance;
            return this;
        }

        @Override
        public final Builder burstablePerformance(BurstablePerformance burstablePerformance) {
            this.burstablePerformance(burstablePerformance == null ? null : burstablePerformance.toString());
            return this;
        }

        public final Boolean getRequireHibernateSupport() {
            return this.requireHibernateSupport;
        }

        public final void setRequireHibernateSupport(Boolean requireHibernateSupport) {
            this.requireHibernateSupport = requireHibernateSupport;
        }

        @Override
        public final Builder requireHibernateSupport(Boolean requireHibernateSupport) {
            this.requireHibernateSupport = requireHibernateSupport;
            return this;
        }

        public final NetworkInterfaceCount.Builder getNetworkInterfaceCount() {
            return this.networkInterfaceCount != null ? this.networkInterfaceCount.toBuilder() : null;
        }

        public final void setNetworkInterfaceCount(NetworkInterfaceCount.BuilderImpl networkInterfaceCount) {
            this.networkInterfaceCount = networkInterfaceCount != null ? networkInterfaceCount.build() : null;
        }

        @Override
        public final Builder networkInterfaceCount(NetworkInterfaceCount networkInterfaceCount) {
            this.networkInterfaceCount = networkInterfaceCount;
            return this;
        }

        public final String getLocalStorage() {
            return this.localStorage;
        }

        public final void setLocalStorage(String localStorage) {
            this.localStorage = localStorage;
        }

        @Override
        public final Builder localStorage(String localStorage) {
            this.localStorage = localStorage;
            return this;
        }

        @Override
        public final Builder localStorage(LocalStorage localStorage) {
            this.localStorage(localStorage == null ? null : localStorage.toString());
            return this;
        }

        public final Collection<String> getLocalStorageTypes() {
            if (this.localStorageTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.localStorageTypes;
        }

        public final void setLocalStorageTypes(Collection<String> localStorageTypes) {
            this.localStorageTypes = LocalStorageTypeSetCopier.copy(localStorageTypes);
        }

        @Override
        public final Builder localStorageTypesWithStrings(Collection<String> localStorageTypes) {
            this.localStorageTypes = LocalStorageTypeSetCopier.copy(localStorageTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localStorageTypesWithStrings(String ... localStorageTypes) {
            this.localStorageTypesWithStrings(Arrays.asList(localStorageTypes));
            return this;
        }

        @Override
        public final Builder localStorageTypes(Collection<LocalStorageType> localStorageTypes) {
            this.localStorageTypes = LocalStorageTypeSetCopier.copyEnumToString(localStorageTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localStorageTypes(LocalStorageType ... localStorageTypes) {
            this.localStorageTypes(Arrays.asList(localStorageTypes));
            return this;
        }

        public final TotalLocalStorageGB.Builder getTotalLocalStorageGB() {
            return this.totalLocalStorageGB != null ? this.totalLocalStorageGB.toBuilder() : null;
        }

        public final void setTotalLocalStorageGB(TotalLocalStorageGB.BuilderImpl totalLocalStorageGB) {
            this.totalLocalStorageGB = totalLocalStorageGB != null ? totalLocalStorageGB.build() : null;
        }

        @Override
        public final Builder totalLocalStorageGB(TotalLocalStorageGB totalLocalStorageGB) {
            this.totalLocalStorageGB = totalLocalStorageGB;
            return this;
        }

        public final BaselineEbsBandwidthMbps.Builder getBaselineEbsBandwidthMbps() {
            return this.baselineEbsBandwidthMbps != null ? this.baselineEbsBandwidthMbps.toBuilder() : null;
        }

        public final void setBaselineEbsBandwidthMbps(BaselineEbsBandwidthMbps.BuilderImpl baselineEbsBandwidthMbps) {
            this.baselineEbsBandwidthMbps = baselineEbsBandwidthMbps != null ? baselineEbsBandwidthMbps.build() : null;
        }

        @Override
        public final Builder baselineEbsBandwidthMbps(BaselineEbsBandwidthMbps baselineEbsBandwidthMbps) {
            this.baselineEbsBandwidthMbps = baselineEbsBandwidthMbps;
            return this;
        }

        public final Collection<String> getAcceleratorTypes() {
            if (this.acceleratorTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.acceleratorTypes;
        }

        public final void setAcceleratorTypes(Collection<String> acceleratorTypes) {
            this.acceleratorTypes = AcceleratorTypeSetCopier.copy(acceleratorTypes);
        }

        @Override
        public final Builder acceleratorTypesWithStrings(Collection<String> acceleratorTypes) {
            this.acceleratorTypes = AcceleratorTypeSetCopier.copy(acceleratorTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceleratorTypesWithStrings(String ... acceleratorTypes) {
            this.acceleratorTypesWithStrings(Arrays.asList(acceleratorTypes));
            return this;
        }

        @Override
        public final Builder acceleratorTypes(Collection<AcceleratorType> acceleratorTypes) {
            this.acceleratorTypes = AcceleratorTypeSetCopier.copyEnumToString(acceleratorTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceleratorTypes(AcceleratorType ... acceleratorTypes) {
            this.acceleratorTypes(Arrays.asList(acceleratorTypes));
            return this;
        }

        public final AcceleratorCount.Builder getAcceleratorCount() {
            return this.acceleratorCount != null ? this.acceleratorCount.toBuilder() : null;
        }

        public final void setAcceleratorCount(AcceleratorCount.BuilderImpl acceleratorCount) {
            this.acceleratorCount = acceleratorCount != null ? acceleratorCount.build() : null;
        }

        @Override
        public final Builder acceleratorCount(AcceleratorCount acceleratorCount) {
            this.acceleratorCount = acceleratorCount;
            return this;
        }

        public final Collection<String> getAcceleratorManufacturers() {
            if (this.acceleratorManufacturers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.acceleratorManufacturers;
        }

        public final void setAcceleratorManufacturers(Collection<String> acceleratorManufacturers) {
            this.acceleratorManufacturers = AcceleratorManufacturerSetCopier.copy(acceleratorManufacturers);
        }

        @Override
        public final Builder acceleratorManufacturersWithStrings(Collection<String> acceleratorManufacturers) {
            this.acceleratorManufacturers = AcceleratorManufacturerSetCopier.copy(acceleratorManufacturers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceleratorManufacturersWithStrings(String ... acceleratorManufacturers) {
            this.acceleratorManufacturersWithStrings(Arrays.asList(acceleratorManufacturers));
            return this;
        }

        @Override
        public final Builder acceleratorManufacturers(Collection<AcceleratorManufacturer> acceleratorManufacturers) {
            this.acceleratorManufacturers = AcceleratorManufacturerSetCopier.copyEnumToString(acceleratorManufacturers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceleratorManufacturers(AcceleratorManufacturer ... acceleratorManufacturers) {
            this.acceleratorManufacturers(Arrays.asList(acceleratorManufacturers));
            return this;
        }

        public final Collection<String> getAcceleratorNames() {
            if (this.acceleratorNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.acceleratorNames;
        }

        public final void setAcceleratorNames(Collection<String> acceleratorNames) {
            this.acceleratorNames = AcceleratorNameSetCopier.copy(acceleratorNames);
        }

        @Override
        public final Builder acceleratorNamesWithStrings(Collection<String> acceleratorNames) {
            this.acceleratorNames = AcceleratorNameSetCopier.copy(acceleratorNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceleratorNamesWithStrings(String ... acceleratorNames) {
            this.acceleratorNamesWithStrings(Arrays.asList(acceleratorNames));
            return this;
        }

        @Override
        public final Builder acceleratorNames(Collection<AcceleratorName> acceleratorNames) {
            this.acceleratorNames = AcceleratorNameSetCopier.copyEnumToString(acceleratorNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceleratorNames(AcceleratorName ... acceleratorNames) {
            this.acceleratorNames(Arrays.asList(acceleratorNames));
            return this;
        }

        public final AcceleratorTotalMemoryMiB.Builder getAcceleratorTotalMemoryMiB() {
            return this.acceleratorTotalMemoryMiB != null ? this.acceleratorTotalMemoryMiB.toBuilder() : null;
        }

        public final void setAcceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiB.BuilderImpl acceleratorTotalMemoryMiB) {
            this.acceleratorTotalMemoryMiB = acceleratorTotalMemoryMiB != null ? acceleratorTotalMemoryMiB.build() : null;
        }

        @Override
        public final Builder acceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiB acceleratorTotalMemoryMiB) {
            this.acceleratorTotalMemoryMiB = acceleratorTotalMemoryMiB;
            return this;
        }

        public InstanceRequirements build() {
            return new InstanceRequirements(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceRequirements> {
        public Builder vCpuCount(VCpuCountRange var1);

        default public Builder vCpuCount(Consumer<VCpuCountRange.Builder> vCpuCount) {
            return this.vCpuCount((VCpuCountRange)((VCpuCountRange.Builder)VCpuCountRange.builder().applyMutation(vCpuCount)).build());
        }

        public Builder memoryMiB(MemoryMiB var1);

        default public Builder memoryMiB(Consumer<MemoryMiB.Builder> memoryMiB) {
            return this.memoryMiB((MemoryMiB)((MemoryMiB.Builder)MemoryMiB.builder().applyMutation(memoryMiB)).build());
        }

        public Builder cpuManufacturersWithStrings(Collection<String> var1);

        public Builder cpuManufacturersWithStrings(String ... var1);

        public Builder cpuManufacturers(Collection<CpuManufacturer> var1);

        public Builder cpuManufacturers(CpuManufacturer ... var1);

        public Builder memoryGiBPerVCpu(MemoryGiBPerVCpu var1);

        default public Builder memoryGiBPerVCpu(Consumer<MemoryGiBPerVCpu.Builder> memoryGiBPerVCpu) {
            return this.memoryGiBPerVCpu((MemoryGiBPerVCpu)((MemoryGiBPerVCpu.Builder)MemoryGiBPerVCpu.builder().applyMutation(memoryGiBPerVCpu)).build());
        }

        public Builder excludedInstanceTypes(Collection<String> var1);

        public Builder excludedInstanceTypes(String ... var1);

        public Builder instanceGenerationsWithStrings(Collection<String> var1);

        public Builder instanceGenerationsWithStrings(String ... var1);

        public Builder instanceGenerations(Collection<InstanceGeneration> var1);

        public Builder instanceGenerations(InstanceGeneration ... var1);

        public Builder spotMaxPricePercentageOverLowestPrice(Integer var1);

        public Builder onDemandMaxPricePercentageOverLowestPrice(Integer var1);

        public Builder bareMetal(String var1);

        public Builder bareMetal(BareMetal var1);

        public Builder burstablePerformance(String var1);

        public Builder burstablePerformance(BurstablePerformance var1);

        public Builder requireHibernateSupport(Boolean var1);

        public Builder networkInterfaceCount(NetworkInterfaceCount var1);

        default public Builder networkInterfaceCount(Consumer<NetworkInterfaceCount.Builder> networkInterfaceCount) {
            return this.networkInterfaceCount((NetworkInterfaceCount)((NetworkInterfaceCount.Builder)NetworkInterfaceCount.builder().applyMutation(networkInterfaceCount)).build());
        }

        public Builder localStorage(String var1);

        public Builder localStorage(LocalStorage var1);

        public Builder localStorageTypesWithStrings(Collection<String> var1);

        public Builder localStorageTypesWithStrings(String ... var1);

        public Builder localStorageTypes(Collection<LocalStorageType> var1);

        public Builder localStorageTypes(LocalStorageType ... var1);

        public Builder totalLocalStorageGB(TotalLocalStorageGB var1);

        default public Builder totalLocalStorageGB(Consumer<TotalLocalStorageGB.Builder> totalLocalStorageGB) {
            return this.totalLocalStorageGB((TotalLocalStorageGB)((TotalLocalStorageGB.Builder)TotalLocalStorageGB.builder().applyMutation(totalLocalStorageGB)).build());
        }

        public Builder baselineEbsBandwidthMbps(BaselineEbsBandwidthMbps var1);

        default public Builder baselineEbsBandwidthMbps(Consumer<BaselineEbsBandwidthMbps.Builder> baselineEbsBandwidthMbps) {
            return this.baselineEbsBandwidthMbps((BaselineEbsBandwidthMbps)((BaselineEbsBandwidthMbps.Builder)BaselineEbsBandwidthMbps.builder().applyMutation(baselineEbsBandwidthMbps)).build());
        }

        public Builder acceleratorTypesWithStrings(Collection<String> var1);

        public Builder acceleratorTypesWithStrings(String ... var1);

        public Builder acceleratorTypes(Collection<AcceleratorType> var1);

        public Builder acceleratorTypes(AcceleratorType ... var1);

        public Builder acceleratorCount(AcceleratorCount var1);

        default public Builder acceleratorCount(Consumer<AcceleratorCount.Builder> acceleratorCount) {
            return this.acceleratorCount((AcceleratorCount)((AcceleratorCount.Builder)AcceleratorCount.builder().applyMutation(acceleratorCount)).build());
        }

        public Builder acceleratorManufacturersWithStrings(Collection<String> var1);

        public Builder acceleratorManufacturersWithStrings(String ... var1);

        public Builder acceleratorManufacturers(Collection<AcceleratorManufacturer> var1);

        public Builder acceleratorManufacturers(AcceleratorManufacturer ... var1);

        public Builder acceleratorNamesWithStrings(Collection<String> var1);

        public Builder acceleratorNamesWithStrings(String ... var1);

        public Builder acceleratorNames(Collection<AcceleratorName> var1);

        public Builder acceleratorNames(AcceleratorName ... var1);

        public Builder acceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiB var1);

        default public Builder acceleratorTotalMemoryMiB(Consumer<AcceleratorTotalMemoryMiB.Builder> acceleratorTotalMemoryMiB) {
            return this.acceleratorTotalMemoryMiB((AcceleratorTotalMemoryMiB)((AcceleratorTotalMemoryMiB.Builder)AcceleratorTotalMemoryMiB.builder().applyMutation(acceleratorTotalMemoryMiB)).build());
        }
    }
}

