/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.InterfaceProtocolType;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrunkInterfaceAssociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrunkInterfaceAssociation> {
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationId").getter(TrunkInterfaceAssociation.getter(TrunkInterfaceAssociation::associationId)).setter(TrunkInterfaceAssociation.setter(Builder::associationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId").unmarshallLocationName("associationId").build()}).build();
    private static final SdkField<String> BRANCH_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BranchInterfaceId").getter(TrunkInterfaceAssociation.getter(TrunkInterfaceAssociation::branchInterfaceId)).setter(TrunkInterfaceAssociation.setter(Builder::branchInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BranchInterfaceId").unmarshallLocationName("branchInterfaceId").build()}).build();
    private static final SdkField<String> TRUNK_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrunkInterfaceId").getter(TrunkInterfaceAssociation.getter(TrunkInterfaceAssociation::trunkInterfaceId)).setter(TrunkInterfaceAssociation.setter(Builder::trunkInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrunkInterfaceId").unmarshallLocationName("trunkInterfaceId").build()}).build();
    private static final SdkField<String> INTERFACE_PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InterfaceProtocol").getter(TrunkInterfaceAssociation.getter(TrunkInterfaceAssociation::interfaceProtocolAsString)).setter(TrunkInterfaceAssociation.setter(Builder::interfaceProtocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InterfaceProtocol").unmarshallLocationName("interfaceProtocol").build()}).build();
    private static final SdkField<Integer> VLAN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("VlanId").getter(TrunkInterfaceAssociation.getter(TrunkInterfaceAssociation::vlanId)).setter(TrunkInterfaceAssociation.setter(Builder::vlanId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VlanId").unmarshallLocationName("vlanId").build()}).build();
    private static final SdkField<Integer> GRE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("GreKey").getter(TrunkInterfaceAssociation.getter(TrunkInterfaceAssociation::greKey)).setter(TrunkInterfaceAssociation.setter(Builder::greKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GreKey").unmarshallLocationName("greKey").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(TrunkInterfaceAssociation.getter(TrunkInterfaceAssociation::tags)).setter(TrunkInterfaceAssociation.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_ID_FIELD, BRANCH_INTERFACE_ID_FIELD, TRUNK_INTERFACE_ID_FIELD, INTERFACE_PROTOCOL_FIELD, VLAN_ID_FIELD, GRE_KEY_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String associationId;
    private final String branchInterfaceId;
    private final String trunkInterfaceId;
    private final String interfaceProtocol;
    private final Integer vlanId;
    private final Integer greKey;
    private final List<Tag> tags;

    private TrunkInterfaceAssociation(BuilderImpl builder) {
        this.associationId = builder.associationId;
        this.branchInterfaceId = builder.branchInterfaceId;
        this.trunkInterfaceId = builder.trunkInterfaceId;
        this.interfaceProtocol = builder.interfaceProtocol;
        this.vlanId = builder.vlanId;
        this.greKey = builder.greKey;
        this.tags = builder.tags;
    }

    public final String associationId() {
        return this.associationId;
    }

    public final String branchInterfaceId() {
        return this.branchInterfaceId;
    }

    public final String trunkInterfaceId() {
        return this.trunkInterfaceId;
    }

    public final InterfaceProtocolType interfaceProtocol() {
        return InterfaceProtocolType.fromValue(this.interfaceProtocol);
    }

    public final String interfaceProtocolAsString() {
        return this.interfaceProtocol;
    }

    public final Integer vlanId() {
        return this.vlanId;
    }

    public final Integer greKey() {
        return this.greKey;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.associationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.branchInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.trunkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.interfaceProtocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vlanId());
        hashCode = 31 * hashCode + Objects.hashCode(this.greKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrunkInterfaceAssociation)) {
            return false;
        }
        TrunkInterfaceAssociation other = (TrunkInterfaceAssociation)obj;
        return Objects.equals(this.associationId(), other.associationId()) && Objects.equals(this.branchInterfaceId(), other.branchInterfaceId()) && Objects.equals(this.trunkInterfaceId(), other.trunkInterfaceId()) && Objects.equals(this.interfaceProtocolAsString(), other.interfaceProtocolAsString()) && Objects.equals(this.vlanId(), other.vlanId()) && Objects.equals(this.greKey(), other.greKey()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"TrunkInterfaceAssociation").add("AssociationId", (Object)this.associationId()).add("BranchInterfaceId", (Object)this.branchInterfaceId()).add("TrunkInterfaceId", (Object)this.trunkInterfaceId()).add("InterfaceProtocol", (Object)this.interfaceProtocolAsString()).add("VlanId", (Object)this.vlanId()).add("GreKey", (Object)this.greKey()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociationId": {
                return Optional.ofNullable(clazz.cast(this.associationId()));
            }
            case "BranchInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.branchInterfaceId()));
            }
            case "TrunkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.trunkInterfaceId()));
            }
            case "InterfaceProtocol": {
                return Optional.ofNullable(clazz.cast(this.interfaceProtocolAsString()));
            }
            case "VlanId": {
                return Optional.ofNullable(clazz.cast(this.vlanId()));
            }
            case "GreKey": {
                return Optional.ofNullable(clazz.cast(this.greKey()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrunkInterfaceAssociation, T> g) {
        return obj -> g.apply((TrunkInterfaceAssociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String associationId;
        private String branchInterfaceId;
        private String trunkInterfaceId;
        private String interfaceProtocol;
        private Integer vlanId;
        private Integer greKey;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TrunkInterfaceAssociation model) {
            this.associationId(model.associationId);
            this.branchInterfaceId(model.branchInterfaceId);
            this.trunkInterfaceId(model.trunkInterfaceId);
            this.interfaceProtocol(model.interfaceProtocol);
            this.vlanId(model.vlanId);
            this.greKey(model.greKey);
            this.tags(model.tags);
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final String getBranchInterfaceId() {
            return this.branchInterfaceId;
        }

        public final void setBranchInterfaceId(String branchInterfaceId) {
            this.branchInterfaceId = branchInterfaceId;
        }

        @Override
        public final Builder branchInterfaceId(String branchInterfaceId) {
            this.branchInterfaceId = branchInterfaceId;
            return this;
        }

        public final String getTrunkInterfaceId() {
            return this.trunkInterfaceId;
        }

        public final void setTrunkInterfaceId(String trunkInterfaceId) {
            this.trunkInterfaceId = trunkInterfaceId;
        }

        @Override
        public final Builder trunkInterfaceId(String trunkInterfaceId) {
            this.trunkInterfaceId = trunkInterfaceId;
            return this;
        }

        public final String getInterfaceProtocol() {
            return this.interfaceProtocol;
        }

        public final void setInterfaceProtocol(String interfaceProtocol) {
            this.interfaceProtocol = interfaceProtocol;
        }

        @Override
        public final Builder interfaceProtocol(String interfaceProtocol) {
            this.interfaceProtocol = interfaceProtocol;
            return this;
        }

        @Override
        public final Builder interfaceProtocol(InterfaceProtocolType interfaceProtocol) {
            this.interfaceProtocol(interfaceProtocol == null ? null : interfaceProtocol.toString());
            return this;
        }

        public final Integer getVlanId() {
            return this.vlanId;
        }

        public final void setVlanId(Integer vlanId) {
            this.vlanId = vlanId;
        }

        @Override
        public final Builder vlanId(Integer vlanId) {
            this.vlanId = vlanId;
            return this;
        }

        public final Integer getGreKey() {
            return this.greKey;
        }

        public final void setGreKey(Integer greKey) {
            this.greKey = greKey;
        }

        @Override
        public final Builder greKey(Integer greKey) {
            this.greKey = greKey;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public TrunkInterfaceAssociation build() {
            return new TrunkInterfaceAssociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrunkInterfaceAssociation> {
        public Builder associationId(String var1);

        public Builder branchInterfaceId(String var1);

        public Builder trunkInterfaceId(String var1);

        public Builder interfaceProtocol(String var1);

        public Builder interfaceProtocol(InterfaceProtocolType var1);

        public Builder vlanId(Integer var1);

        public Builder greKey(Integer var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

