/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServiceConfigurationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServiceConfigurationsResponse;
import software.amazon.awssdk.services.ec2.model.ServiceConfiguration;

public class DescribeVpcEndpointServiceConfigurationsIterable
implements SdkIterable<DescribeVpcEndpointServiceConfigurationsResponse> {
    private final Ec2Client client;
    private final DescribeVpcEndpointServiceConfigurationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeVpcEndpointServiceConfigurationsIterable(Ec2Client client, DescribeVpcEndpointServiceConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeVpcEndpointServiceConfigurationsResponseFetcher();
    }

    public Iterator<DescribeVpcEndpointServiceConfigurationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ServiceConfiguration> serviceConfigurations() {
        Function<DescribeVpcEndpointServiceConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.serviceConfigurations() != null) {
                return response.serviceConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeVpcEndpointServiceConfigurationsResponseFetcher
    implements SyncPageFetcher<DescribeVpcEndpointServiceConfigurationsResponse> {
        private DescribeVpcEndpointServiceConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeVpcEndpointServiceConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeVpcEndpointServiceConfigurationsResponse nextPage(DescribeVpcEndpointServiceConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeVpcEndpointServiceConfigurationsIterable.this.client.describeVpcEndpointServiceConfigurations(DescribeVpcEndpointServiceConfigurationsIterable.this.firstRequest);
            }
            return DescribeVpcEndpointServiceConfigurationsIterable.this.client.describeVpcEndpointServiceConfigurations((DescribeVpcEndpointServiceConfigurationsRequest)((Object)DescribeVpcEndpointServiceConfigurationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

