/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.DescribeFpgaImagesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFpgaImagesResponse;
import software.amazon.awssdk.services.ec2.model.FpgaImage;

public class DescribeFpgaImagesIterable
implements SdkIterable<DescribeFpgaImagesResponse> {
    private final Ec2Client client;
    private final DescribeFpgaImagesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeFpgaImagesIterable(Ec2Client client, DescribeFpgaImagesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeFpgaImagesResponseFetcher();
    }

    public Iterator<DescribeFpgaImagesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FpgaImage> fpgaImages() {
        Function<DescribeFpgaImagesResponse, Iterator> getIterator = response -> {
            if (response != null && response.fpgaImages() != null) {
                return response.fpgaImages().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeFpgaImagesResponseFetcher
    implements SyncPageFetcher<DescribeFpgaImagesResponse> {
        private DescribeFpgaImagesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeFpgaImagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeFpgaImagesResponse nextPage(DescribeFpgaImagesResponse previousPage) {
            if (previousPage == null) {
                return DescribeFpgaImagesIterable.this.client.describeFpgaImages(DescribeFpgaImagesIterable.this.firstRequest);
            }
            return DescribeFpgaImagesIterable.this.client.describeFpgaImages((DescribeFpgaImagesRequest)((Object)DescribeFpgaImagesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

